/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples.gateway;

import java.io.IOException;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.examples.gateway.Gateway;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.session.Session;
import org.jsmpp.session.SessionStateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoReconnectGateway
implements Gateway {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoReconnectGateway.class);
    private SMPPSession session = null;
    private String remoteIpAddress;
    private int remotePort;
    private BindParameter bindParam;
    private long reconnectInterval = 5000L;

    public AutoReconnectGateway(String remoteIpAddress, int remotePort, BindParameter bindParam) throws IOException {
        this.remoteIpAddress = remoteIpAddress;
        this.remotePort = remotePort;
        this.bindParam = bindParam;
        this.session = this.newSession();
    }

    public static void main(String[] args) throws IOException {
        AutoReconnectGateway gateway = new AutoReconnectGateway("localhost", 8056, new BindParameter(BindType.BIND_TRX, "sms", "sms", "sms", TypeOfNumber.UNKNOWN, NumberingPlanIndicator.ISDN, "8080"));
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    @Override
    public String submitShortMessage(String serviceType, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, TypeOfNumber destAddrTon, NumberingPlanIndicator destAddrNpi, String destinationAddr, ESMClass esmClass, byte protocolId, byte priorityFlag, String scheduleDeliveryTime, String validityPeriod, RegisteredDelivery registeredDelivery, byte replaceIfPresentFlag, DataCoding dataCoding, byte smDefaultMsgId, byte[] shortMessage, OptionalParameter ... optionalParameters) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        return this.getSession().submitShortMessage(serviceType, sourceAddrTon, sourceAddrNpi, sourceAddr, destAddrTon, destAddrNpi, destinationAddr, esmClass, protocolId, priorityFlag, scheduleDeliveryTime, validityPeriod, registeredDelivery, replaceIfPresentFlag, dataCoding, smDefaultMsgId, shortMessage, optionalParameters);
    }

    private SMPPSession newSession() throws IOException {
        SMPPSession tmpSession = new SMPPSession(this.remoteIpAddress, this.remotePort, this.bindParam);
        tmpSession.addSessionStateListener((SessionStateListener)new SessionStateListenerImpl());
        return tmpSession;
    }

    private SMPPSession getSession() throws IOException {
        if (this.session == null) {
            LOGGER.info("Initiate session for the first time to {}:{}", (Object)this.remoteIpAddress, (Object)this.remotePort);
            this.session = this.newSession();
        } else if (!this.session.getSessionState().isBound()) {
            throw new IOException("We have no valid session yet");
        }
        return this.session;
    }

    private void reconnectAfter(final long timeInMillis) {
        new Thread(){

            @Override
            public void run() {
                LOGGER.info("Schedule reconnect after {} millis", (Object)timeInMillis);
                try {
                    Thread.sleep(timeInMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                int attempt = 0;
                while (AutoReconnectGateway.this.session == null || AutoReconnectGateway.this.session.getSessionState().equals((Object)SessionState.CLOSED)) {
                    try {
                        LOGGER.info("Reconnecting attempt #{} ...", (Object)(++attempt));
                        AutoReconnectGateway.this.session = AutoReconnectGateway.this.newSession();
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed opening connection and bind to " + AutoReconnectGateway.this.remoteIpAddress + ":" + AutoReconnectGateway.this.remotePort, (Throwable)e);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }.start();
    }

    private class SessionStateListenerImpl
    implements SessionStateListener {
        private SessionStateListenerImpl() {
        }

        public void onStateChange(SessionState newState, SessionState oldState, Session source) {
            LOGGER.debug("State changed from {} to {}", (Object)oldState, (Object)newState);
            if (newState.equals((Object)SessionState.CLOSED)) {
                LOGGER.info("Session {} closed", (Object)source.getSessionId());
                AutoReconnectGateway.this.reconnectAfter(AutoReconnectGateway.this.reconnectInterval);
            }
        }
    }
}

