/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples.receipts;

import java.nio.charset.Charset;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.bean.DeliveryReceiptStrip;
import org.jsmpp.bean.MessageType;
import org.jsmpp.examples.receipts.CustomDeliveryReceipt;
import org.jsmpp.util.InvalidDeliveryReceiptException;

public class CustomDeliveryReceiptStripper
implements DeliveryReceiptStrip<CustomDeliveryReceipt> {
    private static final CustomDeliveryReceiptStripper instance = new CustomDeliveryReceiptStripper();

    public static CustomDeliveryReceiptStripper getInstance() {
        return instance;
    }

    public CustomDeliveryReceipt strip(DeliverSm deliverSm) throws InvalidDeliveryReceiptException {
        if (MessageType.SMSC_DEL_RECEIPT.containedIn(deliverSm.getEsmClass()) || MessageType.SME_DEL_ACK.containedIn(deliverSm.getEsmClass())) {
            return new CustomDeliveryReceipt(new String(deliverSm.getShortMessage(), Charset.forName("US-ASCII")));
        }
        throw new InvalidDeliveryReceiptException("deliver_sm is not a Delivery Receipt since esm_class value = " + deliverSm.getEsmClass());
    }
}

