/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples.session.connection.socket;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.jsmpp.session.connection.Connection;
import org.jsmpp.session.connection.ConnectionFactory;
import org.jsmpp.session.connection.socket.SocketConnection;

public class TrustStoreSSLSocketConnectionFactory
implements ConnectionFactory {
    private static final String KEY_STORE_PATH = "/Users/pim/github/opentelecoms-org/jsmpp/jsmpp-examples/src/main/resources/ssl/keystore.p12";
    private static final char[] KEY_STORE_PASSWORD = "password".toCharArray();
    private SSLSocketFactory sslSocketFactory;

    public TrustStoreSSLSocketConnectionFactory() {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(new FileInputStream(KEY_STORE_PATH), KEY_STORE_PASSWORD);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            trustManagerFactory.init(keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
            this.sslSocketFactory = sslContext.getSocketFactory();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public Connection createConnection(String host, int port) throws IOException {
        return new SocketConnection(this.sslSocketFactory.createSocket(host, port));
    }
}

