/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.jsmpp.PDUStringException;
import org.jsmpp.session.BindRequest;
import org.jsmpp.session.SMPPServerSession;
import org.jsmpp.session.SMPPServerSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcceptingConnectionAndBindExample {
    private static final Logger log = LoggerFactory.getLogger(AcceptingConnectionAndBindExample.class);

    public static void main(String[] args) {
        int port = 8056;
        try {
            log.info("Listening on port {} ...", (Object)port);
            SMPPServerSessionListener sessionListener = new SMPPServerSessionListener(port);
            SMPPServerSession session = sessionListener.accept();
            log.info("Accept connection");
            try {
                BindRequest request = session.waitForBind(5000L);
                log.info("Received bind request");
                if ("test".equals(request.getSystemId()) && "test".equals(request.getPassword())) {
                    log.info("Accepting bind request, interface version is {}", (Object)request.getInterfaceVersion());
                    request.accept("sys");
                    try {
                        Thread.sleep(20000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } else {
                    log.info("Rejecting bind request");
                    request.reject(14);
                }
            }
            catch (TimeoutException e) {
                log.error("No binding request received after 5000 millisecond", (Throwable)e);
            }
            if (session.getSessionState().isBound()) {
                log.info("Closing session");
                session.unbindAndClose();
            }
            log.info("Closing session listener");
            sessionListener.close();
        }
        catch (PDUStringException e) {
            log.error("PDUStringException", (Throwable)e);
        }
        catch (IOException e) {
            log.error("IOException", (Throwable)e);
        }
    }
}

