/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.examples.session.connection.socket.TrustStoreSSLSocketConnectionFactory;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.session.connection.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAndBindExample {
    private static final Logger log = LoggerFactory.getLogger(OpenAndBindExample.class);

    public static void main(String[] args) throws Exception {
        boolean useSsl = true;
        String host = "localhost";
        int port = 8056;
        try (SMPPSession session = useSsl ? new SMPPSession((ConnectionFactory)new TrustStoreSSLSocketConnectionFactory()) : new SMPPSession();){
            session.setEnquireLinkTimer(30000);
            session.setTransactionTimer(2000L);
            try {
                log.info("Connect and bind to {} port {}{}", new Object[]{host, port, useSsl ? " (SSL)" : ""});
                String systemId = session.connectAndBind(host, port, new BindParameter(BindType.BIND_TRX, "j", "jpwd", "cp", TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, null));
                log.info("Connected with SMSC with system id {}", (Object)systemId);
                log.info("Session interface version: {}", (Object)session.getInterfaceVersion());
                log.info("Local port: {}", (Object)session.getLocalPort());
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    log.debug("Interrupted");
                    Thread.currentThread().interrupt();
                }
            }
            catch (IOException e) {
                log.error("Failed connect and bind to host", (Throwable)e);
            }
            log.debug("Unbind and close session");
            session.unbindAndClose();
        }
    }
}

