/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.DataCodings;
import org.jsmpp.bean.DeliveryReceipt;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.GSMSpecificFeature;
import org.jsmpp.bean.InterfaceVersion;
import org.jsmpp.bean.MessageMode;
import org.jsmpp.bean.MessageType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.PriorityFlag;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.BindRequest;
import org.jsmpp.session.SMPPOutboundSession;
import org.jsmpp.session.Session;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.util.DeliveryReceiptState;
import org.jsmpp.util.MessageIDGenerator;
import org.jsmpp.util.MessageId;
import org.jsmpp.util.RandomDecimalMessageIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAndOutbindExample
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(OpenAndOutbindExample.class);
    private static final String DEFAULT_HOST = "localhost";
    private static final Integer DEFAULT_PORT = 8056;
    private static final String DEFAULT_SYSID = "jsysid";
    private static final String DEFAULT_PASSWORD = "jpwd";
    private static final String DEFAULT_DESTADDR = "62161616";
    private static final String DEFAULT_SOURCEADDR = "1616";
    private static final Long DEFAULT_TRANSACTIONTIMER = 2000L;
    private static final Integer DEFAULT_PROCESSOR_DEGREE = 3;
    private static final Integer DEFAULT_DELIVER_SM_COUNT = 25;
    private SMPPOutboundSession session = new SMPPOutboundSession();
    private MessageIDGenerator messageIDGenerator = new RandomDecimalMessageIDGenerator();
    private String host;
    private int port;
    private String systemId;
    private String password;
    private String sourceAddr;
    private String destinationAddr;
    private int deliverSmCount;
    private AtomicBoolean exit = new AtomicBoolean();

    private OpenAndOutbindExample(String host, int port, String systemId, String password, String sourceAddr, String destinationAddr, int deliverSmCount, long transactionTimer, int pduProcessorDegree) {
        this.host = host;
        this.port = port;
        this.systemId = systemId;
        this.password = password;
        this.sourceAddr = sourceAddr;
        this.destinationAddr = destinationAddr;
        this.deliverSmCount = deliverSmCount;
        this.session.setTransactionTimer(transactionTimer);
        this.session.setPduProcessorDegree(pduProcessorDegree);
    }

    public static void main(String[] args) {
        int deliverSmCount;
        int processorDegree;
        long transactionTimer;
        int port;
        String host = System.getProperty("jsmpp.client.host", DEFAULT_HOST);
        String systemId = System.getProperty("jsmpp.client.systemId", DEFAULT_SYSID);
        String password = System.getProperty("jsmpp.client.password", DEFAULT_PASSWORD);
        String sourceAddr = System.getProperty("jsmpp.client.sourceAddr", DEFAULT_SOURCEADDR);
        String destinationAddr = System.getProperty("jsmpp.client.destinationAddr", DEFAULT_DESTADDR);
        try {
            port = Integer.parseInt(System.getProperty("jsmpp.client.port", DEFAULT_PORT.toString()));
        }
        catch (NumberFormatException e) {
            port = DEFAULT_PORT;
        }
        try {
            transactionTimer = Integer.parseInt(System.getProperty("jsmpp.client.transactionTimer", DEFAULT_TRANSACTIONTIMER.toString()));
        }
        catch (NumberFormatException e) {
            transactionTimer = DEFAULT_TRANSACTIONTIMER;
        }
        log.info("Transaction timer: {} ms", (Object)transactionTimer);
        try {
            processorDegree = Integer.parseInt(System.getProperty("jsmpp.server.procDegree", DEFAULT_PROCESSOR_DEGREE.toString()));
        }
        catch (NumberFormatException e) {
            processorDegree = DEFAULT_PROCESSOR_DEGREE;
        }
        log.info("Processor degree: {}", (Object)processorDegree);
        try {
            deliverSmCount = Integer.parseInt(System.getProperty("jsmpp.server.deliverSmCount", DEFAULT_DELIVER_SM_COUNT.toString()));
        }
        catch (NumberFormatException e) {
            deliverSmCount = DEFAULT_DELIVER_SM_COUNT;
        }
        log.info("Number of deliver_sm to send: {}", (Object)deliverSmCount);
        OpenAndOutbindExample openAndOutbindExample = new OpenAndOutbindExample(host, port, systemId, password, sourceAddr, destinationAddr, deliverSmCount, transactionTimer, processorDegree);
        openAndOutbindExample.run();
    }

    private void shutdown() {
        this.exit.set(true);
    }

    @Override
    public void run() {
        try {
            this.session.addSessionStateListener((SessionStateListener)new SessionStateListenerImpl());
            log.info("Connect and outbind to {} port {}", (Object)this.host, (Object)this.port);
            BindRequest bindRequest = this.session.connectAndOutbind(this.host, this.port, this.systemId, this.password);
            log.info("Received bind request system_id:'{}' password:'{}", (Object)bindRequest.getSystemId(), (Object)bindRequest.getPassword());
            try {
                bindRequest.accept("sys", InterfaceVersion.IF_34);
            }
            catch (PDUStringException e) {
                log.error("Invalid system id", (Throwable)e);
                bindRequest.reject(8);
            }
        }
        catch (IOException e) {
            log.error("Failed initialize connection, outbind, or bind", (Throwable)e);
            return;
        }
        int count = 0;
        while (!this.exit.get() && count < this.deliverSmCount) {
            ++this.deliverSmCount;
            try {
                MessageId messageId = this.messageIDGenerator.newMessageId();
                DeliveryReceipt delRec = new DeliveryReceipt(messageId.getValue(), 1, 1, new Date(), new Date(), DeliveryReceiptState.DELIVRD, "000", "#" + count);
                this.session.deliverShortMessage("cm", TypeOfNumber.INTERNATIONAL, NumberingPlanIndicator.ISDN, this.sourceAddr, TypeOfNumber.INTERNATIONAL, NumberingPlanIndicator.ISDN, this.destinationAddr, new ESMClass(MessageMode.DEFAULT, MessageType.SMSC_DEL_RECEIPT, GSMSpecificFeature.DEFAULT), (byte)0, PriorityFlag.GsmSms.NORMAL.value(), new RegisteredDelivery(0), DataCodings.ZERO, delRec.toString().getBytes("ISO-8859-1"), new OptionalParameter[0]);
                log.info("The deliver_sm request #{} with message id {} was sent", (Object)count, (Object)messageId);
            }
            catch (IllegalStateException e) {
                log.info("The deliver_sm request #{} was sent", (Object)this.deliverSmCount);
            }
            catch (PDUException e) {
                log.error("PDUException error", (Throwable)e);
            }
            catch (ResponseTimeoutException e) {
                log.warn("Response reached timeout", (Throwable)e);
            }
            catch (InvalidResponseException e) {
                log.warn("Invalid response received", (Throwable)e);
            }
            catch (NegativeResponseException e) {
                log.warn("Negative response received", (Throwable)e);
            }
            catch (IOException e) {
                log.warn("I/O exception", (Throwable)e);
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                log.error("SMPP Server simulator was interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            if (this.session.getSessionState().isBound()) continue;
            this.shutdown();
        }
        log.info("Outbind session ended");
        this.session.unbindAndClose();
    }

    private static class SessionStateListenerImpl
    implements SessionStateListener {
        private SessionStateListenerImpl() {
        }

        public void onStateChange(SessionState newState, SessionState oldState, Session source) {
            log.info("Session {} state changed from {} to {}", new Object[]{source.getSessionId(), oldState, newState});
        }
    }
}

