/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.BroadcastSm;
import org.jsmpp.bean.CancelBroadcastSm;
import org.jsmpp.bean.CancelSm;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.QueryBroadcastSm;
import org.jsmpp.bean.QuerySm;
import org.jsmpp.bean.ReplaceSm;
import org.jsmpp.bean.SubmitMulti;
import org.jsmpp.bean.SubmitSm;
import org.jsmpp.bean.UnsuccessDelivery;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.session.BindRequest;
import org.jsmpp.session.BroadcastSmResult;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.QueryBroadcastSmResult;
import org.jsmpp.session.QuerySmResult;
import org.jsmpp.session.SMPPServerSession;
import org.jsmpp.session.SMPPServerSessionListener;
import org.jsmpp.session.ServerMessageReceiverListener;
import org.jsmpp.session.Session;
import org.jsmpp.session.SubmitMultiResult;
import org.jsmpp.session.SubmitSmResult;
import org.jsmpp.util.MessageIDGenerator;
import org.jsmpp.util.RandomMessageIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveSubmittedMessageExample {
    private static final Logger log = LoggerFactory.getLogger(ReceiveSubmittedMessageExample.class);

    public static void main(String[] args) {
        try {
            RandomMessageIDGenerator messageIdGenerator = new RandomMessageIDGenerator();
            ServerMessageReceiverListener messageReceiverListener = new ServerMessageReceiverListener((MessageIDGenerator)messageIdGenerator){
                final /* synthetic */ MessageIDGenerator val$messageIdGenerator;
                {
                    this.val$messageIdGenerator = messageIDGenerator;
                }

                public SubmitSmResult onAcceptSubmitSm(SubmitSm submitSm, SMPPServerSession source) throws ProcessRequestException {
                    log.info("Receiving message : {}", (Object)new String(submitSm.getShortMessage()));
                    return new SubmitSmResult(this.val$messageIdGenerator.newMessageId(), new OptionalParameter[0]);
                }

                public QuerySmResult onAcceptQuerySm(QuerySm querySm, SMPPServerSession source) throws ProcessRequestException {
                    return null;
                }

                public SubmitMultiResult onAcceptSubmitMulti(SubmitMulti submitMulti, SMPPServerSession source) throws ProcessRequestException {
                    return new SubmitMultiResult(this.val$messageIdGenerator.newMessageId().getValue(), new UnsuccessDelivery[0], new OptionalParameter[0]);
                }

                public DataSmResult onAcceptDataSm(DataSm dataSm, Session source) throws ProcessRequestException {
                    return new DataSmResult(this.val$messageIdGenerator.newMessageId(), new OptionalParameter[0]);
                }

                public void onAcceptCancelSm(CancelSm cancelSm, SMPPServerSession source) throws ProcessRequestException {
                }

                public void onAcceptReplaceSm(ReplaceSm replaceSm, SMPPServerSession source) throws ProcessRequestException {
                }

                public BroadcastSmResult onAcceptBroadcastSm(BroadcastSm broadcastSm, SMPPServerSession source) throws ProcessRequestException {
                    return new BroadcastSmResult(this.val$messageIdGenerator.newMessageId(), new OptionalParameter[0]);
                }

                public void onAcceptCancelBroadcastSm(CancelBroadcastSm cancelBroadcastSm, SMPPServerSession source) throws ProcessRequestException {
                }

                public QueryBroadcastSmResult onAcceptQueryBroadcastSm(QueryBroadcastSm queryBroadcastSm, SMPPServerSession source) throws ProcessRequestException {
                    return null;
                }
            };
            log.info("Listening ...");
            SMPPServerSessionListener sessionListener = new SMPPServerSessionListener(8056);
            sessionListener.setMessageReceiverListener(messageReceiverListener);
            SMPPServerSession session = sessionListener.accept();
            log.info("Accept connection");
            try {
                BindRequest request = session.waitForBind(5000L);
                log.info("Receive bind request for system id {} and password {}", (Object)request.getSystemId(), (Object)request.getPassword());
                if ("test".equals(request.getSystemId()) && "test".equals(request.getPassword())) {
                    log.info("Accepting bind request");
                    request.accept("sys");
                    try {
                        Thread.sleep(20000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } else {
                    log.info("Rejecting bind request");
                    request.reject(14);
                }
            }
            catch (TimeoutException e) {
                log.error("No binding request made after 5000 millisecond", (Throwable)e);
            }
            log.info("Closing session");
            session.unbindAndClose();
            log.info("Closing session listener");
            sessionListener.close();
        }
        catch (PDUStringException e) {
            log.error("PDUString exception", (Throwable)e);
        }
        catch (IOException e) {
            log.error("I/O exception", (Throwable)e);
        }
    }
}

