/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.BroadcastSm;
import org.jsmpp.bean.CancelBroadcastSm;
import org.jsmpp.bean.CancelSm;
import org.jsmpp.bean.DataCodings;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliveryReceipt;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.GSMSpecificFeature;
import org.jsmpp.bean.InterfaceVersion;
import org.jsmpp.bean.MessageMode;
import org.jsmpp.bean.MessageType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.QueryBroadcastSm;
import org.jsmpp.bean.QuerySm;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.ReplaceSm;
import org.jsmpp.bean.SMSCDeliveryReceipt;
import org.jsmpp.bean.SubmitMulti;
import org.jsmpp.bean.SubmitSm;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.bean.UnsuccessDelivery;
import org.jsmpp.examples.session.connection.socket.KeyStoreSSLServerSocketConnectionFactory;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.BindRequest;
import org.jsmpp.session.BroadcastSmResult;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.QueryBroadcastSmResult;
import org.jsmpp.session.QuerySmResult;
import org.jsmpp.session.SMPPServerSession;
import org.jsmpp.session.SMPPServerSessionListener;
import org.jsmpp.session.ServerMessageReceiverListener;
import org.jsmpp.session.ServerResponseDeliveryAdapter;
import org.jsmpp.session.ServerResponseDeliveryListener;
import org.jsmpp.session.Session;
import org.jsmpp.session.SubmitMultiResult;
import org.jsmpp.session.SubmitSmResult;
import org.jsmpp.session.connection.ServerConnectionFactory;
import org.jsmpp.util.DeliveryReceiptState;
import org.jsmpp.util.MessageIDGenerator;
import org.jsmpp.util.MessageId;
import org.jsmpp.util.RandomMessageIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPPServerSimulator
extends ServerResponseDeliveryAdapter
implements Runnable,
ServerMessageReceiverListener {
    private static final Logger log = LoggerFactory.getLogger(SMPPServerSimulator.class);
    private static final String QUERYSM_NOT_IMPLEMENTED = "query_sm not implemented";
    private static final String CANCELSM_NOT_IMPLEMENTED = "cancel_sm not implemented";
    private static final String DATASM_NOT_IMPLEMENTED = "data_sm not implemented";
    private static final String REPLACESM_NOT_IMPLEMENTED = "replace_sm not implemented";
    private static final String BROADCASTSM_NOT_IMPLEMENTED = "broadcast_sm not implemented";
    private static final String CANCELBROADCASTSM_NOT_IMPLEMENTED = "cancel_broadcast_sm not implemented";
    private static final String QUERYBROADCASTSM_NOT_IMPLEMENTED = "query_broadcast_sm not implemented";
    private static final Integer DEFAULT_PORT = 8056;
    private static final String DEFAULT_SYSID = "j";
    private static final String DEFAULT_PASSWORD = "jpwd";
    private static final String SMSC_SYSTEMID = "sys";
    private final ExecutorService execService = Executors.newFixedThreadPool(5);
    private final ExecutorService execServiceDelReceipt = Executors.newFixedThreadPool(100);
    private final MessageIDGenerator messageIDGenerator = new RandomMessageIDGenerator();
    private final boolean useSsl;
    private final int port;
    private final String systemId;
    private final String password;

    public SMPPServerSimulator(boolean useSsl, int port, String systemId, String password) {
        this.useSsl = useSsl;
        this.port = port;
        this.systemId = systemId;
        this.password = password;
    }

    @Override
    public void run() {
        boolean running = true;
        try (SMPPServerSessionListener sessionListener = this.useSsl ? new SMPPServerSessionListener(this.port, (ServerConnectionFactory)new KeyStoreSSLServerSocketConnectionFactory()) : new SMPPServerSessionListener(this.port);){
            log.info("Listening on port {}{}", (Object)this.port, (Object)(this.useSsl ? " (SSL)" : ""));
            while (running) {
                SMPPServerSession serverSession = sessionListener.accept();
                log.info("Accepted connection with session {}", (Object)serverSession.getSessionId());
                serverSession.setMessageReceiverListener((ServerMessageReceiverListener)this);
                serverSession.setResponseDeliveryListener((ServerResponseDeliveryListener)this);
                Future<Boolean> bindResult = this.execService.submit(new WaitBindTask(serverSession, 30000L, this.systemId, this.password));
                try {
                    boolean bound = bindResult.get();
                    if (!bound) continue;
                    log.info("The session is now in state {}", (Object)serverSession.getSessionState());
                    serverSession.deliverShortMessage("CMT", TypeOfNumber.INTERNATIONAL, NumberingPlanIndicator.ISDN, "555", TypeOfNumber.INTERNATIONAL, NumberingPlanIndicator.ISDN, "12345", new ESMClass(0), (byte)0, (byte)0, new RegisteredDelivery(), DataCodings.ZERO, "Hello World".getBytes(), new OptionalParameter[0]);
                }
                catch (InterruptedException e) {
                    log.info("Interrupted WaitBind task: {}", (Object)e.getMessage());
                    Thread.currentThread().interrupt();
                    running = false;
                }
                catch (ExecutionException e) {
                    log.info("Exception on execute WaitBind task: {}", (Object)e.getMessage());
                    running = false;
                }
                catch (InvalidResponseException | PDUException | NegativeResponseException | ResponseTimeoutException e) {
                    log.info("Could not send deliver_sm: {}", (Object)e.getMessage());
                }
            }
        }
        catch (IOException e) {
            log.error("IO error occurred", (Throwable)e);
        }
    }

    public QuerySmResult onAcceptQuerySm(QuerySm querySm, SMPPServerSession source) throws ProcessRequestException {
        log.info("QuerySm not implemented");
        throw new ProcessRequestException(QUERYSM_NOT_IMPLEMENTED, 3);
    }

    public SubmitSmResult onAcceptSubmitSm(SubmitSm submitSm, SMPPServerSession source) throws ProcessRequestException {
        MessageId messageId = this.messageIDGenerator.newMessageId();
        log.info("Receiving submit_sm '{}', and return message id {}", (Object)new String(submitSm.getShortMessage()), (Object)messageId);
        if (SMSCDeliveryReceipt.FAILURE.containedIn(submitSm.getRegisteredDelivery()) || SMSCDeliveryReceipt.SUCCESS_FAILURE.containedIn(submitSm.getRegisteredDelivery())) {
            this.execServiceDelReceipt.execute(new DeliveryReceiptTask(source, submitSm, messageId));
        }
        if (source.getInterfaceVersion().value() >= InterfaceVersion.IF_50.value()) {
            int congestionRatio = source.getCongestionRatio();
            OptionalParameter.Congestion_state congestionState = new OptionalParameter.Congestion_state((byte)congestionRatio);
            return new SubmitSmResult(messageId, new OptionalParameter[]{congestionState});
        }
        return new SubmitSmResult(messageId, new OptionalParameter[0]);
    }

    public void onSubmitSmRespSent(SubmitSmResult submitSmResult, SMPPServerSession source) {
        log.debug("submit_sm_resp with message_id {} has been sent", (Object)submitSmResult.getMessageId());
    }

    public SubmitMultiResult onAcceptSubmitMulti(SubmitMulti submitMulti, SMPPServerSession source) throws ProcessRequestException {
        MessageId messageId = this.messageIDGenerator.newMessageId();
        log.debug("Receiving submit_multi_sm '{}', and return message id {}", (Object)new String(submitMulti.getShortMessage()), (Object)messageId);
        if (SMSCDeliveryReceipt.FAILURE.containedIn(submitMulti.getRegisteredDelivery()) || SMSCDeliveryReceipt.SUCCESS_FAILURE.containedIn(submitMulti.getRegisteredDelivery())) {
            this.execServiceDelReceipt.execute(new DeliveryReceiptTask(source, submitMulti, messageId));
        }
        if (source.getInterfaceVersion().value() >= InterfaceVersion.IF_50.value()) {
            int congestionRatio = source.getCongestionRatio();
            OptionalParameter.Congestion_state congestionState = new OptionalParameter.Congestion_state((byte)congestionRatio);
            return new SubmitMultiResult(messageId.getValue(), new UnsuccessDelivery[0], new OptionalParameter[]{congestionState});
        }
        return new SubmitMultiResult(messageId.getValue(), new UnsuccessDelivery[0], new OptionalParameter[0]);
    }

    public DataSmResult onAcceptDataSm(DataSm dataSm, Session source) throws ProcessRequestException {
        log.info("Accepting data_sm, but not implemented");
        throw new ProcessRequestException(DATASM_NOT_IMPLEMENTED, 8);
    }

    public void onAcceptCancelSm(CancelSm cancelSm, SMPPServerSession source) throws ProcessRequestException {
        log.info("Accepting cancel_sm, but not implemented");
        throw new ProcessRequestException(CANCELSM_NOT_IMPLEMENTED, 17);
    }

    public void onAcceptReplaceSm(ReplaceSm replaceSm, SMPPServerSession source) throws ProcessRequestException {
        log.info("Accepting replace_sm, but not implemented");
        throw new ProcessRequestException(REPLACESM_NOT_IMPLEMENTED, 19);
    }

    public BroadcastSmResult onAcceptBroadcastSm(BroadcastSm broadcastSm, SMPPServerSession source) throws ProcessRequestException {
        MessageId messageId = this.messageIDGenerator.newMessageId();
        log.debug("Receiving broadcast_sm '{}', and return message id {}", (Object)new String(broadcastSm.getOptionalParameter(OptionalParameter.Tag.MESSAGE_PAYLOAD).serialize()), (Object)messageId);
        return new BroadcastSmResult(messageId, new OptionalParameter[0]);
    }

    public void onAcceptCancelBroadcastSm(CancelBroadcastSm cancelBroadcastSm, SMPPServerSession source) throws ProcessRequestException {
        log.info("Accepting cancel_broadcast_sm, but not implemented");
        throw new ProcessRequestException(CANCELBROADCASTSM_NOT_IMPLEMENTED, 271);
    }

    public QueryBroadcastSmResult onAcceptQueryBroadcastSm(QueryBroadcastSm queryBroadcastSm, SMPPServerSession source) throws ProcessRequestException {
        log.info("Accepting query_broadcast_sm, but not implemented");
        throw new ProcessRequestException(QUERYBROADCASTSM_NOT_IMPLEMENTED, 270);
    }

    public static void main(String[] args) {
        int port;
        String systemId = System.getProperty("jsmpp.client.systemId", DEFAULT_SYSID);
        String password = System.getProperty("jsmpp.client.password", DEFAULT_PASSWORD);
        try {
            port = Integer.parseInt(System.getProperty("jsmpp.simulator.port", DEFAULT_PORT.toString()));
        }
        catch (NumberFormatException e) {
            port = DEFAULT_PORT;
        }
        boolean useSsl = Boolean.parseBoolean(System.getProperty("jsmpp.simulator.ssl", "false"));
        SMPPServerSimulator smppServerSim = new SMPPServerSimulator(useSsl, port, systemId, password);
        smppServerSim.run();
    }

    private static class DeliveryReceiptTask
    implements Runnable {
        private final SMPPServerSession session;
        private final MessageId messageId;
        private final TypeOfNumber sourceAddrTon;
        private final NumberingPlanIndicator sourceAddrNpi;
        private final String sourceAddress;
        private final TypeOfNumber destAddrTon;
        private final NumberingPlanIndicator destAddrNpi;
        private final String destAddress;
        private final int totalSubmitted;
        private final int totalDelivered;
        private final byte[] shortMessage;

        public DeliveryReceiptTask(SMPPServerSession session, SubmitSm submitSm, MessageId messageId) {
            this.session = session;
            this.messageId = messageId;
            this.sourceAddrTon = TypeOfNumber.valueOf((byte)submitSm.getDestAddrTon());
            this.sourceAddrNpi = NumberingPlanIndicator.valueOf((byte)submitSm.getDestAddrNpi());
            this.sourceAddress = submitSm.getDestAddress();
            this.destAddrTon = TypeOfNumber.valueOf((byte)submitSm.getSourceAddrTon());
            this.destAddrNpi = NumberingPlanIndicator.valueOf((byte)submitSm.getSourceAddrNpi());
            this.destAddress = submitSm.getSourceAddr();
            this.totalDelivered = 1;
            this.totalSubmitted = 1;
            this.shortMessage = submitSm.getShortMessage();
        }

        public DeliveryReceiptTask(SMPPServerSession session, SubmitMulti submitMulti, MessageId messageId) {
            this.session = session;
            this.messageId = messageId;
            this.sourceAddrTon = TypeOfNumber.UNKNOWN;
            this.sourceAddrNpi = NumberingPlanIndicator.UNKNOWN;
            this.sourceAddress = null;
            this.destAddrTon = TypeOfNumber.valueOf((byte)submitMulti.getSourceAddrTon());
            this.destAddrNpi = NumberingPlanIndicator.valueOf((byte)submitMulti.getSourceAddrNpi());
            this.destAddress = submitMulti.getSourceAddr();
            this.totalSubmitted = this.totalDelivered = submitMulti.getDestAddresses().length;
            this.shortMessage = submitMulti.getShortMessage();
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.error("Interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            SessionState state = this.session.getSessionState();
            if (!state.isReceivable()) {
                log.debug("Not sending delivery receipt for message id {} since session state is {}", (Object)this.messageId, (Object)state);
                return;
            }
            String stringValue = Integer.valueOf(this.messageId.getValue(), 16).toString();
            try {
                DeliveryReceipt delRec = new DeliveryReceipt(stringValue, this.totalSubmitted, this.totalDelivered, new Date(), new Date(), DeliveryReceiptState.DELIVRD, "000", new String(this.shortMessage));
                this.session.deliverShortMessage("mc", this.sourceAddrTon, this.sourceAddrNpi, this.sourceAddress, this.destAddrTon, this.destAddrNpi, this.destAddress, new ESMClass(MessageMode.DEFAULT, MessageType.SMSC_DEL_RECEIPT, GSMSpecificFeature.DEFAULT), (byte)0, (byte)0, new RegisteredDelivery(0), DataCodings.ZERO, delRec.toString().getBytes(), new OptionalParameter[0]);
                log.debug("Sending delivery receipt for message id {}: {}", (Object)this.messageId, (Object)stringValue);
            }
            catch (Exception e) {
                log.error("Failed sending delivery_receipt for message id " + this.messageId + ":" + stringValue, (Throwable)e);
            }
        }
    }

    private static class WaitBindTask
    implements Callable<Boolean> {
        private final SMPPServerSession serverSession;
        private final long timeout;
        private final String systemId;
        private final String password;

        public WaitBindTask(SMPPServerSession serverSession, long timeout, String systemId, String password) {
            this.serverSession = serverSession;
            this.timeout = timeout;
            this.systemId = systemId;
            this.password = password;
        }

        @Override
        public Boolean call() {
            block10: {
                try {
                    BindRequest bindRequest = this.serverSession.waitForBind(this.timeout);
                    try {
                        if (BindType.BIND_TRX.equals((Object)bindRequest.getBindType())) {
                            if (this.systemId.equals(bindRequest.getSystemId())) {
                                if (this.password.equals(bindRequest.getPassword())) {
                                    log.info("Accepting bind for session {}, interface version {}", (Object)this.serverSession.getSessionId(), (Object)bindRequest.getInterfaceVersion());
                                    this.serverSession.setInterfaceVersion(InterfaceVersion.IF_50.min(bindRequest.getInterfaceVersion()));
                                    bindRequest.accept(SMPPServerSimulator.SMSC_SYSTEMID, InterfaceVersion.IF_50);
                                    return true;
                                }
                                log.info("Rejecting bind for session {}, interface version {}, invalid password", (Object)this.serverSession.getSessionId(), (Object)bindRequest.getInterfaceVersion());
                                bindRequest.reject(14);
                            } else {
                                log.info("Rejecting bind for session {}, interface version {}, invalid system id", (Object)this.serverSession.getSessionId(), (Object)bindRequest.getInterfaceVersion());
                                bindRequest.reject(15);
                            }
                            break block10;
                        }
                        log.info("Rejecting bind for session {}, interface version {}, only accept transceiver", (Object)this.serverSession.getSessionId(), (Object)bindRequest.getInterfaceVersion());
                        bindRequest.reject(13);
                    }
                    catch (PDUStringException e) {
                        log.error("Invalid system id: sys", (Throwable)e);
                        bindRequest.reject(8);
                    }
                }
                catch (IllegalStateException e) {
                    log.error("System error", (Throwable)e);
                }
                catch (TimeoutException e) {
                    log.warn("Wait for bind has reach timeout", (Throwable)e);
                }
                catch (IOException e) {
                    log.error("Failed accepting bind request for session {}", (Object)this.serverSession.getSessionId());
                }
            }
            return false;
        }
    }
}

