/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.util.Date;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.DataCodings;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.SMSCDeliveryReceipt;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.examples.MessageReceiverListenerImpl;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.MessageReceiverListener;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.session.SubmitSmResult;
import org.jsmpp.util.AbsoluteTimeFormatter;
import org.jsmpp.util.TimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSubmitRegisteredExample {
    private static final Logger log = LoggerFactory.getLogger(SimpleSubmitRegisteredExample.class);
    private static final TimeFormatter TIME_FORMATTER = new AbsoluteTimeFormatter();

    public static void main(String[] args) {
        SMPPSession session = new SMPPSession();
        session.setMessageReceiverListener((MessageReceiverListener)new MessageReceiverListenerImpl());
        try {
            String systemId = session.connectAndBind("localhost", 8056, new BindParameter(BindType.BIND_TRX, "test", "test", "cp", TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, null));
            log.info("Connected with SMSC with system id {}", (Object)systemId);
            try {
                SubmitSmResult submitSmResult = session.submitShortMessage("CMT", TypeOfNumber.INTERNATIONAL, NumberingPlanIndicator.UNKNOWN, "1616", TypeOfNumber.INTERNATIONAL, NumberingPlanIndicator.UNKNOWN, "628176504657", new ESMClass(), (byte)0, (byte)1, TIME_FORMATTER.format(new Date()), null, new RegisteredDelivery(SMSCDeliveryReceipt.SUCCESS_FAILURE), (byte)0, DataCodings.ZERO, (byte)0, "jSMPP simplify SMPP on Java platform".getBytes(), new OptionalParameter[0]);
                String messageId = submitSmResult.getMessageId();
                log.info("Message submitted, message_id is {}", (Object)messageId);
                Thread.sleep(2000L);
            }
            catch (PDUException e) {
                log.error("Invalid PDU parameter", (Throwable)e);
            }
            catch (ResponseTimeoutException e) {
                log.error("Response timeout", (Throwable)e);
            }
            catch (InvalidResponseException e) {
                log.error("Receive invalid response", (Throwable)e);
            }
            catch (NegativeResponseException e) {
                log.error("Receive negative response", (Throwable)e);
            }
            catch (IOException e) {
                log.error("I/O error occurred", (Throwable)e);
            }
            catch (InterruptedException e) {
                log.error("Thread interrupted", (Throwable)e);
            }
            session.unbindAndClose();
        }
        catch (IOException e) {
            log.error("Failed connect and bind to host", (Throwable)e);
        }
    }
}

