/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.DataCodings;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.InterfaceVersion;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.OptionalParameters;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.session.SubmitSmResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StressClient
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(StressClient.class);
    private static final String DEFAULT_SYSID = "j";
    private static final String DEFAULT_PASSWORD = "jpwd";
    private static final String DEFAULT_SOURCEADDR = "1616";
    private static final String DEFAULT_DESTADDR = "62161616";
    private static final String DEFAULT_HOST = "localhost";
    private static final Integer DEFAULT_PORT = 8056;
    private static final Long DEFAULT_TRANSACTIONTIMER = 2000L;
    private static final Integer DEFAULT_BULK_SIZE = 100000;
    private static final Integer DEFAULT_PROCESSOR_DEGREE = 10;
    private static final Integer DEFAULT_MAX_OUTSTANDING = 100;
    private final int id;
    private final String host;
    private final int port;
    private final int bulkSize;
    private final String systemId;
    private final String password;
    private final String sourceAddr;
    private final String destinationAddr;
    private AtomicInteger requestCounter = new AtomicInteger();
    private AtomicInteger totalRequestCounter = new AtomicInteger();
    private AtomicInteger responseCounter = new AtomicInteger();
    private AtomicInteger totalResponseCounter = new AtomicInteger();
    private AtomicLong maxDelay = new AtomicLong();
    private ExecutorService execService;
    private SMPPSession smppSession = new SMPPSession();
    private AtomicBoolean exit = new AtomicBoolean();

    public StressClient(int id, String host, int port, int bulkSize, String systemId, String password, String sourceAddr, String destinationAddr, long transactionTimer, int pduProcessorDegree, int maxOutstanding) {
        this.id = id;
        this.host = host;
        this.port = port;
        this.bulkSize = bulkSize;
        this.systemId = systemId;
        this.password = password;
        this.sourceAddr = sourceAddr;
        this.destinationAddr = destinationAddr;
        this.smppSession.setPduProcessorDegree(pduProcessorDegree);
        this.smppSession.setTransactionTimer(transactionTimer);
        this.execService = Executors.newFixedThreadPool(maxOutstanding);
    }

    public static void main(String[] args) {
        int maxOutstanding;
        int processorDegree;
        int bulkSize;
        long transactionTimer;
        int port;
        String host = System.getProperty("jsmpp.client.host", DEFAULT_HOST);
        String systemId = System.getProperty("jsmpp.client.systemId", DEFAULT_SYSID);
        String password = System.getProperty("jsmpp.client.password", DEFAULT_PASSWORD);
        String sourceAddr = System.getProperty("jsmpp.client.sourceAddr", DEFAULT_SOURCEADDR);
        String destinationAddr = System.getProperty("jsmpp.client.destinationAddr", DEFAULT_DESTADDR);
        try {
            port = Integer.parseInt(System.getProperty("jsmpp.client.port", DEFAULT_PORT.toString()));
        }
        catch (NumberFormatException e) {
            port = DEFAULT_PORT;
        }
        try {
            transactionTimer = Integer.parseInt(System.getProperty("jsmpp.client.transactionTimer", DEFAULT_TRANSACTIONTIMER.toString()));
        }
        catch (NumberFormatException e) {
            transactionTimer = DEFAULT_TRANSACTIONTIMER;
        }
        try {
            bulkSize = Integer.parseInt(System.getProperty("jsmpp.client.bulkSize", DEFAULT_BULK_SIZE.toString()));
        }
        catch (NumberFormatException e) {
            bulkSize = DEFAULT_BULK_SIZE;
        }
        try {
            processorDegree = Integer.parseInt(System.getProperty("jsmpp.client.procDegree", DEFAULT_PROCESSOR_DEGREE.toString()));
        }
        catch (NumberFormatException e) {
            processorDegree = DEFAULT_PROCESSOR_DEGREE;
        }
        try {
            maxOutstanding = Integer.parseInt(System.getProperty("jsmpp.client.maxOutstanding", DEFAULT_MAX_OUTSTANDING.toString()));
        }
        catch (NumberFormatException e) {
            maxOutstanding = DEFAULT_MAX_OUTSTANDING;
        }
        log.info("Target server {}:{}", (Object)host, (Object)port);
        log.info("System ID: {}", (Object)systemId);
        log.info("Password: {}", (Object)password);
        log.info("Source address: {}", (Object)sourceAddr);
        log.info("Destination address: {}", (Object)destinationAddr);
        log.info("Transaction timer: {}", (Object)transactionTimer);
        log.info("Bulk size: {}", (Object)bulkSize);
        log.info("Max outstanding: {}", (Object)maxOutstanding);
        log.info("Processor degree: {}", (Object)processorDegree);
        StressClient stressClient = new StressClient(0, host, port, bulkSize, systemId, password, sourceAddr, destinationAddr, transactionTimer, processorDegree, maxOutstanding);
        stressClient.run();
    }

    private void shutdown() {
        this.execService.shutdown();
        this.exit.set(true);
    }

    @Override
    public void run() {
        new TrafficWatcherThread().start();
        try {
            BindParameter bindParameter = new BindParameter(BindType.BIND_TRX, this.systemId, this.password, "CLN", TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, null, InterfaceVersion.IF_50);
            this.smppSession.connectAndBind(this.host, this.port, bindParameter);
            log.info("Bound to {}:{}", (Object)this.host, (Object)this.port);
            log.info("Starting to send {} bulk messages", (Object)this.bulkSize);
            for (int i = 0; i < this.bulkSize && !this.exit.get(); ++i) {
                this.execService.execute(this.newSendTaskData("Hello " + this.id + " idx=" + i));
            }
            while (!this.exit.get()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            log.info("Done");
            this.smppSession.unbindAndClose();
        }
        catch (IOException e) {
            log.error("Failed initialize connection or bind", (Throwable)e);
        }
    }

    private Runnable newSendTask(final String message) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    StressClient.this.requestCounter.incrementAndGet();
                    long startTime = System.currentTimeMillis();
                    SubmitSmResult submitSmResult = StressClient.this.smppSession.submitShortMessage(null, TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, StressClient.this.sourceAddr, TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, StressClient.this.destinationAddr, new ESMClass(), (byte)0, (byte)0, null, null, new RegisteredDelivery(0), (byte)0, DataCodings.ZERO, (byte)0, message.getBytes(), new OptionalParameter[0]);
                    log.info("There are {} unacknowledged requests", (Object)StressClient.this.smppSession.getUnacknowledgedRequests());
                    OptionalParameter.Congestion_state congestionState = (OptionalParameter.Congestion_state)OptionalParameters.get(OptionalParameter.Congestion_state.class, (OptionalParameter[])submitSmResult.getOptionalParameters());
                    if (congestionState != null) {
                        log.info("Remote congestion state: {}", (Object)(congestionState.getValue() & 0xFF));
                    }
                    long delay = System.currentTimeMillis() - startTime;
                    StressClient.this.responseCounter.incrementAndGet();
                    if (StressClient.this.maxDelay.get() < delay) {
                        StressClient.this.maxDelay.set(delay);
                    }
                }
                catch (IOException | InvalidResponseException | PDUException | NegativeResponseException | ResponseTimeoutException e) {
                    log.error("Failed submit short message '" + message + "'", e);
                    StressClient.this.shutdown();
                }
            }
        };
    }

    private Runnable newSendTaskData(final String message) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    StressClient.this.requestCounter.incrementAndGet();
                    long startTime = System.currentTimeMillis();
                    OptionalParameter.Message_payload messagePayload = new OptionalParameter.Message_payload(message.getBytes(StandardCharsets.US_ASCII));
                    DataSmResult dataSmResult = StressClient.this.smppSession.dataShortMessage(null, TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, StressClient.this.sourceAddr, TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, StressClient.this.destinationAddr, new ESMClass(), new RegisteredDelivery(0), DataCodings.ZERO, new OptionalParameter[]{messagePayload});
                    log.info("There are {} unacknowledged requests", (Object)StressClient.this.smppSession.getUnacknowledgedRequests());
                    log.info("dataSmresult {}", (Object)dataSmResult.getMessageId());
                    log.info("dataSmresult {}", (Object[])dataSmResult.getOptionalParameters());
                    OptionalParameter.Congestion_state congestionState = (OptionalParameter.Congestion_state)OptionalParameters.get(OptionalParameter.Congestion_state.class, (OptionalParameter[])dataSmResult.getOptionalParameters());
                    if (congestionState != null) {
                        log.info("Remote congestion state: {}", (Object)(congestionState.getValue() & 0xFF));
                    }
                    long delay = System.currentTimeMillis() - startTime;
                    StressClient.this.responseCounter.incrementAndGet();
                    if (StressClient.this.maxDelay.get() < delay) {
                        StressClient.this.maxDelay.set(delay);
                    }
                }
                catch (IOException | InvalidResponseException | PDUException | NegativeResponseException | ResponseTimeoutException e) {
                    log.error("Failed submit short message '" + message + "'", e);
                    StressClient.this.shutdown();
                }
            }
        };
    }

    private class TrafficWatcherThread
    extends Thread {
        private TrafficWatcherThread() {
        }

        @Override
        public void run() {
            log.info("Starting traffic watcher...");
            while (!StressClient.this.exit.get()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                int requestPerSecond = StressClient.this.requestCounter.getAndSet(0);
                int responsePerSecond = StressClient.this.responseCounter.getAndSet(0);
                long maxDelayPerSecond = StressClient.this.maxDelay.getAndSet(0L);
                StressClient.this.totalRequestCounter.addAndGet(requestPerSecond);
                int total = StressClient.this.totalResponseCounter.addAndGet(responsePerSecond);
                log.info("Request/Response per second: {}/{} of {} maxDelay={}", new Object[]{requestPerSecond, responsePerSecond, total, maxDelayPerSecond});
                if (total != StressClient.this.bulkSize) continue;
                StressClient.this.shutdown();
            }
        }
    }
}

