/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.BroadcastSm;
import org.jsmpp.bean.CancelBroadcastSm;
import org.jsmpp.bean.CancelSm;
import org.jsmpp.bean.DataCodings;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliveryReceipt;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.GSMSpecificFeature;
import org.jsmpp.bean.InterfaceVersion;
import org.jsmpp.bean.MessageMode;
import org.jsmpp.bean.MessageState;
import org.jsmpp.bean.MessageType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.QueryBroadcastSm;
import org.jsmpp.bean.QuerySm;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.ReplaceSm;
import org.jsmpp.bean.SMSCDeliveryReceipt;
import org.jsmpp.bean.SubmitMulti;
import org.jsmpp.bean.SubmitSm;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.bean.UnsuccessDelivery;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.BindRequest;
import org.jsmpp.session.BroadcastSmResult;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.QueryBroadcastSmResult;
import org.jsmpp.session.QuerySmResult;
import org.jsmpp.session.SMPPServerSession;
import org.jsmpp.session.SMPPServerSessionListener;
import org.jsmpp.session.ServerMessageReceiverListener;
import org.jsmpp.session.Session;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.SubmitMultiResult;
import org.jsmpp.session.SubmitSmResult;
import org.jsmpp.util.AbsoluteTimeFormatter;
import org.jsmpp.util.DeliveryReceiptState;
import org.jsmpp.util.HexUtil;
import org.jsmpp.util.MessageIDGenerator;
import org.jsmpp.util.MessageId;
import org.jsmpp.util.RandomMessageIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StressServer
implements Runnable,
ServerMessageReceiverListener {
    private static final Logger log = LoggerFactory.getLogger(StressServer.class);
    private static final int DEFAULT_MAX_WAIT_BIND = 5;
    private static final int DEFAULT_MAX_DELIVERIES = 5;
    private static final int DEFAULT_PORT = 8056;
    private static final int DEFAULT_PROCESSOR_DEGREE = 10;
    private static final String CANCELSM_NOT_IMPLEMENTED = "cancel_sm not implemented";
    private static final String REPLACESM_NOT_IMPLEMENTED = "replace_sm not implemented";
    private final ExecutorService waitBindExecService = Executors.newFixedThreadPool(5);
    private final ScheduledExecutorService deliveryExecService = Executors.newScheduledThreadPool(5);
    private final MessageIDGenerator messageIDGenerator = new RandomMessageIDGenerator();
    private final AbsoluteTimeFormatter timeFormatter = new AbsoluteTimeFormatter();
    private final AtomicInteger requestCounter = new AtomicInteger();
    private int processorDegree;
    private int port;

    public StressServer(int port, int processorDegree) {
        this.port = port;
        this.processorDegree = processorDegree;
    }

    @Override
    public void run() {
        try {
            SMPPServerSessionListener sessionListener = new SMPPServerSessionListener(this.port);
            Throwable throwable = null;
            try {
                try {
                    sessionListener.setSessionStateListener((SessionStateListener)new SessionStateListenerImpl());
                    sessionListener.setPduProcessorDegree(this.processorDegree);
                    new TrafficWatcherThread().start();
                    log.info("Listening on port {}", (Object)this.port);
                    while (true) {
                        SMPPServerSession serverSession = sessionListener.accept();
                        log.info("Accepting connection for session {}", (Object)serverSession.getSessionId());
                        serverSession.setMessageReceiverListener((ServerMessageReceiverListener)this);
                        this.waitBindExecService.execute(new WaitBindTask(serverSession, 60000L));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (sessionListener != null) {
                    if (throwable != null) {
                        try {
                            sessionListener.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        sessionListener.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (IOException e) {
            log.error("I/O error occurred", (Throwable)e);
            this.waitBindExecService.shutdown();
            this.deliveryExecService.shutdown();
            return;
        }
    }

    public QuerySmResult onAcceptQuerySm(QuerySm querySm, SMPPServerSession source) throws ProcessRequestException {
        String finalDate = this.timeFormatter.format(new Date());
        log.info("Receiving query_sm, and return {}", (Object)finalDate);
        return new QuerySmResult(finalDate, MessageState.DELIVERED, 0);
    }

    public SubmitSmResult onAcceptSubmitSm(SubmitSm submitSm, SMPPServerSession source) throws ProcessRequestException {
        MessageId messageId = this.messageIDGenerator.newMessageId();
        byte[] shortMessage = submitSm.getShortMessage();
        if (submitSm.isUdhi()) {
            int udhl = shortMessage[0] & 0xFF;
            log.info("Receiving submit_sm {} {}, return message id {}", new Object[]{HexUtil.convertBytesToHexString((byte[])shortMessage, (int)0, (int)(1 + udhl)), new String(shortMessage, 1 + udhl, shortMessage.length - udhl - 1), messageId.getValue()});
        } else {
            log.info("Receiving submit_sm {}, return message id {}", (Object)new String(submitSm.getShortMessage()), (Object)messageId.getValue());
        }
        this.requestCounter.incrementAndGet();
        if (SMSCDeliveryReceipt.SUCCESS_FAILURE.containedIn(submitSm.getRegisteredDelivery())) {
            log.debug("Schedule delivery receipt in 1000ms");
            this.deliveryExecService.schedule(new DeliveryReceiptTask(source, submitSm, messageId), 1000L, TimeUnit.MILLISECONDS);
        }
        return new SubmitSmResult(messageId, new OptionalParameter[0]);
    }

    public SubmitMultiResult onAcceptSubmitMulti(SubmitMulti submitMulti, SMPPServerSession source) throws ProcessRequestException {
        MessageId messageId = this.messageIDGenerator.newMessageId();
        log.info("Receiving submit_multi {}, and return message id {}", (Object)new String(submitMulti.getShortMessage()), (Object)messageId.getValue());
        this.requestCounter.incrementAndGet();
        return new SubmitMultiResult(messageId.getValue(), new UnsuccessDelivery[0], new OptionalParameter[0]);
    }

    public DataSmResult onAcceptDataSm(DataSm dataSm, Session source) throws ProcessRequestException {
        MessageId messageId = this.messageIDGenerator.newMessageId();
        OptionalParameter.Message_payload messagePayload = (OptionalParameter.Message_payload)dataSm.getOptionalParameter(OptionalParameter.Tag.MESSAGE_PAYLOAD);
        log.info("Receiving data_sm {}, and return message id {}", (Object)messagePayload.getValueAsString(), (Object)messageId.getValue());
        this.requestCounter.incrementAndGet();
        return new DataSmResult(messageId, new OptionalParameter[0]);
    }

    public void onAcceptCancelSm(CancelSm cancelSm, SMPPServerSession source) throws ProcessRequestException {
        log.warn(CANCELSM_NOT_IMPLEMENTED);
        throw new ProcessRequestException(CANCELSM_NOT_IMPLEMENTED, 17);
    }

    public void onAcceptReplaceSm(ReplaceSm replaceSm, SMPPServerSession source) throws ProcessRequestException {
        log.warn(REPLACESM_NOT_IMPLEMENTED);
        throw new ProcessRequestException(REPLACESM_NOT_IMPLEMENTED, 19);
    }

    public BroadcastSmResult onAcceptBroadcastSm(BroadcastSm broadcastSm, SMPPServerSession source) throws ProcessRequestException {
        MessageId messageId = this.messageIDGenerator.newMessageId();
        OptionalParameter[] optionalParameters = new OptionalParameter[]{};
        log.info("Received broadcast_sm, and return {}", (Object)messageId);
        return new BroadcastSmResult(messageId, optionalParameters);
    }

    public void onAcceptCancelBroadcastSm(CancelBroadcastSm cancelBroadcastSm, SMPPServerSession source) throws ProcessRequestException {
        log.info("Received cancel_broadcast_sm");
    }

    public QueryBroadcastSmResult onAcceptQueryBroadcastSm(QueryBroadcastSm queryBroadcastSm, SMPPServerSession source) throws ProcessRequestException {
        MessageId messageId = this.messageIDGenerator.newMessageId();
        OptionalParameter[] optionalParameters = new OptionalParameter[]{};
        log.info("Receiving query_broadcast_sm, and return {}", (Object)messageId);
        return new QueryBroadcastSmResult(messageId, optionalParameters);
    }

    public static void main(String[] args) {
        int processorDegree;
        int port;
        try {
            port = Integer.parseInt(System.getProperty("jsmpp.server.port", Integer.toString(8056)));
        }
        catch (NumberFormatException e) {
            port = 8056;
        }
        try {
            processorDegree = Integer.parseInt(System.getProperty("jsmpp.server.procDegree", Integer.toString(10)));
        }
        catch (NumberFormatException e) {
            processorDegree = 10;
        }
        log.info("Processor degree: {}", (Object)processorDegree);
        StressServer stressServer = new StressServer(port, processorDegree);
        stressServer.run();
    }

    private class TrafficWatcherThread
    extends Thread {
        private TrafficWatcherThread() {
        }

        @Override
        public void run() {
            log.info("Starting traffic watcher...");
            while (true) {
                int requestsPerSecond;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if ((requestsPerSecond = StressServer.this.requestCounter.getAndSet(0)) == 0) continue;
                log.debug("Requests per second: {}", (Object)requestsPerSecond);
            }
        }
    }

    private static class DeliveryReceiptTask
    implements Runnable {
        private final SMPPServerSession session;
        private final SubmitSm submitSm;
        private MessageId messageId;

        public DeliveryReceiptTask(SMPPServerSession session, SubmitSm submitSm, MessageId messageId) {
            this.session = session;
            this.submitSm = submitSm;
            this.messageId = messageId;
        }

        @Override
        public void run() {
            String stringValue = Integer.valueOf(this.messageId.getValue(), 16).toString();
            try {
                DeliveryReceipt delRec = new DeliveryReceipt(stringValue, 1, 1, new Date(), new Date(), DeliveryReceiptState.DELIVRD, null, new String(this.submitSm.getShortMessage()));
                this.session.deliverShortMessage("mc", TypeOfNumber.valueOf((byte)this.submitSm.getDestAddrTon()), NumberingPlanIndicator.valueOf((byte)this.submitSm.getDestAddrNpi()), this.submitSm.getDestAddress(), TypeOfNumber.valueOf((byte)this.submitSm.getSourceAddrTon()), NumberingPlanIndicator.valueOf((byte)this.submitSm.getSourceAddrNpi()), this.submitSm.getSourceAddr(), new ESMClass(MessageMode.DEFAULT, MessageType.SMSC_DEL_RECEIPT, GSMSpecificFeature.DEFAULT), (byte)0, (byte)0, new RegisteredDelivery(0), DataCodings.ZERO, delRec.toString().getBytes(), new OptionalParameter[0]);
                log.debug("Sending delivery receipt for message id {}: {}", (Object)this.messageId, (Object)stringValue);
            }
            catch (Exception e) {
                log.error("Failed sending delivery_receipt for message id " + this.messageId + ":" + stringValue, (Throwable)e);
            }
        }
    }

    private static class WaitBindTask
    implements Runnable {
        private final SMPPServerSession serverSession;
        private final long timeout;

        public WaitBindTask(SMPPServerSession serverSession, long timeout) {
            this.serverSession = serverSession;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            try {
                log.info("Waiting {} ms for bind for session {} ", (Object)this.timeout, (Object)this.serverSession.getSessionId());
                BindRequest bindRequest = this.serverSession.waitForBind(this.timeout);
                log.info("Accepting bind for session {}", (Object)this.serverSession.getSessionId());
                try {
                    this.serverSession.setInterfaceVersion(InterfaceVersion.IF_50.min(bindRequest.getInterfaceVersion()));
                    bindRequest.accept("sys", InterfaceVersion.IF_50);
                }
                catch (PDUStringException e) {
                    log.error("Invalid system id", (Throwable)e);
                    bindRequest.reject(15);
                }
            }
            catch (IllegalStateException e) {
                log.error("System error", (Throwable)e);
            }
            catch (TimeoutException e) {
                log.warn("Timeout: {}", (Object)e.getMessage());
            }
            catch (IOException e) {
                log.error("Failed accepting bind request for session {}", (Object)this.serverSession.getSessionId());
            }
        }
    }

    private static class SessionStateListenerImpl
    implements SessionStateListener {
        private SessionStateListenerImpl() {
        }

        public void onStateChange(SessionState newState, SessionState oldState, Session source) {
            SMPPServerSession session = (SMPPServerSession)source;
            log.info("New state of session {} is {}", (Object)session.getSessionId(), (Object)newState);
        }
    }
}

