/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples.session.connection.socket;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.jsmpp.session.connection.ServerConnection;
import org.jsmpp.session.connection.ServerConnectionFactory;
import org.jsmpp.session.connection.socket.ServerSocketConnection;

public class KeyStoreSSLServerSocketConnectionFactory
implements ServerConnectionFactory {
    private static final String KEY_STORE_PATH = "keystore.p12";
    private static final char[] KEY_STORE_PASSWORD = "password".toCharArray();
    private SSLServerSocketFactory sslServerSocketFactory;

    public KeyStoreSSLServerSocketConnectionFactory() {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(new FileInputStream(KEY_STORE_PATH), KEY_STORE_PASSWORD);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(keyStore, KEY_STORE_PASSWORD);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagerFactory.getKeyManagers(), null, null);
            this.sslServerSocketFactory = sslContext.getServerSocketFactory();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public ServerConnection listen(int port) throws IOException {
        ServerSocket serverSocket = this.sslServerSocketFactory.createServerSocket(port);
        return new ServerSocketConnection(serverSocket);
    }

    public ServerConnection listen(int port, int timeout) throws IOException {
        ServerSocket serverSocket = this.sslServerSocketFactory.createServerSocket(port);
        serverSocket.setSoTimeout(timeout);
        return new ServerSocketConnection(serverSocket);
    }

    public ServerConnection listen(int port, int timeout, int backlog) throws IOException {
        ServerSocket serverSocket = this.sslServerSocketFactory.createServerSocket(port, backlog);
        serverSocket.setSoTimeout(timeout);
        return new ServerSocketConnection(serverSocket);
    }
}

