/*
 * Decompiled with CFR 0.152.
 */
package org.jsoftware.javamail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.jsoftware.javamail.JavaMailJMSStatistics;
import org.jsoftware.javamail.JavaMailJMSStatisticsLocal;
import org.jsoftware.javamail.JavaMailSessionDelegate;

@MessageDriven(mappedName="jms/mailQueue", name="mailQueue")
public class JMS2JavaMail
implements MessageListener {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private JavaMailSessionDelegate javaMailSessionDelegate;
    @Resource(mappedName="mail/Session")
    private Session session;
    @EJB
    private JavaMailJMSStatisticsLocal javaMailJMSStatisticsLocal;

    public JMS2JavaMail() {
    }

    JMS2JavaMail(JavaMailSessionDelegate javaMailSessionDelegate, JavaMailJMSStatistics javaMailJMSStatistics) {
        this.javaMailSessionDelegate = javaMailSessionDelegate;
        this.javaMailJMSStatisticsLocal = javaMailJMSStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(javax.jms.Message message) {
        if (message instanceof BytesMessage) {
            try {
                int r;
                BytesMessage bMsg = (BytesMessage)message;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[512];
                while ((r = bMsg.readBytes(buf)) >= 0) {
                    baos.write(buf, 0, r);
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                ObjectInputStream ois = new ObjectInputStream(bais);
                String protocolToUse = ois.readUTF();
                Address[] addresses = (Address[])ois.readObject();
                MimeMessage mimeMessage = this.javaMailSessionDelegate.createMimeMessage(ois);
                try {
                    Transport transport = this.javaMailSessionDelegate.findTransport(protocolToUse);
                    if (transport.isConnected()) {
                        transport.sendMessage((Message)mimeMessage, addresses);
                    } else {
                        try {
                            transport.connect();
                            transport.sendMessage((Message)mimeMessage, addresses);
                        }
                        finally {
                            transport.close();
                        }
                    }
                    this.ack(message);
                    this.javaMailJMSStatisticsLocal.onSuccess(mimeMessage, addresses);
                    if (this.logger.isLoggable(Level.INFO)) {
                        this.logger.log(Level.INFO, "Message " + mimeMessage.getMessageID() + " (" + mimeMessage.getMessageNumber() + ") successfully sent to destination javaMailSession using " + protocolToUse + " -> " + transport + ".");
                    }
                }
                catch (MessagingException mEx) {
                    this.javaMailJMSStatisticsLocal.onFailure(mimeMessage, addresses, (Exception)((Object)mEx));
                    throw mEx;
                }
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "Error processing JMS message - " + message + ".", ex);
            }
        } else {
            this.logger.warning("Found message that is not BytesMessage - " + message + ", " + message.getClass());
            this.ack(message);
        }
    }

    @PostConstruct
    public void init() {
        if (this.session == null) {
            throw new IllegalStateException("JavaMail session is null.");
        }
        this.javaMailSessionDelegate = new JavaMailSessionDelegate(){

            @Override
            public Transport findTransport(String protocolToUse) throws NoSuchProviderException {
                return JMS2JavaMail.this.session.getTransport(protocolToUse);
            }

            @Override
            public MimeMessage createMimeMessage(InputStream inputStream) throws MessagingException {
                return new MimeMessage(JMS2JavaMail.this.session, inputStream);
            }
        };
    }

    private void ack(javax.jms.Message message) {
        try {
            message.acknowledge();
        }
        catch (JMSException e) {
            this.logger.warning("Error acknowledging " + message + ":: " + (Object)((Object)e));
        }
    }
}

