package org.json4s

trait WriterFunctions { self: Writer.type =>
  def writer[A1, A2, X](f: X => (A1, A2))(key1: String, key2: String)(implicit
    A1: Writer[A1], A2: Writer[A2]
  ): Writer[X] =
    writer2[A1, A2, X](f)(key1, key2)

  def writer2[A1, A2, X](f: X => (A1, A2))(key1: String, key2: String)(implicit
    A1: Writer[A1], A2: Writer[A2]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2) = f(obj)
      JObject(
        (key1, A1.write(a1)) :: (key2, A2.write(a2)) :: Nil
      )
    }
  }

  def writer[A1, A2, A3, X](f: X => (A1, A2, A3))(key1: String, key2: String, key3: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3]
  ): Writer[X] =
    writer3[A1, A2, A3, X](f)(key1, key2, key3)

  def writer3[A1, A2, A3, X](f: X => (A1, A2, A3))(key1: String, key2: String, key3: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3) = f(obj)
      JObject(
        (key1, A1.write(a1)) :: (key2, A2.write(a2)) :: (key3, A3.write(a3)) :: Nil
      )
    }
  }

  def writer[A1, A2, A3, A4, X](f: X => (A1, A2, A3, A4))(key1: String, key2: String, key3: String, key4: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4]
  ): Writer[X] =
    writer4[A1, A2, A3, A4, X](f)(key1, key2, key3, key4)

  def writer4[A1, A2, A3, A4, X](f: X => (A1, A2, A3, A4))(key1: String, key2: String, key3: String, key4: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4) = f(obj)
      JObject(
        (key1, A1.write(a1)) :: (key2, A2.write(a2)) :: (key3, A3.write(a3)) :: (key4, A4.write(a4)) :: Nil
      )
    }
  }

  def writer[A1, A2, A3, A4, A5, X](f: X => (A1, A2, A3, A4, A5))(key1: String, key2: String, key3: String, key4: String, key5: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5]
  ): Writer[X] =
    writer5[A1, A2, A3, A4, A5, X](f)(key1, key2, key3, key4, key5)

  def writer5[A1, A2, A3, A4, A5, X](f: X => (A1, A2, A3, A4, A5))(key1: String, key2: String, key3: String, key4: String, key5: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5) = f(obj)
      JObject(
        (key1, A1.write(a1)) :: (key2, A2.write(a2)) :: (key3, A3.write(a3)) :: (key4, A4.write(a4)) :: (key5, A5.write(a5)) :: Nil
      )
    }
  }

  def writer[A1, A2, A3, A4, A5, A6, X](f: X => (A1, A2, A3, A4, A5, A6))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6]
  ): Writer[X] =
    writer6[A1, A2, A3, A4, A5, A6, X](f)(key1, key2, key3, key4, key5, key6)

  def writer6[A1, A2, A3, A4, A5, A6, X](f: X => (A1, A2, A3, A4, A5, A6))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6) = f(obj)
      JObject(
        (key1, A1.write(a1)) :: (key2, A2.write(a2)) :: (key3, A3.write(a3)) :: (key4, A4.write(a4)) :: (key5, A5.write(a5)) :: (key6, A6.write(a6)) :: Nil
      )
    }
  }

  def writer[A1, A2, A3, A4, A5, A6, A7, X](f: X => (A1, A2, A3, A4, A5, A6, A7))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7]
  ): Writer[X] =
    writer7[A1, A2, A3, A4, A5, A6, A7, X](f)(key1, key2, key3, key4, key5, key6, key7)

  def writer7[A1, A2, A3, A4, A5, A6, A7, X](f: X => (A1, A2, A3, A4, A5, A6, A7))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7) = f(obj)
      JObject(
        (key1, A1.write(a1)) :: (key2, A2.write(a2)) :: (key3, A3.write(a3)) :: (key4, A4.write(a4)) :: (key5, A5.write(a5)) :: (key6, A6.write(a6)) :: (key7, A7.write(a7)) :: Nil
      )
    }
  }

  def writer[A1, A2, A3, A4, A5, A6, A7, A8, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8]
  ): Writer[X] =
    writer8[A1, A2, A3, A4, A5, A6, A7, A8, X](f)(key1, key2, key3, key4, key5, key6, key7, key8)

  def writer8[A1, A2, A3, A4, A5, A6, A7, A8, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8) = f(obj)
      JObject(
        (key1, A1.write(a1)) :: (key2, A2.write(a2)) :: (key3, A3.write(a3)) :: (key4, A4.write(a4)) :: (key5, A5.write(a5)) :: (key6, A6.write(a6)) :: (key7, A7.write(a7)) :: (key8, A8.write(a8)) :: Nil
      )
    }
  }

  def writer[A1, A2, A3, A4, A5, A6, A7, A8, A9, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9]
  ): Writer[X] =
    writer9[A1, A2, A3, A4, A5, A6, A7, A8, A9, X](f)(key1, key2, key3, key4, key5, key6, key7, key8, key9)

  def writer9[A1, A2, A3, A4, A5, A6, A7, A8, A9, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9) = f(obj)
      JObject(
        (key1, A1.write(a1)) :: (key2, A2.write(a2)) :: (key3, A3.write(a3)) :: (key4, A4.write(a4)) :: (key5, A5.write(a5)) :: (key6, A6.write(a6)) :: (key7, A7.write(a7)) :: (key8, A8.write(a8)) :: (key9, A9.write(a9)) :: Nil
      )
    }
  }

  def writer[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10]
  ): Writer[X] =
    writer10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, X](f)(key1, key2, key3, key4, key5, key6, key7, key8, key9, key10)

  def writer10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10) = f(obj)
      JObject(
        (key1, A1.write(a1)) :: (key2, A2.write(a2)) :: (key3, A3.write(a3)) :: (key4, A4.write(a4)) :: (key5, A5.write(a5)) :: (key6, A6.write(a6)) :: (key7, A7.write(a7)) :: (key8, A8.write(a8)) :: (key9, A9.write(a9)) :: (key10, A10.write(a10)) :: Nil
      )
    }
  }

  def writer[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11]
  ): Writer[X] =
    writer11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, X](f)(key1, key2, key3, key4, key5, key6, key7, key8, key9, key10, key11)

  def writer11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11) = f(obj)
      JObject(
        (key1, A1.write(a1)) :: (key2, A2.write(a2)) :: (key3, A3.write(a3)) :: (key4, A4.write(a4)) :: (key5, A5.write(a5)) :: (key6, A6.write(a6)) :: (key7, A7.write(a7)) :: (key8, A8.write(a8)) :: (key9, A9.write(a9)) :: (key10, A10.write(a10)) :: (key11, A11.write(a11)) :: Nil
      )
    }
  }

  def writer[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String, key12: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12]
  ): Writer[X] =
    writer12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, X](f)(key1, key2, key3, key4, key5, key6, key7, key8, key9, key10, key11, key12)

  def writer12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String, key12: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12) = f(obj)
      JObject(
        (key1, A1.write(a1)) :: (key2, A2.write(a2)) :: (key3, A3.write(a3)) :: (key4, A4.write(a4)) :: (key5, A5.write(a5)) :: (key6, A6.write(a6)) :: (key7, A7.write(a7)) :: (key8, A8.write(a8)) :: (key9, A9.write(a9)) :: (key10, A10.write(a10)) :: (key11, A11.write(a11)) :: (key12, A12.write(a12)) :: Nil
      )
    }
  }

  def writer[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String, key12: String, key13: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13]
  ): Writer[X] =
    writer13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, X](f)(key1, key2, key3, key4, key5, key6, key7, key8, key9, key10, key11, key12, key13)

  def writer13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String, key12: String, key13: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13) = f(obj)
      JObject(
        (key1, A1.write(a1)) :: (key2, A2.write(a2)) :: (key3, A3.write(a3)) :: (key4, A4.write(a4)) :: (key5, A5.write(a5)) :: (key6, A6.write(a6)) :: (key7, A7.write(a7)) :: (key8, A8.write(a8)) :: (key9, A9.write(a9)) :: (key10, A10.write(a10)) :: (key11, A11.write(a11)) :: (key12, A12.write(a12)) :: (key13, A13.write(a13)) :: Nil
      )
    }
  }

  def writer[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String, key12: String, key13: String, key14: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14]
  ): Writer[X] =
    writer14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, X](f)(key1, key2, key3, key4, key5, key6, key7, key8, key9, key10, key11, key12, key13, key14)

  def writer14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String, key12: String, key13: String, key14: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14) = f(obj)
      JObject(
        (key1, A1.write(a1)) :: (key2, A2.write(a2)) :: (key3, A3.write(a3)) :: (key4, A4.write(a4)) :: (key5, A5.write(a5)) :: (key6, A6.write(a6)) :: (key7, A7.write(a7)) :: (key8, A8.write(a8)) :: (key9, A9.write(a9)) :: (key10, A10.write(a10)) :: (key11, A11.write(a11)) :: (key12, A12.write(a12)) :: (key13, A13.write(a13)) :: (key14, A14.write(a14)) :: Nil
      )
    }
  }

  def writer[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String, key12: String, key13: String, key14: String, key15: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15]
  ): Writer[X] =
    writer15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, X](f)(key1, key2, key3, key4, key5, key6, key7, key8, key9, key10, key11, key12, key13, key14, key15)

  def writer15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String, key12: String, key13: String, key14: String, key15: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15) = f(obj)
      JObject(
        (key1, A1.write(a1)) :: (key2, A2.write(a2)) :: (key3, A3.write(a3)) :: (key4, A4.write(a4)) :: (key5, A5.write(a5)) :: (key6, A6.write(a6)) :: (key7, A7.write(a7)) :: (key8, A8.write(a8)) :: (key9, A9.write(a9)) :: (key10, A10.write(a10)) :: (key11, A11.write(a11)) :: (key12, A12.write(a12)) :: (key13, A13.write(a13)) :: (key14, A14.write(a14)) :: (key15, A15.write(a15)) :: Nil
      )
    }
  }

  def writer[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String, key12: String, key13: String, key14: String, key15: String, key16: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16]
  ): Writer[X] =
    writer16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, X](f)(key1, key2, key3, key4, key5, key6, key7, key8, key9, key10, key11, key12, key13, key14, key15, key16)

  def writer16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String, key12: String, key13: String, key14: String, key15: String, key16: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16) = f(obj)
      JObject(
        (key1, A1.write(a1)) :: (key2, A2.write(a2)) :: (key3, A3.write(a3)) :: (key4, A4.write(a4)) :: (key5, A5.write(a5)) :: (key6, A6.write(a6)) :: (key7, A7.write(a7)) :: (key8, A8.write(a8)) :: (key9, A9.write(a9)) :: (key10, A10.write(a10)) :: (key11, A11.write(a11)) :: (key12, A12.write(a12)) :: (key13, A13.write(a13)) :: (key14, A14.write(a14)) :: (key15, A15.write(a15)) :: (key16, A16.write(a16)) :: Nil
      )
    }
  }

  def writer[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String, key12: String, key13: String, key14: String, key15: String, key16: String, key17: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17]
  ): Writer[X] =
    writer17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, X](f)(key1, key2, key3, key4, key5, key6, key7, key8, key9, key10, key11, key12, key13, key14, key15, key16, key17)

  def writer17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String, key12: String, key13: String, key14: String, key15: String, key16: String, key17: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17) = f(obj)
      JObject(
        (key1, A1.write(a1)) :: (key2, A2.write(a2)) :: (key3, A3.write(a3)) :: (key4, A4.write(a4)) :: (key5, A5.write(a5)) :: (key6, A6.write(a6)) :: (key7, A7.write(a7)) :: (key8, A8.write(a8)) :: (key9, A9.write(a9)) :: (key10, A10.write(a10)) :: (key11, A11.write(a11)) :: (key12, A12.write(a12)) :: (key13, A13.write(a13)) :: (key14, A14.write(a14)) :: (key15, A15.write(a15)) :: (key16, A16.write(a16)) :: (key17, A17.write(a17)) :: Nil
      )
    }
  }

  def writer[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String, key12: String, key13: String, key14: String, key15: String, key16: String, key17: String, key18: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17], A18: Writer[A18]
  ): Writer[X] =
    writer18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, X](f)(key1, key2, key3, key4, key5, key6, key7, key8, key9, key10, key11, key12, key13, key14, key15, key16, key17, key18)

  def writer18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String, key12: String, key13: String, key14: String, key15: String, key16: String, key17: String, key18: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17], A18: Writer[A18]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18) = f(obj)
      JObject(
        (key1, A1.write(a1)) :: (key2, A2.write(a2)) :: (key3, A3.write(a3)) :: (key4, A4.write(a4)) :: (key5, A5.write(a5)) :: (key6, A6.write(a6)) :: (key7, A7.write(a7)) :: (key8, A8.write(a8)) :: (key9, A9.write(a9)) :: (key10, A10.write(a10)) :: (key11, A11.write(a11)) :: (key12, A12.write(a12)) :: (key13, A13.write(a13)) :: (key14, A14.write(a14)) :: (key15, A15.write(a15)) :: (key16, A16.write(a16)) :: (key17, A17.write(a17)) :: (key18, A18.write(a18)) :: Nil
      )
    }
  }

  def writer[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String, key12: String, key13: String, key14: String, key15: String, key16: String, key17: String, key18: String, key19: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17], A18: Writer[A18], A19: Writer[A19]
  ): Writer[X] =
    writer19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, X](f)(key1, key2, key3, key4, key5, key6, key7, key8, key9, key10, key11, key12, key13, key14, key15, key16, key17, key18, key19)

  def writer19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String, key12: String, key13: String, key14: String, key15: String, key16: String, key17: String, key18: String, key19: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17], A18: Writer[A18], A19: Writer[A19]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19) = f(obj)
      JObject(
        (key1, A1.write(a1)) :: (key2, A2.write(a2)) :: (key3, A3.write(a3)) :: (key4, A4.write(a4)) :: (key5, A5.write(a5)) :: (key6, A6.write(a6)) :: (key7, A7.write(a7)) :: (key8, A8.write(a8)) :: (key9, A9.write(a9)) :: (key10, A10.write(a10)) :: (key11, A11.write(a11)) :: (key12, A12.write(a12)) :: (key13, A13.write(a13)) :: (key14, A14.write(a14)) :: (key15, A15.write(a15)) :: (key16, A16.write(a16)) :: (key17, A17.write(a17)) :: (key18, A18.write(a18)) :: (key19, A19.write(a19)) :: Nil
      )
    }
  }

  def writer[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String, key12: String, key13: String, key14: String, key15: String, key16: String, key17: String, key18: String, key19: String, key20: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17], A18: Writer[A18], A19: Writer[A19], A20: Writer[A20]
  ): Writer[X] =
    writer20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, X](f)(key1, key2, key3, key4, key5, key6, key7, key8, key9, key10, key11, key12, key13, key14, key15, key16, key17, key18, key19, key20)

  def writer20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String, key12: String, key13: String, key14: String, key15: String, key16: String, key17: String, key18: String, key19: String, key20: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17], A18: Writer[A18], A19: Writer[A19], A20: Writer[A20]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20) = f(obj)
      JObject(
        (key1, A1.write(a1)) :: (key2, A2.write(a2)) :: (key3, A3.write(a3)) :: (key4, A4.write(a4)) :: (key5, A5.write(a5)) :: (key6, A6.write(a6)) :: (key7, A7.write(a7)) :: (key8, A8.write(a8)) :: (key9, A9.write(a9)) :: (key10, A10.write(a10)) :: (key11, A11.write(a11)) :: (key12, A12.write(a12)) :: (key13, A13.write(a13)) :: (key14, A14.write(a14)) :: (key15, A15.write(a15)) :: (key16, A16.write(a16)) :: (key17, A17.write(a17)) :: (key18, A18.write(a18)) :: (key19, A19.write(a19)) :: (key20, A20.write(a20)) :: Nil
      )
    }
  }

  def writer[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String, key12: String, key13: String, key14: String, key15: String, key16: String, key17: String, key18: String, key19: String, key20: String, key21: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17], A18: Writer[A18], A19: Writer[A19], A20: Writer[A20], A21: Writer[A21]
  ): Writer[X] =
    writer21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, X](f)(key1, key2, key3, key4, key5, key6, key7, key8, key9, key10, key11, key12, key13, key14, key15, key16, key17, key18, key19, key20, key21)

  def writer21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String, key12: String, key13: String, key14: String, key15: String, key16: String, key17: String, key18: String, key19: String, key20: String, key21: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17], A18: Writer[A18], A19: Writer[A19], A20: Writer[A20], A21: Writer[A21]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21) = f(obj)
      JObject(
        (key1, A1.write(a1)) :: (key2, A2.write(a2)) :: (key3, A3.write(a3)) :: (key4, A4.write(a4)) :: (key5, A5.write(a5)) :: (key6, A6.write(a6)) :: (key7, A7.write(a7)) :: (key8, A8.write(a8)) :: (key9, A9.write(a9)) :: (key10, A10.write(a10)) :: (key11, A11.write(a11)) :: (key12, A12.write(a12)) :: (key13, A13.write(a13)) :: (key14, A14.write(a14)) :: (key15, A15.write(a15)) :: (key16, A16.write(a16)) :: (key17, A17.write(a17)) :: (key18, A18.write(a18)) :: (key19, A19.write(a19)) :: (key20, A20.write(a20)) :: (key21, A21.write(a21)) :: Nil
      )
    }
  }

  def writer[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String, key12: String, key13: String, key14: String, key15: String, key16: String, key17: String, key18: String, key19: String, key20: String, key21: String, key22: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17], A18: Writer[A18], A19: Writer[A19], A20: Writer[A20], A21: Writer[A21], A22: Writer[A22]
  ): Writer[X] =
    writer22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, X](f)(key1, key2, key3, key4, key5, key6, key7, key8, key9, key10, key11, key12, key13, key14, key15, key16, key17, key18, key19, key20, key21, key22)

  def writer22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, X](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22))(key1: String, key2: String, key3: String, key4: String, key5: String, key6: String, key7: String, key8: String, key9: String, key10: String, key11: String, key12: String, key13: String, key14: String, key15: String, key16: String, key17: String, key18: String, key19: String, key20: String, key21: String, key22: String)(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17], A18: Writer[A18], A19: Writer[A19], A20: Writer[A20], A21: Writer[A21], A22: Writer[A22]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22) = f(obj)
      JObject(
        (key1, A1.write(a1)) :: (key2, A2.write(a2)) :: (key3, A3.write(a3)) :: (key4, A4.write(a4)) :: (key5, A5.write(a5)) :: (key6, A6.write(a6)) :: (key7, A7.write(a7)) :: (key8, A8.write(a8)) :: (key9, A9.write(a9)) :: (key10, A10.write(a10)) :: (key11, A11.write(a11)) :: (key12, A12.write(a12)) :: (key13, A13.write(a13)) :: (key14, A14.write(a14)) :: (key15, A15.write(a15)) :: (key16, A16.write(a16)) :: (key17, A17.write(a17)) :: (key18, A18.write(a18)) :: (key19, A19.write(a19)) :: (key20, A20.write(a20)) :: (key21, A21.write(a21)) :: (key22, A22.write(a22)) :: Nil
      )
    }
  }


  def writerAuto[A1, A2, X <: Product](f: X => (A1, A2))(implicit
    A1: Writer[A1], A2: Writer[A2]
  ): Writer[X] =
    writerAuto2[A1, A2, X](f)

  def writerAuto2[A1, A2, X <: Product](f: X => (A1, A2))(implicit
    A1: Writer[A1], A2: Writer[A2]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2) = f(obj)
      JObject(
        (obj.productElementName(0), A1.write(a1)) :: (obj.productElementName(1), A2.write(a2)) :: Nil
      )
    }
  }

  def writerAuto[A1, A2, A3, X <: Product](f: X => (A1, A2, A3))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3]
  ): Writer[X] =
    writerAuto3[A1, A2, A3, X](f)

  def writerAuto3[A1, A2, A3, X <: Product](f: X => (A1, A2, A3))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3) = f(obj)
      JObject(
        (obj.productElementName(0), A1.write(a1)) :: (obj.productElementName(1), A2.write(a2)) :: (obj.productElementName(2), A3.write(a3)) :: Nil
      )
    }
  }

  def writerAuto[A1, A2, A3, A4, X <: Product](f: X => (A1, A2, A3, A4))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4]
  ): Writer[X] =
    writerAuto4[A1, A2, A3, A4, X](f)

  def writerAuto4[A1, A2, A3, A4, X <: Product](f: X => (A1, A2, A3, A4))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4) = f(obj)
      JObject(
        (obj.productElementName(0), A1.write(a1)) :: (obj.productElementName(1), A2.write(a2)) :: (obj.productElementName(2), A3.write(a3)) :: (obj.productElementName(3), A4.write(a4)) :: Nil
      )
    }
  }

  def writerAuto[A1, A2, A3, A4, A5, X <: Product](f: X => (A1, A2, A3, A4, A5))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5]
  ): Writer[X] =
    writerAuto5[A1, A2, A3, A4, A5, X](f)

  def writerAuto5[A1, A2, A3, A4, A5, X <: Product](f: X => (A1, A2, A3, A4, A5))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5) = f(obj)
      JObject(
        (obj.productElementName(0), A1.write(a1)) :: (obj.productElementName(1), A2.write(a2)) :: (obj.productElementName(2), A3.write(a3)) :: (obj.productElementName(3), A4.write(a4)) :: (obj.productElementName(4), A5.write(a5)) :: Nil
      )
    }
  }

  def writerAuto[A1, A2, A3, A4, A5, A6, X <: Product](f: X => (A1, A2, A3, A4, A5, A6))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6]
  ): Writer[X] =
    writerAuto6[A1, A2, A3, A4, A5, A6, X](f)

  def writerAuto6[A1, A2, A3, A4, A5, A6, X <: Product](f: X => (A1, A2, A3, A4, A5, A6))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6) = f(obj)
      JObject(
        (obj.productElementName(0), A1.write(a1)) :: (obj.productElementName(1), A2.write(a2)) :: (obj.productElementName(2), A3.write(a3)) :: (obj.productElementName(3), A4.write(a4)) :: (obj.productElementName(4), A5.write(a5)) :: (obj.productElementName(5), A6.write(a6)) :: Nil
      )
    }
  }

  def writerAuto[A1, A2, A3, A4, A5, A6, A7, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7]
  ): Writer[X] =
    writerAuto7[A1, A2, A3, A4, A5, A6, A7, X](f)

  def writerAuto7[A1, A2, A3, A4, A5, A6, A7, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7) = f(obj)
      JObject(
        (obj.productElementName(0), A1.write(a1)) :: (obj.productElementName(1), A2.write(a2)) :: (obj.productElementName(2), A3.write(a3)) :: (obj.productElementName(3), A4.write(a4)) :: (obj.productElementName(4), A5.write(a5)) :: (obj.productElementName(5), A6.write(a6)) :: (obj.productElementName(6), A7.write(a7)) :: Nil
      )
    }
  }

  def writerAuto[A1, A2, A3, A4, A5, A6, A7, A8, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8]
  ): Writer[X] =
    writerAuto8[A1, A2, A3, A4, A5, A6, A7, A8, X](f)

  def writerAuto8[A1, A2, A3, A4, A5, A6, A7, A8, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8) = f(obj)
      JObject(
        (obj.productElementName(0), A1.write(a1)) :: (obj.productElementName(1), A2.write(a2)) :: (obj.productElementName(2), A3.write(a3)) :: (obj.productElementName(3), A4.write(a4)) :: (obj.productElementName(4), A5.write(a5)) :: (obj.productElementName(5), A6.write(a6)) :: (obj.productElementName(6), A7.write(a7)) :: (obj.productElementName(7), A8.write(a8)) :: Nil
      )
    }
  }

  def writerAuto[A1, A2, A3, A4, A5, A6, A7, A8, A9, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9]
  ): Writer[X] =
    writerAuto9[A1, A2, A3, A4, A5, A6, A7, A8, A9, X](f)

  def writerAuto9[A1, A2, A3, A4, A5, A6, A7, A8, A9, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9) = f(obj)
      JObject(
        (obj.productElementName(0), A1.write(a1)) :: (obj.productElementName(1), A2.write(a2)) :: (obj.productElementName(2), A3.write(a3)) :: (obj.productElementName(3), A4.write(a4)) :: (obj.productElementName(4), A5.write(a5)) :: (obj.productElementName(5), A6.write(a6)) :: (obj.productElementName(6), A7.write(a7)) :: (obj.productElementName(7), A8.write(a8)) :: (obj.productElementName(8), A9.write(a9)) :: Nil
      )
    }
  }

  def writerAuto[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10]
  ): Writer[X] =
    writerAuto10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, X](f)

  def writerAuto10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10) = f(obj)
      JObject(
        (obj.productElementName(0), A1.write(a1)) :: (obj.productElementName(1), A2.write(a2)) :: (obj.productElementName(2), A3.write(a3)) :: (obj.productElementName(3), A4.write(a4)) :: (obj.productElementName(4), A5.write(a5)) :: (obj.productElementName(5), A6.write(a6)) :: (obj.productElementName(6), A7.write(a7)) :: (obj.productElementName(7), A8.write(a8)) :: (obj.productElementName(8), A9.write(a9)) :: (obj.productElementName(9), A10.write(a10)) :: Nil
      )
    }
  }

  def writerAuto[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11]
  ): Writer[X] =
    writerAuto11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, X](f)

  def writerAuto11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11) = f(obj)
      JObject(
        (obj.productElementName(0), A1.write(a1)) :: (obj.productElementName(1), A2.write(a2)) :: (obj.productElementName(2), A3.write(a3)) :: (obj.productElementName(3), A4.write(a4)) :: (obj.productElementName(4), A5.write(a5)) :: (obj.productElementName(5), A6.write(a6)) :: (obj.productElementName(6), A7.write(a7)) :: (obj.productElementName(7), A8.write(a8)) :: (obj.productElementName(8), A9.write(a9)) :: (obj.productElementName(9), A10.write(a10)) :: (obj.productElementName(10), A11.write(a11)) :: Nil
      )
    }
  }

  def writerAuto[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12]
  ): Writer[X] =
    writerAuto12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, X](f)

  def writerAuto12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12) = f(obj)
      JObject(
        (obj.productElementName(0), A1.write(a1)) :: (obj.productElementName(1), A2.write(a2)) :: (obj.productElementName(2), A3.write(a3)) :: (obj.productElementName(3), A4.write(a4)) :: (obj.productElementName(4), A5.write(a5)) :: (obj.productElementName(5), A6.write(a6)) :: (obj.productElementName(6), A7.write(a7)) :: (obj.productElementName(7), A8.write(a8)) :: (obj.productElementName(8), A9.write(a9)) :: (obj.productElementName(9), A10.write(a10)) :: (obj.productElementName(10), A11.write(a11)) :: (obj.productElementName(11), A12.write(a12)) :: Nil
      )
    }
  }

  def writerAuto[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13]
  ): Writer[X] =
    writerAuto13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, X](f)

  def writerAuto13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13) = f(obj)
      JObject(
        (obj.productElementName(0), A1.write(a1)) :: (obj.productElementName(1), A2.write(a2)) :: (obj.productElementName(2), A3.write(a3)) :: (obj.productElementName(3), A4.write(a4)) :: (obj.productElementName(4), A5.write(a5)) :: (obj.productElementName(5), A6.write(a6)) :: (obj.productElementName(6), A7.write(a7)) :: (obj.productElementName(7), A8.write(a8)) :: (obj.productElementName(8), A9.write(a9)) :: (obj.productElementName(9), A10.write(a10)) :: (obj.productElementName(10), A11.write(a11)) :: (obj.productElementName(11), A12.write(a12)) :: (obj.productElementName(12), A13.write(a13)) :: Nil
      )
    }
  }

  def writerAuto[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14]
  ): Writer[X] =
    writerAuto14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, X](f)

  def writerAuto14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14) = f(obj)
      JObject(
        (obj.productElementName(0), A1.write(a1)) :: (obj.productElementName(1), A2.write(a2)) :: (obj.productElementName(2), A3.write(a3)) :: (obj.productElementName(3), A4.write(a4)) :: (obj.productElementName(4), A5.write(a5)) :: (obj.productElementName(5), A6.write(a6)) :: (obj.productElementName(6), A7.write(a7)) :: (obj.productElementName(7), A8.write(a8)) :: (obj.productElementName(8), A9.write(a9)) :: (obj.productElementName(9), A10.write(a10)) :: (obj.productElementName(10), A11.write(a11)) :: (obj.productElementName(11), A12.write(a12)) :: (obj.productElementName(12), A13.write(a13)) :: (obj.productElementName(13), A14.write(a14)) :: Nil
      )
    }
  }

  def writerAuto[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15]
  ): Writer[X] =
    writerAuto15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, X](f)

  def writerAuto15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15) = f(obj)
      JObject(
        (obj.productElementName(0), A1.write(a1)) :: (obj.productElementName(1), A2.write(a2)) :: (obj.productElementName(2), A3.write(a3)) :: (obj.productElementName(3), A4.write(a4)) :: (obj.productElementName(4), A5.write(a5)) :: (obj.productElementName(5), A6.write(a6)) :: (obj.productElementName(6), A7.write(a7)) :: (obj.productElementName(7), A8.write(a8)) :: (obj.productElementName(8), A9.write(a9)) :: (obj.productElementName(9), A10.write(a10)) :: (obj.productElementName(10), A11.write(a11)) :: (obj.productElementName(11), A12.write(a12)) :: (obj.productElementName(12), A13.write(a13)) :: (obj.productElementName(13), A14.write(a14)) :: (obj.productElementName(14), A15.write(a15)) :: Nil
      )
    }
  }

  def writerAuto[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16]
  ): Writer[X] =
    writerAuto16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, X](f)

  def writerAuto16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16) = f(obj)
      JObject(
        (obj.productElementName(0), A1.write(a1)) :: (obj.productElementName(1), A2.write(a2)) :: (obj.productElementName(2), A3.write(a3)) :: (obj.productElementName(3), A4.write(a4)) :: (obj.productElementName(4), A5.write(a5)) :: (obj.productElementName(5), A6.write(a6)) :: (obj.productElementName(6), A7.write(a7)) :: (obj.productElementName(7), A8.write(a8)) :: (obj.productElementName(8), A9.write(a9)) :: (obj.productElementName(9), A10.write(a10)) :: (obj.productElementName(10), A11.write(a11)) :: (obj.productElementName(11), A12.write(a12)) :: (obj.productElementName(12), A13.write(a13)) :: (obj.productElementName(13), A14.write(a14)) :: (obj.productElementName(14), A15.write(a15)) :: (obj.productElementName(15), A16.write(a16)) :: Nil
      )
    }
  }

  def writerAuto[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17]
  ): Writer[X] =
    writerAuto17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, X](f)

  def writerAuto17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17) = f(obj)
      JObject(
        (obj.productElementName(0), A1.write(a1)) :: (obj.productElementName(1), A2.write(a2)) :: (obj.productElementName(2), A3.write(a3)) :: (obj.productElementName(3), A4.write(a4)) :: (obj.productElementName(4), A5.write(a5)) :: (obj.productElementName(5), A6.write(a6)) :: (obj.productElementName(6), A7.write(a7)) :: (obj.productElementName(7), A8.write(a8)) :: (obj.productElementName(8), A9.write(a9)) :: (obj.productElementName(9), A10.write(a10)) :: (obj.productElementName(10), A11.write(a11)) :: (obj.productElementName(11), A12.write(a12)) :: (obj.productElementName(12), A13.write(a13)) :: (obj.productElementName(13), A14.write(a14)) :: (obj.productElementName(14), A15.write(a15)) :: (obj.productElementName(15), A16.write(a16)) :: (obj.productElementName(16), A17.write(a17)) :: Nil
      )
    }
  }

  def writerAuto[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17], A18: Writer[A18]
  ): Writer[X] =
    writerAuto18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, X](f)

  def writerAuto18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17], A18: Writer[A18]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18) = f(obj)
      JObject(
        (obj.productElementName(0), A1.write(a1)) :: (obj.productElementName(1), A2.write(a2)) :: (obj.productElementName(2), A3.write(a3)) :: (obj.productElementName(3), A4.write(a4)) :: (obj.productElementName(4), A5.write(a5)) :: (obj.productElementName(5), A6.write(a6)) :: (obj.productElementName(6), A7.write(a7)) :: (obj.productElementName(7), A8.write(a8)) :: (obj.productElementName(8), A9.write(a9)) :: (obj.productElementName(9), A10.write(a10)) :: (obj.productElementName(10), A11.write(a11)) :: (obj.productElementName(11), A12.write(a12)) :: (obj.productElementName(12), A13.write(a13)) :: (obj.productElementName(13), A14.write(a14)) :: (obj.productElementName(14), A15.write(a15)) :: (obj.productElementName(15), A16.write(a16)) :: (obj.productElementName(16), A17.write(a17)) :: (obj.productElementName(17), A18.write(a18)) :: Nil
      )
    }
  }

  def writerAuto[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17], A18: Writer[A18], A19: Writer[A19]
  ): Writer[X] =
    writerAuto19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, X](f)

  def writerAuto19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17], A18: Writer[A18], A19: Writer[A19]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19) = f(obj)
      JObject(
        (obj.productElementName(0), A1.write(a1)) :: (obj.productElementName(1), A2.write(a2)) :: (obj.productElementName(2), A3.write(a3)) :: (obj.productElementName(3), A4.write(a4)) :: (obj.productElementName(4), A5.write(a5)) :: (obj.productElementName(5), A6.write(a6)) :: (obj.productElementName(6), A7.write(a7)) :: (obj.productElementName(7), A8.write(a8)) :: (obj.productElementName(8), A9.write(a9)) :: (obj.productElementName(9), A10.write(a10)) :: (obj.productElementName(10), A11.write(a11)) :: (obj.productElementName(11), A12.write(a12)) :: (obj.productElementName(12), A13.write(a13)) :: (obj.productElementName(13), A14.write(a14)) :: (obj.productElementName(14), A15.write(a15)) :: (obj.productElementName(15), A16.write(a16)) :: (obj.productElementName(16), A17.write(a17)) :: (obj.productElementName(17), A18.write(a18)) :: (obj.productElementName(18), A19.write(a19)) :: Nil
      )
    }
  }

  def writerAuto[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17], A18: Writer[A18], A19: Writer[A19], A20: Writer[A20]
  ): Writer[X] =
    writerAuto20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, X](f)

  def writerAuto20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17], A18: Writer[A18], A19: Writer[A19], A20: Writer[A20]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20) = f(obj)
      JObject(
        (obj.productElementName(0), A1.write(a1)) :: (obj.productElementName(1), A2.write(a2)) :: (obj.productElementName(2), A3.write(a3)) :: (obj.productElementName(3), A4.write(a4)) :: (obj.productElementName(4), A5.write(a5)) :: (obj.productElementName(5), A6.write(a6)) :: (obj.productElementName(6), A7.write(a7)) :: (obj.productElementName(7), A8.write(a8)) :: (obj.productElementName(8), A9.write(a9)) :: (obj.productElementName(9), A10.write(a10)) :: (obj.productElementName(10), A11.write(a11)) :: (obj.productElementName(11), A12.write(a12)) :: (obj.productElementName(12), A13.write(a13)) :: (obj.productElementName(13), A14.write(a14)) :: (obj.productElementName(14), A15.write(a15)) :: (obj.productElementName(15), A16.write(a16)) :: (obj.productElementName(16), A17.write(a17)) :: (obj.productElementName(17), A18.write(a18)) :: (obj.productElementName(18), A19.write(a19)) :: (obj.productElementName(19), A20.write(a20)) :: Nil
      )
    }
  }

  def writerAuto[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17], A18: Writer[A18], A19: Writer[A19], A20: Writer[A20], A21: Writer[A21]
  ): Writer[X] =
    writerAuto21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, X](f)

  def writerAuto21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17], A18: Writer[A18], A19: Writer[A19], A20: Writer[A20], A21: Writer[A21]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21) = f(obj)
      JObject(
        (obj.productElementName(0), A1.write(a1)) :: (obj.productElementName(1), A2.write(a2)) :: (obj.productElementName(2), A3.write(a3)) :: (obj.productElementName(3), A4.write(a4)) :: (obj.productElementName(4), A5.write(a5)) :: (obj.productElementName(5), A6.write(a6)) :: (obj.productElementName(6), A7.write(a7)) :: (obj.productElementName(7), A8.write(a8)) :: (obj.productElementName(8), A9.write(a9)) :: (obj.productElementName(9), A10.write(a10)) :: (obj.productElementName(10), A11.write(a11)) :: (obj.productElementName(11), A12.write(a12)) :: (obj.productElementName(12), A13.write(a13)) :: (obj.productElementName(13), A14.write(a14)) :: (obj.productElementName(14), A15.write(a15)) :: (obj.productElementName(15), A16.write(a16)) :: (obj.productElementName(16), A17.write(a17)) :: (obj.productElementName(17), A18.write(a18)) :: (obj.productElementName(18), A19.write(a19)) :: (obj.productElementName(19), A20.write(a20)) :: (obj.productElementName(20), A21.write(a21)) :: Nil
      )
    }
  }

  def writerAuto[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17], A18: Writer[A18], A19: Writer[A19], A20: Writer[A20], A21: Writer[A21], A22: Writer[A22]
  ): Writer[X] =
    writerAuto22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, X](f)

  def writerAuto22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, X <: Product](f: X => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22))(implicit
    A1: Writer[A1], A2: Writer[A2], A3: Writer[A3], A4: Writer[A4], A5: Writer[A5], A6: Writer[A6], A7: Writer[A7], A8: Writer[A8], A9: Writer[A9], A10: Writer[A10], A11: Writer[A11], A12: Writer[A12], A13: Writer[A13], A14: Writer[A14], A15: Writer[A15], A16: Writer[A16], A17: Writer[A17], A18: Writer[A18], A19: Writer[A19], A20: Writer[A20], A21: Writer[A21], A22: Writer[A22]
  ): Writer[X] = new Writer[X] {
    def write(obj: X): JValue = {
      val (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22) = f(obj)
      JObject(
        (obj.productElementName(0), A1.write(a1)) :: (obj.productElementName(1), A2.write(a2)) :: (obj.productElementName(2), A3.write(a3)) :: (obj.productElementName(3), A4.write(a4)) :: (obj.productElementName(4), A5.write(a5)) :: (obj.productElementName(5), A6.write(a6)) :: (obj.productElementName(6), A7.write(a7)) :: (obj.productElementName(7), A8.write(a8)) :: (obj.productElementName(8), A9.write(a9)) :: (obj.productElementName(9), A10.write(a10)) :: (obj.productElementName(10), A11.write(a11)) :: (obj.productElementName(11), A12.write(a12)) :: (obj.productElementName(12), A13.write(a13)) :: (obj.productElementName(13), A14.write(a14)) :: (obj.productElementName(14), A15.write(a15)) :: (obj.productElementName(15), A16.write(a16)) :: (obj.productElementName(16), A17.write(a17)) :: (obj.productElementName(17), A18.write(a18)) :: (obj.productElementName(18), A19.write(a19)) :: (obj.productElementName(19), A20.write(a20)) :: (obj.productElementName(20), A21.write(a21)) :: (obj.productElementName(21), A22.write(a22)) :: Nil
      )
    }
  }

}
