/*
 * Decompiled with CFR 0.152.
 */
package org.json4s.native;

import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.json4s.FileInput;
import org.json4s.JsonAST;
import org.json4s.JsonInput;
import org.json4s.ParserUtil;
import org.json4s.ReaderInput;
import org.json4s.StreamInput;
import org.json4s.StringInput;
import org.json4s.native.JsonParser;
import org.json4s.native.JsonParser$CloseArr$;
import org.json4s.native.JsonParser$CloseObj$;
import org.json4s.native.JsonParser$End$;
import org.json4s.native.JsonParser$NullVal$;
import org.json4s.native.JsonParser$OpenArr$;
import org.json4s.native.JsonParser$OpenObj$;
import org.json4s.package$;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

public final class JsonParser$ {
    public static JsonParser$ MODULE$;
    private final Function3<JsonParser.Parser, Object, Object, JsonAST.JValue> astParser;
    private final char org$json4s$native$JsonParser$$EOF;

    static {
        new JsonParser$();
    }

    public JsonAST.JValue parse(JsonInput in, boolean useBigDecimalForDouble) {
        return this.parse(in, useBigDecimalForDouble, true);
    }

    public JsonAST.JValue parse(JsonInput in, boolean useBigDecimalForDouble, boolean useBigIntForLong) {
        JsonAST.JValue jValue;
        if (in instanceof StringInput) {
            StringInput stringInput = (StringInput)in;
            jValue = this.parse(stringInput.string(), useBigDecimalForDouble, useBigIntForLong);
        } else if (in instanceof ReaderInput) {
            ReaderInput readerInput = (ReaderInput)in;
            jValue = this.parse(readerInput.reader(), useBigDecimalForDouble, useBigIntForLong, this.parse$default$4());
        } else if (in instanceof StreamInput) {
            StreamInput streamInput = (StreamInput)in;
            jValue = this.parse((Reader)new InputStreamReader(streamInput.stream(), "UTF-8"), useBigDecimalForDouble, useBigIntForLong, this.parse$default$4());
        } else if (in instanceof FileInput) {
            FileInput fileInput = (FileInput)in;
            jValue = this.parse((Reader)new FileReader(fileInput.file()), useBigDecimalForDouble, useBigIntForLong, this.parse$default$4());
        } else {
            throw new MatchError((Object)in);
        }
        return jValue;
    }

    public JsonAST.JValue parse(String s) {
        return this.parse(s, false, true);
    }

    public JsonAST.JValue parse(String s, boolean useBigDecimalForDouble) {
        return this.parse(s, useBigDecimalForDouble, true);
    }

    public JsonAST.JValue parse(String s, boolean useBigDecimalForDouble, boolean useBigIntForLong) {
        return this.parse(new ParserUtil.Buffer((Reader)new StringReader(s), false), useBigDecimalForDouble, useBigIntForLong);
    }

    public JsonAST.JValue parse(Reader s, boolean closeAutomatically, boolean useBigDecimalForDouble, boolean useBigIntForLong) {
        return this.parse(new ParserUtil.Buffer(s, closeAutomatically), useBigDecimalForDouble, useBigIntForLong);
    }

    public Option<JsonAST.JValue> parseOpt(String s) {
        return this.parseOpt(s, false);
    }

    public Option<JsonAST.JValue> parseOpt(String s, boolean useBigDecimalForDouble) {
        try {
            return this.parse(s, useBigDecimalForDouble).toOption();
        }
        catch (Exception exception) {
            return None$.MODULE$;
        }
    }

    public Option<JsonAST.JValue> parseOpt(Reader s, boolean closeAutomatically, boolean useBigDecimalForDouble) {
        try {
            return this.parse(s, closeAutomatically, useBigDecimalForDouble, this.parse$default$4()).toOption();
        }
        catch (Exception exception) {
            return None$.MODULE$;
        }
    }

    public <A> A parse(String s, Function1<JsonParser.Parser, A> p) {
        boolean parse_useBigDecimalForDouble = false;
        StringReader parse_parse_s = new StringReader(s);
        boolean parse_parse_parse_useBigIntForLong = true;
        return (A)p.apply((Object)new JsonParser.Parser(new ParserUtil.Buffer((Reader)parse_parse_s, false), parse_useBigDecimalForDouble, parse_parse_parse_useBigIntForLong));
    }

    public <A> A parse(String s, Function1<JsonParser.Parser, A> p, boolean useBigDecimalForDouble) {
        StringReader parse_s = new StringReader(s);
        boolean parse_parse_useBigIntForLong = true;
        return (A)p.apply((Object)new JsonParser.Parser(new ParserUtil.Buffer((Reader)parse_s, false), useBigDecimalForDouble, parse_parse_useBigIntForLong));
    }

    public <A> A parse(Reader s, Function1<JsonParser.Parser, A> p) {
        boolean parse_useBigDecimalForDouble = false;
        boolean parse_parse_useBigIntForLong = true;
        return (A)p.apply((Object)new JsonParser.Parser(new ParserUtil.Buffer(s, false), parse_useBigDecimalForDouble, parse_parse_useBigIntForLong));
    }

    public <A> A parse(Reader s, Function1<JsonParser.Parser, A> p, boolean useBigDecimalForDouble) {
        boolean parse_useBigIntForLong = true;
        return (A)p.apply((Object)new JsonParser.Parser(new ParserUtil.Buffer(s, false), useBigDecimalForDouble, parse_useBigIntForLong));
    }

    public <A> A parse(Reader s, Function1<JsonParser.Parser, A> p, boolean useBigDecimalForDouble, boolean useBigIntForLong) {
        return (A)p.apply((Object)new JsonParser.Parser(new ParserUtil.Buffer(s, false), useBigDecimalForDouble, useBigIntForLong));
    }

    private JsonAST.JValue parse(ParserUtil.Buffer buf, boolean useBigDecimal, boolean useBigInt) {
        JsonAST.JValue jValue;
        try {
            try {
                jValue = (JsonAST.JValue)this.astParser().apply((Object)new JsonParser.Parser(buf, useBigDecimal, useBigInt), (Object)BoxesRunTime.boxToBoolean((boolean)useBigDecimal), (Object)BoxesRunTime.boxToBoolean((boolean)useBigInt));
            }
            catch (ParserUtil.ParseException parseException) {
                throw parseException;
            }
            catch (Exception e) {
                throw new ParserUtil.ParseException("parsing failed", e);
            }
        }
        finally {
            buf.release();
        }
        return jValue;
    }

    public boolean parse$default$2() {
        return true;
    }

    public boolean parse$default$3() {
        return false;
    }

    public boolean parse$default$4() {
        return true;
    }

    public boolean parseOpt$default$2() {
        return true;
    }

    public boolean parseOpt$default$3() {
        return false;
    }

    private Function3<JsonParser.Parser, Object, Object, JsonAST.JValue> astParser() {
        return this.astParser;
    }

    public char org$json4s$native$JsonParser$$EOF() {
        return this.org$json4s$native$JsonParser$$EOF;
    }

    /*
     * WARNING - void declaration
     */
    private static final JsonAST.JValue reverse$1(JsonAST.JValue v2) {
        JsonAST.JValue jValue;
        if (v2 instanceof JsonAST.JObject) {
            Object object;
            void map_bf;
            JsonAST.JObject jObject = (JsonAST.JObject)v2;
            JsonAST.JObject$ jObject$ = package$.MODULE$.JObject();
            List list = jObject.obj();
            CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(x0$1);
                }
                Tuple2 tuple2 = new Tuple2(x0$1._1(), (Object)JsonParser$.reverse$1((JsonAST.JValue)x0$1._2()));
                return tuple2;
            };
            if (list == null) {
                throw null;
            }
            List map_this = list;
            if (map_bf == List$.MODULE$.ReusableCBF()) {
                if (map_this == Nil$.MODULE$) {
                    object = Nil$.MODULE$;
                } else {
                    .colon.colon map_h;
                    .colon.colon map_t = map_h = new .colon.colon((Object)JsonParser$.$anonfun$astParser$2((Tuple2)map_this.head()), (List)Nil$.MODULE$);
                    for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                        .colon.colon map_nx = new .colon.colon((Object)JsonParser$.$anonfun$astParser$2((Tuple2)map_rest.head()), (List)Nil$.MODULE$);
                        map_t.tl_$eq((List)map_nx);
                        map_t = map_nx;
                    }
                    object = map_h;
                }
            } else {
                void map_f;
                object = TraversableLike.map$((TraversableLike)map_this, (Function1)map_f, (CanBuildFrom)map_bf);
            }
            jValue = jObject$.apply(((List)object).reverse());
        } else if (v2 instanceof JsonAST.JArray) {
            Object object;
            void map_bf;
            JsonAST.JArray jArray = (JsonAST.JArray)v2;
            JsonAST.JArray$ jArray$ = package$.MODULE$.JArray();
            List list = jArray.arr();
            CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)v -> JsonParser$.reverse$1(v);
            if (list == null) {
                throw null;
            }
            List map_this = list;
            if (map_bf == List$.MODULE$.ReusableCBF()) {
                if (map_this == Nil$.MODULE$) {
                    object = Nil$.MODULE$;
                } else {
                    .colon.colon map_h;
                    .colon.colon map_t = map_h = new .colon.colon((Object)JsonParser$.reverse$1(v), (List)Nil$.MODULE$);
                    for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                        .colon.colon map_nx = new .colon.colon((Object)JsonParser$.reverse$1(v), (List)Nil$.MODULE$);
                        map_t.tl_$eq((List)map_nx);
                        map_t = map_nx;
                    }
                    object = map_h;
                }
            } else {
                void map_f;
                object = TraversableLike.map$((TraversableLike)map_this, (Function1)map_f, (CanBuildFrom)map_bf);
            }
            jValue = jArray$.apply(((List)object).reverse());
        } else {
            jValue = v2;
        }
        return jValue;
    }

    private static final JsonAST.JValue toJValue$1(Object x, JsonParser.Parser p$1) {
        if (!(x instanceof JsonAST.JValue)) {
            Throwable throwable;
            if (x instanceof Throwable && !NonFatal$.MODULE$.unapply(throwable = (Throwable)x).isEmpty()) {
                throw p$1.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpected field ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x})));
            }
            throw new MatchError(x);
        }
        JsonAST.JValue jValue = (JsonAST.JValue)x;
        return jValue;
    }

    private static final void closeBlock$1(Object v, JsonParser.ValStack vals$1, ObjectRef root$1, JsonParser.Parser p$1) {
        boolean bl = false;
        Some some = null;
        Option<Object> option = vals$1.peekOption();
        if (option instanceof Some) {
            Tuple2 tuple2;
            bl = true;
            some = (Some)option;
            if (some.value() instanceof Tuple2 && (tuple2 = (Tuple2)some.value())._1() instanceof String) {
                String string = (String)tuple2._1();
                vals$1.pop(Tuple2.class);
                JsonAST.JObject obj = vals$1.peek(JsonAST.JObject.class);
                if (!(v instanceof JsonAST.JValue)) {
                    Throwable throwable;
                    if (v instanceof Throwable && !NonFatal$.MODULE$.unapply(throwable = (Throwable)v).isEmpty()) {
                        throw p$1.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpected field ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v})));
                    }
                    throw new MatchError(v);
                }
                JsonAST.JValue jValue = (JsonAST.JValue)v;
                Tuple2 tuple22 = new Tuple2((Object)string, (Object)jValue);
                vals$1.replace(package$.MODULE$.JObject().apply(obj.obj().$colon$colon((Object)tuple22)));
                return;
            }
        }
        if (bl && some.value() instanceof JsonAST.JObject) {
            JsonAST.JObject jObject = (JsonAST.JObject)some.value();
            Tuple2 tuple2 = vals$1.peek(Tuple2.class);
            vals$1.replace(package$.MODULE$.JObject().apply(jObject.obj().$colon$colon((Object)tuple2)));
            return;
        }
        if (bl && some.value() instanceof JsonAST.JArray) {
            JsonAST.JArray jArray = (JsonAST.JArray)some.value();
            if (!(v instanceof JsonAST.JValue)) {
                Throwable throwable;
                if (v instanceof Throwable && !NonFatal$.MODULE$.unapply(throwable = (Throwable)v).isEmpty()) {
                    throw p$1.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpected field ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v})));
                }
                throw new MatchError(v);
            }
            JsonAST.JValue jValue = (JsonAST.JValue)v;
            vals$1.replace(package$.MODULE$.JArray().apply(jArray.arr().$colon$colon((Object)jValue)));
            return;
        }
        if (bl) {
            throw p$1.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected field, array or object but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{some.value()})));
        }
        if (None$.MODULE$.equals(option)) {
            if (!(v instanceof JsonAST.JValue)) {
                Throwable throwable;
                if (v instanceof Throwable && !NonFatal$.MODULE$.unapply(throwable = (Throwable)v).isEmpty()) {
                    throw p$1.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpected field ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v})));
                }
                throw new MatchError(v);
            }
            JsonAST.JValue jValue = (JsonAST.JValue)v;
            root$1.elem = new Some((Object)JsonParser$.reverse$1(jValue));
            return;
        }
        throw new MatchError(option);
    }

    private static final void newValue$1(JsonAST.JValue v, JsonParser.ValStack vals$1, JsonParser.Parser p$1) {
        Tuple2 tuple2;
        Object object = vals$1.peekAny();
        if (object instanceof Tuple2 && (tuple2 = (Tuple2)object)._1() instanceof String) {
            String string = (String)tuple2._1();
            vals$1.pop(Tuple2.class);
            JsonAST.JObject obj = vals$1.peek(JsonAST.JObject.class);
            Tuple2 tuple22 = new Tuple2((Object)string, (Object)v);
            vals$1.replace(package$.MODULE$.JObject().apply(obj.obj().$colon$colon((Object)tuple22)));
            return;
        }
        if (object instanceof JsonAST.JArray) {
            JsonAST.JArray jArray = (JsonAST.JArray)object;
            vals$1.replace(package$.MODULE$.JArray().apply(jArray.arr().$colon$colon((Object)v)));
            return;
        }
        throw p$1.fail("expected field or array");
    }

    public static final /* synthetic */ JsonAST.JValue $anonfun$astParser$1(JsonParser.Parser p, boolean useBigDecimal, boolean useBigIntForLong) {
        JsonParser$End$ jsonParser$End$;
        JsonParser.Token token;
        JsonParser.ValStack vals = new JsonParser.ValStack(p);
        ObjectRef root = ObjectRef.create((Object)None$.MODULE$);
        do {
            JsonParser.Token token2;
            if (JsonParser$OpenObj$.MODULE$.equals(token2 = p.nextToken())) {
                vals.push(package$.MODULE$.JObject().apply((List)Nil$.MODULE$));
            } else if (token2 instanceof JsonParser.FieldStart) {
                JsonParser.FieldStart fieldStart = (JsonParser.FieldStart)token2;
                vals.push(package$.MODULE$.JField().apply(fieldStart.name(), null));
            } else if (token2 instanceof JsonParser.StringVal) {
                JsonParser.StringVal stringVal = (JsonParser.StringVal)token2;
                JsonParser$.newValue$1((JsonAST.JValue)package$.MODULE$.JString().apply(stringVal.value()), vals, p);
            } else if (token2 instanceof JsonParser.IntVal) {
                JsonParser.IntVal intVal = (JsonParser.IntVal)token2;
                JsonParser$.newValue$1((JsonAST.JValue)package$.MODULE$.JInt().apply(intVal.value()), vals, p);
            } else if (token2 instanceof JsonParser.LongVal) {
                JsonParser.LongVal longVal = (JsonParser.LongVal)token2;
                JsonParser$.newValue$1((JsonAST.JValue)package$.MODULE$.JLong().apply(longVal.value()), vals, p);
            } else if (token2 instanceof JsonParser.DoubleVal) {
                JsonParser.DoubleVal doubleVal = (JsonParser.DoubleVal)token2;
                JsonParser$.newValue$1((JsonAST.JValue)package$.MODULE$.JDouble().apply(doubleVal.value()), vals, p);
            } else if (token2 instanceof JsonParser.BigDecimalVal) {
                JsonParser.BigDecimalVal bigDecimalVal = (JsonParser.BigDecimalVal)token2;
                JsonParser$.newValue$1((JsonAST.JValue)package$.MODULE$.JDecimal().apply(bigDecimalVal.value()), vals, p);
            } else if (token2 instanceof JsonParser.BoolVal) {
                JsonParser.BoolVal boolVal = (JsonParser.BoolVal)token2;
                JsonParser$.newValue$1((JsonAST.JValue)package$.MODULE$.JBool().apply(boolVal.value()), vals, p);
            } else if (JsonParser$NullVal$.MODULE$.equals(token2)) {
                JsonParser$.newValue$1((JsonAST.JValue)package$.MODULE$.JNull(), vals, p);
            } else if (JsonParser$CloseObj$.MODULE$.equals(token2)) {
                JsonParser$.closeBlock$1(vals.popAny(), vals, root, p);
            } else if (JsonParser$OpenArr$.MODULE$.equals(token2)) {
                vals.push(package$.MODULE$.JArray().apply((List)Nil$.MODULE$));
            } else if (JsonParser$CloseArr$.MODULE$.equals(token2)) {
                JsonParser$.closeBlock$1(vals.pop(JsonAST.JArray.class), vals, root, p);
            } else if (!JsonParser$End$.MODULE$.equals(token2)) {
                throw new MatchError((Object)token2);
            }
            token = token2;
            jsonParser$End$ = JsonParser$End$.MODULE$;
        } while (token != null ? !token.equals(jsonParser$End$) : jsonParser$End$ != null);
        Option option = (Option)root.elem;
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? package$.MODULE$.JNothing() : getOrElse_this.get();
        return (JsonAST.JValue)object;
    }

    private JsonParser$() {
        MODULE$ = this;
        this.astParser = (Function3 & Serializable & scala.Serializable)(p, useBigDecimal, useBigIntForLong) -> JsonParser$.$anonfun$astParser$1(p, BoxesRunTime.unboxToBoolean((Object)useBigDecimal), BoxesRunTime.unboxToBoolean((Object)useBigIntForLong));
        this.org$json4s$native$JsonParser$$EOF = (char)-1;
    }
}

