/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.springmvc.scanner.builder;

import com.google.common.collect.ObjectArrays;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jsondoc.springmvc.scanner.SpringBuilderUtils;
import org.springframework.web.bind.annotation.RequestMapping;

public class SpringPathBuilder {
    public static Set<String> buildPath(Method method) {
        RequestMapping requestMapping;
        Class<?> controller = method.getDeclaringClass();
        HashSet<String> paths = new HashSet<String>();
        HashSet<Object> controllerMapping = new HashSet<String>();
        HashSet<Object> methodMapping = new HashSet<String>();
        if (SpringBuilderUtils.isAnnotated(controller, RequestMapping.class) && (SpringPathBuilder.valueMapping(requestMapping = SpringBuilderUtils.getAnnotation(controller, RequestMapping.class)).length > 0 || SpringPathBuilder.pathMapping(requestMapping).length > 0)) {
            controllerMapping = new HashSet<Object>(Arrays.asList(ObjectArrays.concat((Object[])requestMapping.value(), (Object[])SpringPathBuilder.pathMapping(requestMapping), String.class)));
        }
        if (SpringBuilderUtils.isAnnotated(method, RequestMapping.class) && ((requestMapping = SpringBuilderUtils.getAnnotation(method, RequestMapping.class)).value().length > 0 || SpringPathBuilder.pathMapping(requestMapping).length > 0)) {
            methodMapping = new HashSet<Object>(Arrays.asList(ObjectArrays.concat((Object[])requestMapping.value(), (Object[])SpringPathBuilder.pathMapping(requestMapping), String.class)));
        }
        if (controllerMapping.isEmpty()) {
            controllerMapping.add("");
        }
        if (methodMapping.isEmpty()) {
            methodMapping.add("");
        }
        for (String controllerPath : controllerMapping) {
            for (String methodPath : methodMapping) {
                String resolvedPath = SpringPathBuilder.needsToJoinWithSlash(controllerPath, methodPath) ? controllerPath + "/" + methodPath : controllerPath + methodPath;
                paths.add(resolvedPath);
            }
        }
        for (String path : paths) {
            if (!path.equals("")) continue;
            paths.remove(path);
            paths.add("/");
        }
        return paths;
    }

    private static boolean needsToJoinWithSlash(String controllerPath, String methodPath) {
        return !controllerPath.isEmpty() && !controllerPath.endsWith("/") && !methodPath.isEmpty() && !methodPath.startsWith("/");
    }

    private static String[] pathMapping(RequestMapping requestMapping) {
        try {
            return requestMapping.path();
        }
        catch (NoSuchMethodError e) {
            return new String[0];
        }
    }

    private static String[] valueMapping(RequestMapping requestMapping) {
        return requestMapping.value();
    }
}

