/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.springmvc.scanner.builder;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jsondoc.core.pojo.ApiVerb;
import org.jsondoc.springmvc.scanner.SpringBuilderUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class SpringVerbBuilder {
    public static Set<ApiVerb> buildVerb(Method method) {
        RequestMapping requestMapping;
        LinkedHashSet<ApiVerb> apiVerbs = new LinkedHashSet<ApiVerb>();
        Class<?> controller = method.getDeclaringClass();
        if (SpringBuilderUtils.isAnnotated(controller, RequestMapping.class)) {
            requestMapping = SpringBuilderUtils.getAnnotation(controller, RequestMapping.class);
            SpringVerbBuilder.getApiVerbFromRequestMapping(apiVerbs, requestMapping);
        }
        if (SpringBuilderUtils.isAnnotated(method, RequestMapping.class)) {
            requestMapping = SpringBuilderUtils.getAnnotation(method, RequestMapping.class);
            SpringVerbBuilder.getApiVerbFromRequestMapping(apiVerbs, requestMapping);
        }
        if (apiVerbs.isEmpty()) {
            apiVerbs.add(ApiVerb.GET);
        }
        return apiVerbs;
    }

    private static void getApiVerbFromRequestMapping(Set<ApiVerb> apiVerbs, RequestMapping requestMapping) {
        if (requestMapping.method().length > 0) {
            for (RequestMethod requestMethod : requestMapping.method()) {
                apiVerbs.add(ApiVerb.valueOf((String)requestMethod.name()));
            }
        }
    }
}

