/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.ant;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.jsonschema2pojo.AnnotationStyle;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.NoopAnnotator;
import org.jsonschema2pojo.SourceType;
import org.jsonschema2pojo.cli.Jsonschema2Pojo;

public class Jsonschema2PojoTask
extends Task
implements GenerationConfig {
    private boolean generateBuilders;
    private boolean usePrimitives;
    private File source;
    private File targetDirectory;
    private String targetPackage;
    private boolean skip;
    private char[] propertyWordDelimiters = new char[]{'-', ' ', '_'};
    private boolean useLongIntegers;
    private boolean useDoubleNumbers = true;
    private boolean includeHashcodeAndEquals = true;
    private boolean includeToString = true;
    private AnnotationStyle annotationStyle = AnnotationStyle.JACKSON;
    private Class<? extends Annotator> customAnnotator = NoopAnnotator.class;
    private boolean includeJsr303Annotations = false;
    private SourceType sourceType = SourceType.JSONSCHEMA;
    private Path classpath;
    private boolean removeOldOutput;
    private String outputEncoding = "UTF-8";
    private boolean useJodaDates;

    public void execute() throws BuildException {
        if (this.skip) {
            return;
        }
        if (this.source == null) {
            this.log("source attribute is required but was not set");
            return;
        }
        if (!this.source.exists()) {
            this.log(this.source.getAbsolutePath() + " cannot be found");
            return;
        }
        if (this.targetDirectory == null) {
            this.log("targetDirectory attribute is required but was not set");
            return;
        }
        ClassLoader extendedClassloader = this.buildExtendedClassloader();
        Thread.currentThread().setContextClassLoader(extendedClassloader);
        try {
            Jsonschema2Pojo.generate((GenerationConfig)this);
        }
        catch (IOException e) {
            throw new BuildException("Error generating classes from JSON Schema file(s) " + this.source.getPath(), (Throwable)e);
        }
    }

    private ClassLoader buildExtendedClassloader() {
        final ArrayList<URL> classpathUrls = new ArrayList<URL>();
        for (String pathElement : this.getClasspath().list()) {
            try {
                classpathUrls.add(new File(pathElement).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new BuildException("Unable to use classpath entry as it could not be understood as a valid URL: " + pathElement, (Throwable)e);
            }
        }
        final ClassLoader parentClassloader = Thread.currentThread().getContextClassLoader();
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new URLClassLoader(classpathUrls.toArray(new URL[classpathUrls.size()]), parentClassloader);
            }
        });
    }

    public void setGenerateBuilders(boolean generateBuilders) {
        this.generateBuilders = generateBuilders;
    }

    public void setUsePrimitives(boolean usePrimitives) {
        this.usePrimitives = usePrimitives;
    }

    public void setUseLongIntegers(boolean useLongIntegers) {
        this.useLongIntegers = useLongIntegers;
    }

    public void setUseDoubleNumbers(boolean useDoubleNumbers) {
        this.useDoubleNumbers = useDoubleNumbers;
    }

    public void setSource(File source) {
        this.source = source;
    }

    public void setTargetDirectory(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public void setTargetPackage(String targetPackage) {
        this.targetPackage = targetPackage;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setPropertyWordDelimiters(String propertyWordDelimiters) {
        this.propertyWordDelimiters = StringUtils.defaultString((String)propertyWordDelimiters).toCharArray();
    }

    public void setIncludeHashcodeAndEquals(boolean includeHashcodeAndEquals) {
        this.includeHashcodeAndEquals = includeHashcodeAndEquals;
    }

    public void setIncludeToString(boolean includeToString) {
        this.includeToString = includeToString;
    }

    public void setAnnotationStyle(AnnotationStyle annotationStyle) {
        this.annotationStyle = annotationStyle;
    }

    public void setCustomAnnotator(String customAnnotator) {
        if (StringUtils.isNotBlank((String)customAnnotator)) {
            try {
                this.customAnnotator = Class.forName(customAnnotator);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            this.customAnnotator = NoopAnnotator.class;
        }
    }

    public void setIncludeJsr303Annotations(boolean includeJsr303Annotations) {
        this.includeJsr303Annotations = includeJsr303Annotations;
    }

    public void setSourceType(SourceType sourceType) {
        this.sourceType = sourceType;
    }

    public void setRemoveOldOutput(boolean removeOldOutput) {
        this.removeOldOutput = removeOldOutput;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setUseJodaDates(boolean useJodaDates) {
        this.useJodaDates = useJodaDates;
    }

    public boolean isGenerateBuilders() {
        return this.generateBuilders;
    }

    public boolean isUsePrimitives() {
        return this.usePrimitives;
    }

    public Iterator<File> getSource() {
        return Collections.singleton(this.source).iterator();
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public String getTargetPackage() {
        return this.targetPackage;
    }

    public char[] getPropertyWordDelimiters() {
        return (char[])this.propertyWordDelimiters.clone();
    }

    public boolean isSkip() {
        return this.skip;
    }

    public boolean isUseLongIntegers() {
        return this.useLongIntegers;
    }

    public boolean isUseDoubleNumbers() {
        return this.useDoubleNumbers;
    }

    public boolean isIncludeHashcodeAndEquals() {
        return this.includeHashcodeAndEquals;
    }

    public boolean isIncludeToString() {
        return this.includeToString;
    }

    public AnnotationStyle getAnnotationStyle() {
        return this.annotationStyle;
    }

    public Class<? extends Annotator> getCustomAnnotator() {
        return this.customAnnotator;
    }

    public boolean isIncludeJsr303Annotations() {
        return this.includeJsr303Annotations;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspath(Path classpath) {
        if (classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public void setClasspathRef(Reference classpathRef) {
        this.createClasspath().setRefid(classpathRef);
    }

    public Path getClasspath() {
        return this.classpath == null ? new Path(this.getProject()) : this.classpath;
    }

    public boolean isRemoveOldOutput() {
        return this.removeOldOutput;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public boolean isUseJodaDates() {
        return this.useJodaDates;
    }
}

