/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.ant;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.jsonschema2pojo.AllFileFilter;
import org.jsonschema2pojo.AnnotationStyle;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Jsonschema2Pojo;
import org.jsonschema2pojo.NoopAnnotator;
import org.jsonschema2pojo.SourceType;
import org.jsonschema2pojo.URLProtocol;
import org.jsonschema2pojo.rules.RuleFactory;
import org.jsonschema2pojo.util.URLUtil;

public class Jsonschema2PojoTask
extends Task
implements GenerationConfig {
    private boolean generateBuilders;
    private boolean includeConstructors = false;
    private boolean usePrimitives;
    private String source;
    private File targetDirectory;
    private String targetPackage;
    private boolean skip;
    private char[] propertyWordDelimiters = new char[]{'-', ' ', '_'};
    private boolean useLongIntegers;
    private boolean useDoubleNumbers = true;
    private boolean includeHashcodeAndEquals = true;
    private boolean includeToString = true;
    private AnnotationStyle annotationStyle = AnnotationStyle.JACKSON;
    private Class<? extends Annotator> customAnnotator = NoopAnnotator.class;
    private Class<? extends RuleFactory> customRuleFactory = RuleFactory.class;
    private boolean includeJsr303Annotations = false;
    private SourceType sourceType = SourceType.JSONSCHEMA;
    private Path classpath;
    private boolean removeOldOutput = false;
    private String outputEncoding = "UTF-8";
    private boolean useJodaDates = false;
    private boolean useJodaLocalDates = false;
    private boolean useJodaLocalTimes = false;
    private boolean useCommonsLang3 = false;
    private boolean parcelable = false;
    private boolean initializeCollections = true;
    private String classNamePrefix = "";
    private String classNameSuffix = "";
    private boolean constructorsRequiredPropertiesOnly = false;
    private boolean includeAdditionalProperties = true;
    private boolean includeAccessors = true;
    private String targetVersion = "1.6";
    private boolean includeDynamicAccessors = true;

    public void execute() throws BuildException {
        File sourceFile;
        URL sourceURL;
        if (this.skip) {
            return;
        }
        if (this.source == null) {
            this.log("source attribute is required but was not set");
            return;
        }
        try {
            sourceURL = URLUtil.parseURL((String)this.source);
        }
        catch (IllegalArgumentException e) {
            this.log(String.format("Invalid schema source provided: %s", this.source));
            return;
        }
        if (URLUtil.parseProtocol((String)sourceURL.toString()) == URLProtocol.FILE && !(sourceFile = new File(sourceURL.getFile())).exists()) {
            this.log(sourceFile.getAbsolutePath() + " cannot be found");
            return;
        }
        if (this.targetDirectory == null) {
            this.log("targetDirectory attribute is required but was not set");
            return;
        }
        ClassLoader extendedClassloader = this.buildExtendedClassloader();
        Thread.currentThread().setContextClassLoader(extendedClassloader);
        try {
            Jsonschema2Pojo.generate((GenerationConfig)this);
        }
        catch (IOException e) {
            throw new BuildException("Error generating classes from JSON Schema file(s) " + this.source, (Throwable)e);
        }
    }

    private ClassLoader buildExtendedClassloader() {
        final ArrayList<URL> classpathUrls = new ArrayList<URL>();
        for (String pathElement : this.getClasspath().list()) {
            try {
                classpathUrls.add(new File(pathElement).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new BuildException("Unable to use classpath entry as it could not be understood as a valid URL: " + pathElement, (Throwable)e);
            }
        }
        final ClassLoader parentClassloader = Thread.currentThread().getContextClassLoader();
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new URLClassLoader(classpathUrls.toArray(new URL[classpathUrls.size()]), parentClassloader);
            }
        });
    }

    public void setIncludeConstructors(boolean includeConstructors) {
        this.includeConstructors = includeConstructors;
    }

    public void setConstructorsRequiredPropertiesOnly(boolean constructorsRequiredPropertiesOnly) {
        this.constructorsRequiredPropertiesOnly = constructorsRequiredPropertiesOnly;
    }

    public void setGenerateBuilders(boolean generateBuilders) {
        this.generateBuilders = generateBuilders;
    }

    public void setUsePrimitives(boolean usePrimitives) {
        this.usePrimitives = usePrimitives;
    }

    public void setUseLongIntegers(boolean useLongIntegers) {
        this.useLongIntegers = useLongIntegers;
    }

    public void setUseDoubleNumbers(boolean useDoubleNumbers) {
        this.useDoubleNumbers = useDoubleNumbers;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setTargetDirectory(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public void setTargetPackage(String targetPackage) {
        this.targetPackage = targetPackage;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setPropertyWordDelimiters(String propertyWordDelimiters) {
        this.propertyWordDelimiters = StringUtils.defaultString((String)propertyWordDelimiters).toCharArray();
    }

    public void setIncludeHashcodeAndEquals(boolean includeHashcodeAndEquals) {
        this.includeHashcodeAndEquals = includeHashcodeAndEquals;
    }

    public void setIncludeToString(boolean includeToString) {
        this.includeToString = includeToString;
    }

    public void setAnnotationStyle(AnnotationStyle annotationStyle) {
        this.annotationStyle = annotationStyle;
    }

    public void setCustomAnnotator(String customAnnotator) {
        if (StringUtils.isNotBlank((CharSequence)customAnnotator)) {
            try {
                this.customAnnotator = Class.forName(customAnnotator);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            this.customAnnotator = NoopAnnotator.class;
        }
    }

    public void setCustomRuleFactory(String customRuleFactory) {
        if (StringUtils.isNotBlank((CharSequence)customRuleFactory)) {
            try {
                this.customRuleFactory = Class.forName(customRuleFactory);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            this.customRuleFactory = RuleFactory.class;
        }
    }

    public void setIncludeJsr303Annotations(boolean includeJsr303Annotations) {
        this.includeJsr303Annotations = includeJsr303Annotations;
    }

    public void setSourceType(SourceType sourceType) {
        this.sourceType = sourceType;
    }

    public void setRemoveOldOutput(boolean removeOldOutput) {
        this.removeOldOutput = removeOldOutput;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setUseJodaDates(boolean useJodaDates) {
        this.useJodaDates = useJodaDates;
    }

    public void setUseJodaLocalDates(boolean useJodaLocalDates) {
        this.useJodaLocalDates = useJodaLocalDates;
    }

    public void setUseJodaLocalTimes(boolean useJodaLocalTimes) {
        this.useJodaLocalTimes = useJodaLocalTimes;
    }

    public void setUseCommonsLang3(boolean useCommonsLang3) {
        this.useCommonsLang3 = useCommonsLang3;
    }

    public void setParcelable(boolean parcelable) {
        this.parcelable = parcelable;
    }

    public void setInitializeCollections(boolean initializeCollections) {
        this.initializeCollections = initializeCollections;
    }

    public void setIncludeAdditionalProperties(boolean includeAdditionalProperties) {
        this.includeAdditionalProperties = includeAdditionalProperties;
    }

    public void setIncludeAccessors(boolean includeAccessors) {
        this.includeAccessors = includeAccessors;
    }

    public void setTargetVersion(String targetVersion) {
        this.targetVersion = targetVersion;
    }

    public void setIncludeDynamicAccessors(boolean includeDynamicAccessors) {
        this.includeDynamicAccessors = includeDynamicAccessors;
    }

    public boolean isGenerateBuilders() {
        return this.generateBuilders;
    }

    public boolean isUsePrimitives() {
        return this.usePrimitives;
    }

    public Iterator<URL> getSource() {
        return Collections.singleton(URLUtil.parseURL((String)this.source)).iterator();
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public String getTargetPackage() {
        return this.targetPackage;
    }

    public char[] getPropertyWordDelimiters() {
        return (char[])this.propertyWordDelimiters.clone();
    }

    public boolean isSkip() {
        return this.skip;
    }

    public boolean isUseLongIntegers() {
        return this.useLongIntegers;
    }

    public boolean isUseDoubleNumbers() {
        return this.useDoubleNumbers;
    }

    public boolean isIncludeHashcodeAndEquals() {
        return this.includeHashcodeAndEquals;
    }

    public boolean isIncludeToString() {
        return this.includeToString;
    }

    public AnnotationStyle getAnnotationStyle() {
        return this.annotationStyle;
    }

    public Class<? extends Annotator> getCustomAnnotator() {
        return this.customAnnotator;
    }

    public Class<? extends RuleFactory> getCustomRuleFactory() {
        return this.customRuleFactory;
    }

    public boolean isIncludeJsr303Annotations() {
        return this.includeJsr303Annotations;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public void setClasspathRef(Reference classpathRef) {
        this.createClasspath().setRefid(classpathRef);
    }

    public Path getClasspath() {
        return this.classpath == null ? new Path(this.getProject()) : this.classpath;
    }

    public boolean isRemoveOldOutput() {
        return this.removeOldOutput;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public boolean isUseJodaDates() {
        return this.useJodaDates;
    }

    public boolean isUseJodaLocalDates() {
        return this.useJodaLocalDates;
    }

    public boolean isUseJodaLocalTimes() {
        return this.useJodaLocalTimes;
    }

    public boolean isUseCommonsLang3() {
        return this.useCommonsLang3;
    }

    public boolean isParcelable() {
        return this.parcelable;
    }

    public FileFilter getFileFilter() {
        return new AllFileFilter();
    }

    public boolean isInitializeCollections() {
        return this.initializeCollections;
    }

    public String getClassNamePrefix() {
        return this.classNamePrefix;
    }

    public String getClassNameSuffix() {
        return this.classNameSuffix;
    }

    public boolean isIncludeConstructors() {
        return this.includeConstructors;
    }

    public boolean isConstructorsRequiredPropertiesOnly() {
        return this.constructorsRequiredPropertiesOnly;
    }

    public boolean isIncludeAdditionalProperties() {
        return this.includeAdditionalProperties;
    }

    public boolean isIncludeAccessors() {
        return this.includeAccessors;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public boolean isIncludeDynamicAccessors() {
        return this.includeDynamicAccessors;
    }
}

