/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.maven;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.xml.Xpp3Dom;
import org.jsonschema2pojo.AllFileFilter;
import org.jsonschema2pojo.AnnotationStyle;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.AnnotatorFactory;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.InclusionLevel;
import org.jsonschema2pojo.Jsonschema2Pojo;
import org.jsonschema2pojo.NoopAnnotator;
import org.jsonschema2pojo.RuleLogger;
import org.jsonschema2pojo.SourceSortOrder;
import org.jsonschema2pojo.SourceType;
import org.jsonschema2pojo.maven.MatchPatternsFileFilter;
import org.jsonschema2pojo.maven.MojoRuleLogger;
import org.jsonschema2pojo.maven.ProjectClasspath;
import org.jsonschema2pojo.rules.RuleFactory;
import org.jsonschema2pojo.util.JavaVersion;
import org.jsonschema2pojo.util.URLUtil;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class Jsonschema2PojoMojo
extends AbstractMojo
implements GenerationConfig {
    @Parameter(property="jsonschema2pojo.outputDirectory", defaultValue="${project.build.directory}/generated-sources/jsonschema2pojo")
    private File outputDirectory;
    @Parameter(property="jsonschema2pojo.sourceDirectory")
    private String sourceDirectory;
    @Parameter(property="jsonschema2pojo.sourcePaths")
    private String[] sourcePaths;
    @Parameter(property="jsonschema2pojo.targetPackage")
    private String targetPackage = "";
    @Parameter(property="jsonschema2pojo.generateBuilders", defaultValue="false")
    private boolean generateBuilders = false;
    @Parameter(property="jsonschema2pojo.includeTypeInfo", defaultValue="false")
    private boolean includeTypeInfo = false;
    @Parameter(property="jsonschema2pojo.usePrimitives", defaultValue="false")
    private boolean usePrimitives = false;
    @Parameter(property="jsonschema2pojo.addCompileSourceRoot", defaultValue="true")
    private boolean addCompileSourceRoot = true;
    @Parameter(property="jsonschema2pojo.skip", defaultValue="false")
    private boolean skip = false;
    @Parameter(property="jsonschema2pojo.propertyWordDelimiters", defaultValue="- _")
    private String propertyWordDelimiters = "- _";
    @Parameter(property="jsonschema2pojo.useLongIntegers", defaultValue="false")
    private boolean useLongIntegers = false;
    @Parameter(property="jsonschema2pojo.useBigIntegers", defaultValue="false")
    private boolean useBigIntegers = false;
    @Parameter(property="jsonschema2pojo.useDoubleNumbers", defaultValue="true")
    private boolean useDoubleNumbers = true;
    @Parameter(property="jsonschema2pojo.useBigDecimals", defaultValue="false")
    private boolean useBigDecimals = false;
    @Parameter(property="jsonschema2pojo.includeHashcodeAndEquals", defaultValue="true")
    private boolean includeHashcodeAndEquals = true;
    @Parameter(property="jsonschema2pojo.includeToString", defaultValue="true")
    private boolean includeToString = true;
    @Parameter(property="jsonschema2pojo.toStringExcludes", defaultValue="")
    private String[] toStringExcludes = new String[0];
    @Parameter(property="jsonschema2pojo.annotationStyle", defaultValue="jackson2")
    private String annotationStyle = "jackson2";
    @Parameter(property="jsonschema2pojo.useTitleAsClassname", defaultValue="false")
    private boolean useTitleAsClassname = false;
    @Parameter(property="jsonschema2pojo.inclusionLevel", defaultValue="NON_NULL")
    private String inclusionLevel = "NON_NULL";
    @Parameter(property="jsonschema2pojo.customAnnotator", defaultValue="org.jsonschema2pojo.NoopAnnotator")
    private String customAnnotator = NoopAnnotator.class.getName();
    @Parameter(property="jsonschema2pojo.customRuleFactory", defaultValue="org.jsonschema2pojo.rules.RuleFactory")
    private String customRuleFactory = RuleFactory.class.getName();
    @Parameter(property="jsonschema2pojo.includeJsr303Annotations", defaultValue="false")
    private boolean includeJsr303Annotations = false;
    @Parameter(property="jsonschema2pojo.includeJsr305Annotations", defaultValue="false")
    private boolean includeJsr305Annotations = false;
    @Parameter(property="jsonschema2pojo.useOptionalForGetters", defaultValue="false")
    private boolean useOptionalForGetters = false;
    @Parameter(property="jsonschema2pojo.sourceType", defaultValue="jsonschema")
    private String sourceType = "jsonschema";
    @Parameter(property="jsonschema2pojo.removeOldOutput", defaultValue="false")
    private boolean removeOldOutput = false;
    @Parameter(property="jsonschema2pojo.outputEncoding", defaultValue="UTF-8")
    private String outputEncoding = "UTF-8";
    @Parameter(property="jsonschema2pojo.useJodaDates", defaultValue="false")
    private boolean useJodaDates = false;
    @Parameter(property="jsonschema2pojo.useJodaLocalDates", defaultValue="false")
    private boolean useJodaLocalDates = false;
    @Parameter(property="jsonschema2pojo.useJodaLocalTimes", defaultValue="false")
    private boolean useJodaLocalTimes = false;
    @Parameter(property="jsonschema2pojo.dateTimeType")
    private String dateTimeType = null;
    @Parameter(property="jsonschema2pojo.timeType")
    private String timeType = null;
    @Parameter(property="jsonschema2pojo.dateType")
    private String dateType = null;
    @Parameter(property="jsonschema2pojo.useCommonsLang3", defaultValue="false")
    private boolean useCommonsLang3 = false;
    @Parameter(property="jsonschema2pojo.parcelable", defaultValue="false")
    private boolean parcelable = false;
    @Parameter(property="jsonschema2pojo.serializable", defaultValue="false")
    private boolean serializable = false;
    @Parameter(property="jsonschema2pojo.initializeCollections", defaultValue="true")
    private boolean initializeCollections = true;
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter(property="jsonschema2pojo.classNamePrefix")
    private String classNamePrefix = "";
    @Parameter(property="jsonschema2pojo.classNameSuffix")
    private String classNameSuffix = "";
    @Parameter(property="jsonschema2pojo.fileExtensions", defaultValue="")
    private String[] fileExtensions = new String[0];
    @Parameter(property="jsonschema2pojo.includeConstructors", defaultValue="false")
    private boolean includeConstructors = false;
    @Parameter(property="jsonschema2pojo.constructorsRequiredPropertiesOnly", defaultValue="false")
    private boolean constructorsRequiredPropertiesOnly = false;
    @Parameter(property="jsonschema2pojo.includeRequiredPropertiesConstructor", defaultValue="false")
    private boolean includeRequiredPropertiesConstructor = false;
    @Parameter(property="jsonschema2pojo.includeAllPropertiesConstructor", defaultValue="true")
    private boolean includeAllPropertiesConstructor = true;
    @Parameter(property="jsonschema2pojo.includeCopyConstructor", defaultValue="false")
    private boolean includeCopyConstructor = false;
    @Parameter(property="jsonschema2pojo.includeAdditionalProperties", defaultValue="true")
    private boolean includeAdditionalProperties = true;
    @Parameter(property="jsonschema2pojo.includeGetters", defaultValue="true")
    private boolean includeGetters = true;
    @Parameter(property="jsonschema2pojo.includeSetters", defaultValue="true")
    private boolean includeSetters = true;
    @Parameter(property="jsonschema2pojo.targetVersion")
    private String targetVersion;
    @Parameter(property="jsonschema2pojo.includeDynamicAccessors")
    private boolean includeDynamicAccessors = false;
    @Parameter(property="jsonschema2pojo.includeDynamicGetters", defaultValue="false")
    private boolean includeDynamicGetters = false;
    @Parameter(property="jsonschema2pojo.includeDynamicSetters", defaultValue="false")
    private boolean includeDynamicSetters = false;
    @Parameter(property="jsonschema2pojo.includeDynamicBuilders", defaultValue="false")
    private boolean includeDynamicBuilders = false;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="jsonschema2pojo.formatDates", defaultValue="false")
    private boolean formatDates = false;
    @Parameter(property="jsonschema2pojo.formatTimes", defaultValue="false")
    private boolean formatTimes = false;
    @Parameter(property="jsonschema2pojo.formatDateTimes", defaultValue="false")
    private boolean formatDateTimes = false;
    @Parameter(property="jsonschema2pojo.customDatePattern")
    private String customDatePattern;
    @Parameter(property="jsonschema2pojo.customTimePattern")
    private String customTimePattern;
    @Parameter(property="jsonschema2pojo.customDatePattern")
    private String customDateTimePattern;
    @Parameter(property="jsonschema2pojo.refFragmentPathDelimiters", defaultValue="#/.")
    private String refFragmentPathDelimiters = "#/.";
    private FileFilter fileFilter = new AllFileFilter();
    @Parameter(property="jsonschema2pojo.sourceSortOrder", defaultValue="OS")
    private String sourceSortOrder = SourceSortOrder.OS.toString();
    @Parameter(property="jsonschema2pojo.formatTypeMapping", defaultValue="")
    private Map<String, String> formatTypeMapping = new HashMap<String, String>();
    @Parameter(property="jsonschema2pojo.useInnerClassBuilders", defaultValue="false")
    private boolean useInnerClassBuilders = false;
    @Parameter(property="jsonschema2pojo.includeConstructorPropertiesAnnotation", defaultValue="false")
    private boolean includeConstructorPropertiesAnnotation = false;
    @Parameter(property="jsonschema2pojo.includeGeneratedAnnotation", defaultValue="true")
    private boolean includeGeneratedAnnotation = true;
    @Parameter(property="jsonschema2pojo.useJakartaValidation", defaultValue="false")
    private boolean useJakartaValidation = false;

    @SuppressWarnings(value={"NP_UNWRITTEN_FIELD", "UWF_UNWRITTEN_FIELD"}, justification="Private fields set by Maven.")
    public void execute() throws MojoExecutionException {
        this.addProjectDependenciesToClasspath();
        this.setTargetVersion();
        try {
            this.getAnnotationStyle();
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException("Not a valid annotation style: " + this.annotationStyle);
        }
        try {
            new AnnotatorFactory((GenerationConfig)this).getAnnotator(this.getCustomAnnotator());
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        if (this.skip) {
            return;
        }
        if (this.sourceDirectory != null) {
            this.sourceDirectory = FilenameUtils.normalize((String)this.sourceDirectory);
            try {
                URLUtil.parseURL((String)this.sourceDirectory);
            }
            catch (IllegalArgumentException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        } else if (!ArrayUtils.isEmpty((Object[])this.sourcePaths)) {
            for (int i = 0; i < this.sourcePaths.length; ++i) {
                this.sourcePaths[i] = FilenameUtils.normalize((String)this.sourcePaths[i]);
                try {
                    URLUtil.parseURL((String)this.sourcePaths[i]);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
        } else {
            throw new MojoExecutionException("One of sourceDirectory or sourcePaths must be provided");
        }
        if (this.filteringEnabled() || this.sourceDirectory != null && ArrayUtils.isEmpty((Object[])this.sourcePaths)) {
            if (this.sourceDirectory == null) {
                throw new MojoExecutionException("Source includes and excludes require the sourceDirectory property");
            }
            if (!ArrayUtils.isEmpty((Object[])this.sourcePaths)) {
                throw new MojoExecutionException("Source includes and excludes are incompatible with the sourcePaths property");
            }
            this.fileFilter = this.createFileFilter();
        }
        if (this.addCompileSourceRoot) {
            this.project.addCompileSourceRoot(this.outputDirectory.getPath());
        }
        if (this.useCommonsLang3) {
            this.getLog().warn((CharSequence)"useCommonsLang3 is deprecated. Please remove it from your config.");
        }
        MojoRuleLogger logger = new MojoRuleLogger(this.getLog());
        try {
            Jsonschema2Pojo.generate((GenerationConfig)this, (RuleLogger)logger);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error generating classes from JSON Schema file(s) " + this.sourceDirectory, (Exception)e);
        }
    }

    private void addProjectDependenciesToClasspath() {
        try {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader newClassLoader = new ProjectClasspath().getClassLoader(this.project, oldClassLoader, this.getLog());
            Thread.currentThread().setContextClassLoader(newClassLoader);
        }
        catch (DependencyResolutionRequiredException e) {
            this.getLog().info((CharSequence)"Skipping addition of project artifacts, there appears to be a dependecy resolution problem", (Throwable)e);
        }
    }

    public boolean isGenerateBuilders() {
        return this.generateBuilders;
    }

    public boolean isIncludeTypeInfo() {
        return this.includeTypeInfo;
    }

    public boolean isIncludeConstructorPropertiesAnnotation() {
        return this.includeConstructorPropertiesAnnotation;
    }

    public File getTargetDirectory() {
        return this.outputDirectory;
    }

    public Iterator<URL> getSource() {
        if (null != this.sourceDirectory) {
            return Collections.singleton(URLUtil.parseURL((String)this.sourceDirectory)).iterator();
        }
        ArrayList<URL> sourceURLs = new ArrayList<URL>();
        for (String source : this.sourcePaths) {
            sourceURLs.add(URLUtil.parseURL((String)source));
        }
        return sourceURLs.iterator();
    }

    public boolean isUsePrimitives() {
        return this.usePrimitives;
    }

    public String getTargetPackage() {
        return this.targetPackage;
    }

    public char[] getPropertyWordDelimiters() {
        return this.propertyWordDelimiters.toCharArray();
    }

    public boolean isUseLongIntegers() {
        return this.useLongIntegers;
    }

    public boolean isUseDoubleNumbers() {
        return this.useDoubleNumbers;
    }

    public boolean isIncludeHashcodeAndEquals() {
        return this.includeHashcodeAndEquals;
    }

    public boolean isIncludeToString() {
        return this.includeToString;
    }

    public String[] getToStringExcludes() {
        return this.toStringExcludes;
    }

    public AnnotationStyle getAnnotationStyle() {
        return AnnotationStyle.valueOf((String)this.annotationStyle.toUpperCase());
    }

    public boolean isUseTitleAsClassname() {
        return this.useTitleAsClassname;
    }

    public InclusionLevel getInclusionLevel() {
        return InclusionLevel.valueOf((String)this.inclusionLevel.toUpperCase());
    }

    public Class<? extends Annotator> getCustomAnnotator() {
        if (StringUtils.isNotBlank((CharSequence)this.customAnnotator)) {
            try {
                return Class.forName(this.customAnnotator);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return NoopAnnotator.class;
    }

    public Class<? extends RuleFactory> getCustomRuleFactory() {
        if (StringUtils.isNotBlank((CharSequence)this.customRuleFactory)) {
            try {
                return Class.forName(this.customRuleFactory);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return RuleFactory.class;
    }

    public boolean isIncludeJsr303Annotations() {
        return this.includeJsr303Annotations;
    }

    public boolean isIncludeJsr305Annotations() {
        return this.includeJsr305Annotations;
    }

    public boolean isUseOptionalForGetters() {
        return this.useOptionalForGetters;
    }

    public SourceType getSourceType() {
        return SourceType.valueOf((String)this.sourceType.toUpperCase());
    }

    public boolean isRemoveOldOutput() {
        return this.removeOldOutput;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public boolean isUseJodaDates() {
        return this.useJodaDates;
    }

    public boolean isUseJodaLocalDates() {
        return this.useJodaLocalDates;
    }

    public boolean isUseJodaLocalTimes() {
        return this.useJodaLocalTimes;
    }

    @Deprecated
    public boolean isUseCommonsLang3() {
        return this.useCommonsLang3;
    }

    public boolean isParcelable() {
        return this.parcelable;
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public boolean isInitializeCollections() {
        return this.initializeCollections;
    }

    boolean filteringEnabled() {
        return this.includes != null && this.includes.length != 0 || this.excludes != null && this.excludes.length != 0;
    }

    FileFilter createFileFilter() throws MojoExecutionException {
        try {
            URL urlSource = URLUtil.parseURL((String)this.sourceDirectory);
            return new MatchPatternsFileFilter.Builder().addIncludes(this.includes).addExcludes(this.excludes).addDefaultExcludes().withSourceDirectory(URLUtil.getFileFromURL((URL)urlSource).getCanonicalPath()).withCaseSensitive(false).build();
        }
        catch (IOException e) {
            throw new MojoExecutionException("could not create file filter", (Exception)e);
        }
    }

    public String getClassNamePrefix() {
        return this.classNamePrefix;
    }

    public String getClassNameSuffix() {
        return this.classNameSuffix;
    }

    public String[] getFileExtensions() {
        return this.fileExtensions;
    }

    public boolean isIncludeConstructors() {
        return this.includeConstructors;
    }

    public boolean isConstructorsRequiredPropertiesOnly() {
        return this.constructorsRequiredPropertiesOnly;
    }

    public boolean isIncludeRequiredPropertiesConstructor() {
        return this.includeRequiredPropertiesConstructor;
    }

    public boolean isIncludeAllPropertiesConstructor() {
        return this.includeAllPropertiesConstructor;
    }

    public boolean isIncludeCopyConstructor() {
        return this.includeCopyConstructor;
    }

    public boolean isIncludeAdditionalProperties() {
        return this.includeAdditionalProperties;
    }

    public boolean isIncludeGetters() {
        return this.includeGetters;
    }

    public boolean isIncludeSetters() {
        return this.includeSetters;
    }

    private void setTargetVersion() {
        if (StringUtils.isNotBlank((CharSequence)this.targetVersion)) {
            return;
        }
        if (this.project.getProperties() != null && this.project.getProperties().containsKey("maven.compiler.source")) {
            this.targetVersion = this.project.getProperties().get("maven.compiler.source").toString();
            this.getLog().debug((CharSequence)("Using maven.compiler.source to set targetVersion for generated sources (" + this.targetVersion + ")"));
            return;
        }
        if (this.project.getProperties() != null && this.project.getProperties().containsKey("maven.compiler.release")) {
            this.targetVersion = this.project.getProperties().get("maven.compiler.release").toString();
            this.getLog().debug((CharSequence)("Using maven.compiler.release to set targetVersion for generated sources (" + this.targetVersion + ")"));
            return;
        }
        for (Plugin p : this.project.getBuildPlugins()) {
            if (!p.getKey().equals("org.apache.maven.plugins:maven-compiler-plugin") || !(p.getConfiguration() instanceof Xpp3Dom)) continue;
            Xpp3Dom compilerSourceConfig = ((Xpp3Dom)p.getConfiguration()).getChild("source");
            if (compilerSourceConfig != null) {
                this.targetVersion = compilerSourceConfig.getValue();
                this.getLog().debug((CharSequence)("Using maven-compiler-plugin 'source' to set targetVersion for generated sources (" + this.targetVersion + ")"));
                return;
            }
            Xpp3Dom compilerReleaseConfig = ((Xpp3Dom)p.getConfiguration()).getChild("release");
            if (compilerReleaseConfig == null) continue;
            this.targetVersion = compilerReleaseConfig.getValue();
            this.getLog().debug((CharSequence)("Using maven-compiler-plugin 'release' to set targetVersion for generated sources (" + this.targetVersion + ")"));
            return;
        }
        this.targetVersion = JavaVersion.parse((String)System.getProperty("java.version"));
        this.getLog().debug((CharSequence)("Using JVM to set targetVersion for generated sources (" + this.targetVersion + ")"));
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public boolean isIncludeDynamicAccessors() {
        return this.includeDynamicAccessors;
    }

    public boolean isIncludeDynamicGetters() {
        return this.includeDynamicGetters;
    }

    public boolean isIncludeDynamicSetters() {
        return this.includeDynamicSetters;
    }

    public boolean isIncludeDynamicBuilders() {
        return this.includeDynamicBuilders;
    }

    public String getDateTimeType() {
        return this.dateTimeType;
    }

    public String getDateType() {
        return this.dateType;
    }

    public String getTimeType() {
        return this.timeType;
    }

    public boolean isUseBigIntegers() {
        return this.useBigIntegers;
    }

    public boolean isUseBigDecimals() {
        return this.useBigDecimals;
    }

    public boolean isFormatDateTimes() {
        return this.formatDateTimes;
    }

    public boolean isFormatDates() {
        return this.formatDates;
    }

    public boolean isFormatTimes() {
        return this.formatTimes;
    }

    public String getCustomDatePattern() {
        return this.customDatePattern;
    }

    public String getCustomTimePattern() {
        return this.customTimePattern;
    }

    public String getCustomDateTimePattern() {
        return this.customDateTimePattern;
    }

    public String getRefFragmentPathDelimiters() {
        return this.refFragmentPathDelimiters;
    }

    public SourceSortOrder getSourceSortOrder() {
        return SourceSortOrder.valueOf((String)this.sourceSortOrder.toUpperCase());
    }

    public Map<String, String> getFormatTypeMapping() {
        return this.formatTypeMapping;
    }

    public boolean isUseInnerClassBuilders() {
        return this.useInnerClassBuilders;
    }

    public boolean isIncludeGeneratedAnnotation() {
        return this.includeGeneratedAnnotation;
    }

    public boolean isUseJakartaValidation() {
        return this.useJakartaValidation;
    }
}

