/*
 * Decompiled with CFR 0.152.
 */
package org.jsonurl.factory;

import java.util.Set;
import org.jsonurl.CompositeType;
import org.jsonurl.ExceptionProvider;
import org.jsonurl.JsonUrlLimits;
import org.jsonurl.JsonUrlOption;
import org.jsonurl.ValueType;
import org.jsonurl.factory.MissingValueProvider;
import org.jsonurl.factory.ParseResult;
import org.jsonurl.factory.Parser;
import org.jsonurl.factory.ValueFactory;
import org.jsonurl.stream.JsonUrlEvent;
import org.jsonurl.stream.JsonUrlIterator;

public class ValueFactoryParser<V, C extends V, ABT, A extends C, JBT, J extends C, B extends V, M extends V, N extends V, S extends V>
implements Parser<V, C, ABT, A, JBT, J, B, M, N, S> {
    private final ValueFactory<V, C, ABT, A, JBT, J, B, M, N, S> factory;
    private final Set<JsonUrlOption> options;
    private final JsonUrlLimits limits;

    public ValueFactoryParser(ValueFactory<V, C, ABT, A, JBT, J, B, M, N, S> factory, JsonUrlLimits limits, Set<JsonUrlOption> options) {
        this.factory = factory;
        this.limits = limits;
        this.options = options;
    }

    public Set<JsonUrlOption> options() {
        return this.options;
    }

    @Override
    public JsonUrlLimits limits() {
        return this.limits;
    }

    @Override
    public ValueFactory<V, C, ABT, A, JBT, J, B, M, N, S> factory() {
        return this.factory;
    }

    @Override
    public J parseObject(JsonUrlIterator iter, JBT impliedObject, MissingValueProvider<V> mvp) {
        if (impliedObject == null) {
            iter.setType(ValueType.OBJECT);
        } else {
            iter.setType(CompositeType.OBJECT);
        }
        return (J)this.parse(iter, new ParseResult<V, C, Object, A, JBT, J, B, M, N, S>(this.factory, null, impliedObject, mvp));
    }

    @Override
    public A parseArray(JsonUrlIterator iter, ABT impliedArray, MissingValueProvider<V> mvp) {
        if (impliedArray == null) {
            iter.setType(ValueType.ARRAY);
        } else {
            iter.setType(CompositeType.ARRAY);
        }
        return (A)this.parse(iter, new ParseResult<V, C, ABT, A, Object, J, B, M, N, S>(this.factory, impliedArray, null, mvp));
    }

    @Override
    public V parse(JsonUrlIterator iter) {
        return this.parse(iter, new ParseResult<V, C, Object, A, Object, J, B, M, N, S>(this.factory, null, null, null));
    }

    private V parse(JsonUrlIterator text, ParseResult<V, C, ABT, A, JBT, J, B, M, N, S> result) {
        while (true) {
            JsonUrlEvent evt = text.next();
            switch (evt) {
                case END_ARRAY: {
                    result.endArray();
                    break;
                }
                case END_OBJECT: {
                    result.endObject();
                    break;
                }
                case END_STREAM: {
                    return result.getResult();
                }
                case KEY_NAME: {
                    result.addObjectKey(text.getString());
                    break;
                }
                case START_ARRAY: {
                    result.beginArray();
                    break;
                }
                case START_OBJECT: {
                    result.beginObject();
                    break;
                }
                case VALUE_EMPTY_COMPOSITE: {
                    result.addEmptyComposite();
                    break;
                }
                case VALUE_EMPTY_LITERAL: {
                    result.addEmptyLiteral();
                    break;
                }
                case VALUE_FALSE: {
                    result.addFalse();
                    break;
                }
                case VALUE_MISSING: {
                    result.addMissingValue((ExceptionProvider)text);
                    break;
                }
                case VALUE_NULL: {
                    result.addNull();
                    break;
                }
                case VALUE_NUMBER: {
                    result.addNumber(text.getNumberText());
                    break;
                }
                case VALUE_STRING: {
                    result.addString(text.getString());
                    break;
                }
                case VALUE_TRUE: {
                    result.addTrue();
                }
            }
        }
    }

    public static class TransparentBuilder<V, C extends V, A extends C, J extends C, B extends V, M extends V, N extends V, S extends V>
    extends ValueFactoryParser<V, C, A, A, J, J, B, M, N, S>
    implements Parser.TransparentBuilder<V, C, A, J, B, M, N, S> {
        public TransparentBuilder(ValueFactory<V, C, A, A, J, J, B, M, N, S> factory, JsonUrlLimits limits, Set<JsonUrlOption> options) {
            super(factory, limits, options);
        }
    }
}

