/*
 * Decompiled with CFR 0.152.
 */
package org.jsonurl.j2se;

import java.io.IOException;
import java.nio.charset.MalformedInputException;
import java.util.Map;
import java.util.Set;
import org.jsonurl.JsonUrlOption;
import org.jsonurl.JsonUrlOptionable;
import org.jsonurl.j2se.JavaValueFactory;
import org.jsonurl.text.JsonTextBuilder;

public final class JsonUrlWriter {
    private JsonUrlWriter() {
    }

    private static boolean isNull(Object obj) {
        return obj == null || obj == JavaValueFactory.NULL;
    }

    public static <A, R> boolean write(JsonTextBuilder<R> dest, Object value) throws IOException {
        return JsonUrlWriter.write(dest, (Set<JsonUrlOption>)JsonUrlOptionable.getJsonUrlOptions(dest), value);
    }

    public static <A, R> boolean write(JsonTextBuilder<R> dest, Set<JsonUrlOption> options, Object value) throws IOException {
        if (JsonUrlWriter.isNull(value)) {
            if (JsonUrlOption.optionSkipNulls(options)) {
                return false;
            }
            return JsonUrlWriter.writeNull(dest, options);
        }
        if (value instanceof Number) {
            dest.add((Number)value);
            return true;
        }
        if (value instanceof Boolean) {
            dest.add(((Boolean)value).booleanValue());
            return true;
        }
        if (value instanceof Enum) {
            dest.add((CharSequence)((Enum)value).name());
            return true;
        }
        if (value instanceof Map) {
            return JsonUrlWriter.write(dest, options, (Map)value);
        }
        if (value instanceof Iterable) {
            return JsonUrlWriter.write(dest, options, (Iterable)value);
        }
        if (value instanceof CharSequence) {
            dest.add((CharSequence)value);
            return true;
        }
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            Class<?> type = clazz.getComponentType();
            if (type == Boolean.TYPE) {
                return JsonUrlWriter.write(dest, options, (boolean[])value);
            }
            if (type == Byte.TYPE) {
                return JsonUrlWriter.write(dest, options, (byte[])value);
            }
            if (type == Character.TYPE) {
                return JsonUrlWriter.write(dest, options, (char[])value);
            }
            if (type == Double.TYPE) {
                return JsonUrlWriter.write(dest, options, (double[])value);
            }
            if (type == Float.TYPE) {
                return JsonUrlWriter.write(dest, options, (float[])value);
            }
            if (type == Integer.TYPE) {
                return JsonUrlWriter.write(dest, options, (int[])value);
            }
            if (type == Long.TYPE) {
                return JsonUrlWriter.write(dest, options, (long[])value);
            }
            if (type == Short.TYPE) {
                return JsonUrlWriter.write(dest, options, (short[])value);
            }
            return JsonUrlWriter.write(dest, options, (Object[])value);
        }
        throw new IOException("unsupported class: " + value.getClass());
    }

    public static <A, R> boolean write(JsonTextBuilder<R> dest, Map<?, ?> value) throws IOException {
        return JsonUrlWriter.write(dest, (Set<JsonUrlOption>)JsonUrlOptionable.getJsonUrlOptions(dest), value);
    }

    public static <A, R> boolean write(JsonTextBuilder<R> dest, Set<JsonUrlOption> options, Map<?, ?> value) throws IOException {
        if (JsonUrlWriter.isNull(value)) {
            if (JsonUrlOption.optionSkipNulls(options)) {
                return false;
            }
            dest.addNull();
            return true;
        }
        boolean ret = false;
        dest.beginObject();
        for (Map.Entry<?, ?> e : value.entrySet()) {
            Object key = e.getKey();
            if (!(key instanceof CharSequence)) {
                throw new IOException("object contains non-string key");
            }
            ret = JsonUrlWriter.write(dest, options, (CharSequence)key, e.getValue(), ret);
        }
        dest.endObject();
        return ret;
    }

    private static <A, R> boolean write(JsonTextBuilder<R> dest, Set<JsonUrlOption> options, CharSequence key, Object value, boolean comma) throws IOException {
        if (JsonUrlOption.optionSkipNulls(options) && JsonUrlWriter.isNull(value)) {
            return comma;
        }
        if (comma) {
            dest.valueSeparator();
        }
        dest.addKey(key).nameSeparator();
        JsonUrlWriter.write(dest, options, value);
        return true;
    }

    public static <A, R> boolean write(JsonTextBuilder<R> dest, Iterable<?> value) throws IOException {
        return JsonUrlWriter.write(dest, (Set<JsonUrlOption>)JsonUrlOptionable.getJsonUrlOptions(dest), value);
    }

    public static <A, R> boolean write(JsonTextBuilder<R> dest, Set<JsonUrlOption> options, Iterable<?> value) throws IOException {
        if (JsonUrlWriter.isNull(value)) {
            if (JsonUrlOption.optionSkipNulls(options)) {
                return false;
            }
            return JsonUrlWriter.writeNull(dest, options);
        }
        boolean ret = false;
        dest.beginArray();
        for (Object obj : value) {
            ret = JsonUrlWriter.write(dest, options, obj, ret);
        }
        dest.endArray();
        return ret;
    }

    private static <A, R> boolean write(JsonTextBuilder<R> dest, Set<JsonUrlOption> options, Object value, boolean comma) throws IOException {
        if (JsonUrlOption.optionSkipNulls(options) && JsonUrlWriter.isNull(value)) {
            return comma;
        }
        if (comma) {
            dest.valueSeparator();
        }
        JsonUrlWriter.write(dest, options, value);
        return true;
    }

    public static <A, R> boolean write(JsonTextBuilder<R> dest, Set<JsonUrlOption> options, boolean ... array) throws IOException {
        if (JsonUrlWriter.isNull(array)) {
            return JsonUrlWriter.writeNull(dest, options);
        }
        dest.beginArray();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                dest.valueSeparator();
            }
            dest.add(array[i]);
        }
        dest.endArray();
        return true;
    }

    public static <A, R> boolean write(JsonTextBuilder<R> dest, Set<JsonUrlOption> options, byte ... array) throws IOException {
        if (JsonUrlWriter.isNull(array)) {
            return JsonUrlWriter.writeNull(dest, options);
        }
        dest.beginArray();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                dest.valueSeparator();
            }
            dest.add((long)array[i]);
        }
        dest.endArray();
        return true;
    }

    public static <A, R> boolean write(JsonTextBuilder<R> dest, Set<JsonUrlOption> options, char ... array) throws IOException {
        if (JsonUrlWriter.isNull(array)) {
            return JsonUrlWriter.writeNull(dest, options);
        }
        dest.beginArray();
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            int codePoint;
            int chr;
            if (i > 0) {
                dest.valueSeparator();
            }
            if (Character.isLowSurrogate((char)(chr = array[i]))) {
                throw new MalformedInputException(i);
            }
            if (Character.isHighSurrogate((char)chr)) {
                if (++i == length) {
                    throw new MalformedInputException(i);
                }
                char low = array[i];
                if (Character.isHighSurrogate(low)) {
                    throw new MalformedInputException(i);
                }
                codePoint = Character.toCodePoint((char)chr, low);
            } else {
                codePoint = chr;
            }
            dest.addCodePoint(codePoint);
        }
        dest.endArray();
        return true;
    }

    public static <A, R> boolean write(JsonTextBuilder<R> dest, Set<JsonUrlOption> options, double ... array) throws IOException {
        if (JsonUrlWriter.isNull(array)) {
            return JsonUrlWriter.writeNull(dest, options);
        }
        dest.beginArray();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                dest.valueSeparator();
            }
            dest.add(array[i]);
        }
        dest.endArray();
        return true;
    }

    public static <A, R> boolean write(JsonTextBuilder<R> dest, Set<JsonUrlOption> options, float ... array) throws IOException {
        if (JsonUrlWriter.isNull(array)) {
            return JsonUrlWriter.writeNull(dest, options);
        }
        dest.beginArray();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                dest.valueSeparator();
            }
            dest.add((double)array[i]);
        }
        dest.endArray();
        return true;
    }

    public static <A, R> boolean write(JsonTextBuilder<R> dest, Set<JsonUrlOption> options, int ... array) throws IOException {
        if (JsonUrlWriter.isNull(array)) {
            return JsonUrlWriter.writeNull(dest, options);
        }
        dest.beginArray();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                dest.valueSeparator();
            }
            dest.add((long)array[i]);
        }
        dest.endArray();
        return true;
    }

    public static <A, R> boolean write(JsonTextBuilder<R> dest, Set<JsonUrlOption> options, long ... array) throws IOException {
        if (JsonUrlWriter.isNull(array)) {
            return JsonUrlWriter.writeNull(dest, options);
        }
        dest.beginArray();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                dest.valueSeparator();
            }
            dest.add(array[i]);
        }
        dest.endArray();
        return true;
    }

    public static <A, R> boolean write(JsonTextBuilder<R> dest, Set<JsonUrlOption> options, short ... array) throws IOException {
        if (JsonUrlWriter.isNull(array)) {
            return JsonUrlWriter.writeNull(dest, options);
        }
        dest.beginArray();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                dest.valueSeparator();
            }
            dest.add((long)array[i]);
        }
        dest.endArray();
        return true;
    }

    public static <A, R> boolean write(JsonTextBuilder<R> dest, Object ... array) throws IOException {
        return JsonUrlWriter.write(dest, (Set<JsonUrlOption>)JsonUrlOptionable.getJsonUrlOptions(dest), array);
    }

    public static <A, R> boolean write(JsonTextBuilder<R> dest, Set<JsonUrlOption> options, Object ... array) throws IOException {
        if (JsonUrlWriter.isNull(array)) {
            if (JsonUrlOption.optionSkipNulls(options)) {
                return false;
            }
            return JsonUrlWriter.writeNull(dest, options);
        }
        dest.beginArray();
        boolean ret = false;
        for (int i = 0; i < array.length; ++i) {
            ret = JsonUrlWriter.write(dest, options, array[i], ret);
        }
        dest.endArray();
        return ret;
    }

    private static <A, R> boolean writeNull(JsonTextBuilder<R> dest, Set<JsonUrlOption> options) throws IOException {
        dest.addNull();
        return !JsonUrlOption.optionCoerceNullToEmptyString(options) || !JsonUrlOption.optionEmptyUnquotedValue(options);
    }
}

