/*
 * Decompiled with CFR 0.152.
 */
package org.jsonurl.jsonorg;

import java.math.MathContext;
import org.json.JSONArray;
import org.json.JSONObject;
import org.jsonurl.BigMath;
import org.jsonurl.BigMathProvider;
import org.jsonurl.factory.ValueFactory;
import org.jsonurl.j2se.JavaValueFactory;
import org.jsonurl.text.NumberBuilder;
import org.jsonurl.text.NumberText;

public interface JsonOrgValueFactory
extends ValueFactory.TransparentBuilder<Object, Object, JSONArray, JSONObject, Boolean, Number, Object, String> {
    public static final Object EMPTY = new JSONObject();
    public static final BigMathFactory BIGMATH32 = new BigMathFactory(MathContext.DECIMAL32, BigMath.BIG_INTEGER32_BOUNDARY_NEG, BigMath.BIG_INTEGER32_BOUNDARY_POS, null);
    public static final BigMathFactory BIGMATH64 = new BigMathFactory(MathContext.DECIMAL64, BigMath.BIG_INTEGER64_BOUNDARY_NEG, BigMath.BIG_INTEGER64_BOUNDARY_POS, null);
    public static final BigMathFactory BIGMATH128 = new BigMathFactory(MathContext.DECIMAL128, "170141183460469231731687303715884105728", "170141183460469231731687303715884105727", null);
    public static final JsonOrgValueFactory PRIMITIVE = new JsonOrgValueFactory(){

        public Number getNumber(NumberText text) {
            return NumberBuilder.build((NumberText)text, (boolean)true);
        }
    };
    public static final JsonOrgValueFactory DOUBLE = new JsonOrgValueFactory(){

        public Number getNumber(NumberText text) {
            return Double.valueOf(text.toString());
        }
    };

    default public JSONArray newArrayBuilder() {
        return new JSONArray();
    }

    default public JSONObject newObjectBuilder() {
        return new JSONObject();
    }

    default public void add(JSONArray dest, Object obj) {
        dest.put(obj);
    }

    default public void put(JSONObject dest, String key, Object value) {
        dest.put(key, value);
    }

    default public Object getEmptyComposite() {
        return EMPTY;
    }

    default public Object getNull() {
        return JSONObject.NULL;
    }

    default public Boolean getTrue() {
        return Boolean.TRUE;
    }

    default public Boolean getFalse() {
        return Boolean.FALSE;
    }

    default public String getString(CharSequence text, int start, int stop) {
        return JavaValueFactory.toJavaString((CharSequence)text, (int)start, (int)stop);
    }

    public static class BigMathFactory
    extends BigMath
    implements JsonOrgValueFactory,
    ValueFactory.BigMathFactory<Object, Object, JSONArray, JSONArray, JSONObject, JSONObject, Boolean, Number, Object, String> {
        public BigMathFactory(MathContext mctxt, String bigIntegerBoundaryNeg, String bigIntegerBoundaryPos, BigMathProvider.BigIntegerOverflow bigIntegerOverflow) {
            super(mctxt, bigIntegerBoundaryNeg, bigIntegerBoundaryPos, bigIntegerOverflow);
        }

        public Number getNumber(NumberText text) {
            return NumberBuilder.build((NumberText)text, (boolean)false, (BigMathProvider)this);
        }
    }
}

