/*
 * Decompiled with CFR 0.152.
 */
package org.jsonurl.jsonorg;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONString;
import org.jsonurl.JsonUrlOption;
import org.jsonurl.JsonUrlOptionable;
import org.jsonurl.text.JsonTextBuilder;

public final class JsonUrlWriter {
    private JsonUrlWriter() {
    }

    private static boolean isNull(Object obj) {
        return obj == null || obj == JSONObject.NULL;
    }

    public static <R> boolean write(JsonTextBuilder<R> dest, Object value) throws IOException {
        return JsonUrlWriter.write(dest, (Set<JsonUrlOption>)JsonUrlOptionable.getJsonUrlOptions(dest), value);
    }

    public static <R> boolean write(JsonTextBuilder<R> dest, Set<JsonUrlOption> options, Object value) throws IOException {
        if (JsonUrlWriter.isNull(value)) {
            if (JsonUrlOption.optionSkipNulls(options)) {
                return false;
            }
            return JsonUrlWriter.writeNull(dest, options);
        }
        if (value instanceof JSONString) {
            String str = ((JSONString)value).toJSONString();
            if (JsonUrlWriter.isNull(str)) {
                if (JsonUrlOption.optionSkipNulls(options)) {
                    return false;
                }
                return JsonUrlWriter.writeNull(dest, options);
            }
            dest.add((CharSequence)str);
            return true;
        }
        if (value instanceof JSONObject) {
            return JsonUrlWriter.write(dest, options, (JSONObject)value);
        }
        if (value instanceof JSONArray) {
            return JsonUrlWriter.write(dest, options, (JSONArray)value);
        }
        return org.jsonurl.j2se.JsonUrlWriter.write(dest, options, (Object)value);
    }

    public static <R> boolean write(JsonTextBuilder<R> dest, JSONObject obj) throws IOException {
        return JsonUrlWriter.write(dest, (Set<JsonUrlOption>)JsonUrlOptionable.getJsonUrlOptions(dest), obj);
    }

    public static <R> boolean write(JsonTextBuilder<R> dest, Set<JsonUrlOption> options, JSONObject obj) throws IOException {
        if (JsonUrlWriter.isNull(obj)) {
            if (JsonUrlOption.optionSkipNulls(options)) {
                return false;
            }
            return JsonUrlWriter.writeNull(dest, options);
        }
        boolean ret = false;
        dest.beginObject();
        Iterator it = obj.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            ret = JsonUrlWriter.write(dest, options, key, obj.get(key), ret);
        }
        dest.endObject();
        return ret;
    }

    public static <R> boolean write(JsonTextBuilder<R> dest, JSONArray value) throws IOException {
        return JsonUrlWriter.write(dest, (Set<JsonUrlOption>)JsonUrlOptionable.getJsonUrlOptions(dest), value);
    }

    public static <R> boolean write(JsonTextBuilder<R> dest, Set<JsonUrlOption> options, JSONArray value) throws IOException {
        if (JsonUrlWriter.isNull(value)) {
            if (JsonUrlOption.optionSkipNulls(options)) {
                return false;
            }
            return JsonUrlWriter.writeNull(dest, options);
        }
        boolean ret = false;
        dest.beginArray();
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            ret = JsonUrlWriter.write(dest, options, value.get(i), ret);
        }
        dest.endArray();
        return ret;
    }

    private static <R> boolean write(JsonTextBuilder<R> dest, Set<JsonUrlOption> options, Object value, boolean comma) throws IOException {
        if (JsonUrlOption.optionSkipNulls(options) && JsonUrlWriter.isNull(value)) {
            return comma;
        }
        if (comma) {
            dest.valueSeparator();
        }
        JsonUrlWriter.write(dest, options, value);
        return true;
    }

    private static <R> boolean write(JsonTextBuilder<R> dest, Set<JsonUrlOption> options, String key, Object value, boolean comma) throws IOException {
        if (JsonUrlOption.optionSkipNulls(options) && JsonUrlWriter.isNull(value)) {
            return comma;
        }
        if (comma) {
            dest.valueSeparator();
        }
        dest.addKey((CharSequence)key).nameSeparator();
        JsonUrlWriter.write(dest, options, value);
        return true;
    }

    private static <R> boolean writeNull(JsonTextBuilder<R> dest, Set<JsonUrlOption> options) throws IOException {
        dest.addNull();
        return !JsonUrlOption.optionCoerceNullToEmptyString(options) || !JsonUrlOption.optionEmptyUnquotedValue(options);
    }
}

