/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.unit.ext.junit;

import org.jspare.core.Environment;
import org.jspare.unit.mock.MockerUtils;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.statements.Fail;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.junit.runners.model.Statement;

public class JspareUnitRunner
extends BlockJUnit4ClassRunner {
    private final Class<?> testClass;

    public JspareUnitRunner(Class<?> testClass, RunnerBuilder builder) throws InitializationError {
        super(testClass);
        this.testClass = testClass;
        this.prepare();
    }

    private void prepare() {
        Environment.create();
        MockerUtils.initialize(this.testClass);
    }

    protected Statement methodBlock(FrameworkMethod frameworkMethod) {
        Object testInstance;
        try {
            testInstance = new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return JspareUnitRunner.this.createTest();
                }
            }.run();
        }
        catch (Throwable ex) {
            return new Fail(ex);
        }
        Environment.inject((Object)testInstance);
        Statement statement = this.methodInvoker(frameworkMethod, testInstance);
        statement = this.possiblyExpectingExceptions(frameworkMethod, testInstance, statement);
        statement = this.withBefores(frameworkMethod, testInstance, statement);
        statement = this.withAfters(frameworkMethod, testInstance, statement);
        statement = this.withPotentialTimeout(frameworkMethod, testInstance, statement);
        return statement;
    }
}

