/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.unit.mock;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jspare.unit.mock.Mocked;

public final class Mocker {
    private static final Map<Class<?>, Map<String, Object>> MOCKED = new HashMap();

    public static void clearReturns() {
        MOCKED.values().forEach(Map::clear);
    }

    public static void whenReturn(Object mocked, String methodName, Object result) {
        ((Mocked)mocked).fixReturn(methodName, result);
    }

    public static void whenReturn(Object mocked, String methodName, Function<Object[], Object> result) {
        ((Mocked)mocked).fixReturnSupplied(methodName, result);
    }

    public static <T> T createProxy(final Class<T> interfaceClass) {
        MOCKED.put(interfaceClass, new HashMap());
        return (T)Proxy.newProxyInstance(Mocker.class.getClassLoader(), new Class[]{interfaceClass, Mocked.class}, new InvocationHandler(){
            private Class<T> clazz;
            {
                this.clazz = interfaceClass;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (Arrays.asList("fixReturn", "fixReturnSupplied").contains(method.getName())) {
                    ((Map)MOCKED.get(this.clazz)).put((String)args[0], args[1]);
                    return null;
                }
                Object result = null;
                if (((Map)MOCKED.get(this.clazz)).containsKey(method.getName()) && (result = ((Map)MOCKED.get(this.clazz)).get(method.getName())) instanceof Function) {
                    result = ((Function)result).apply(args);
                }
                return result;
            }
        });
    }
}

