/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.unit.mock;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jspare.core.Environment;
import org.jspare.core.internal.Bind;

public final class Mocks {
    private static final Map<Class<?>, Object> MOCKS = new HashMap();

    public static void registry(Class<?> clazz, Object instance) {
        MOCKS.put(clazz, instance);
        Environment.registry((Bind)Bind.bind(clazz), (Object)instance);
    }

    public static <T> T injectMocks(Class<T> clazz) {
        if (!MOCKS.containsKey(clazz)) {
            Object instance = Environment.my(clazz);
            Arrays.asList(instance.getClass().getDeclaredFields()).stream().forEach(f -> Mocks.accept(f, instance));
            return (T)instance;
        }
        return (T)MOCKS.get(clazz);
    }

    private static void accept(Field field, Object instance) {
        if (MOCKS.containsKey(field.getType())) {
            field.setAccessible(true);
            field.set(instance, MOCKS.get(field.getType()));
        }
    }

    private Mocks() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

