/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.ext.jackson.datatype;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.jspare.vertx.ext.jackson.datatype.JsonNull;
import org.jspare.vertx.ext.jackson.datatype.JsonObjectBuilder;

public class JsonArrayBuilder {
    private final List<Object> values = new ArrayList<Object>();

    private JsonArrayBuilder() {
    }

    public JsonArrayBuilder add(JsonObject jsonObject) {
        this.values.add(jsonObject);
        return this;
    }

    public JsonArrayBuilder add(JsonObjectBuilder builder) {
        if (builder != null) {
            return this.add(builder.build());
        }
        return this.add((JsonObject)null);
    }

    public JsonArrayBuilder add(JsonArray jsonArray) {
        this.values.add(jsonArray);
        return this;
    }

    public JsonArrayBuilder add(JsonArrayBuilder builder) {
        if (builder != null) {
            return this.add(builder.build());
        }
        return this.add((JsonArray)null);
    }

    public JsonArrayBuilder add(String string) {
        this.values.add(string);
        return this;
    }

    public JsonArrayBuilder add(Number number) {
        this.values.add(number);
        return this;
    }

    public JsonArrayBuilder add(Boolean bool) {
        this.values.add(bool);
        return this;
    }

    public JsonArrayBuilder add(byte[] bytes) {
        this.values.add(bytes);
        return this;
    }

    public JsonArrayBuilder addNull() {
        this.values.add(new JsonNull());
        return this;
    }

    public JsonArray build() {
        JsonArray array = new JsonArray();
        for (Object value : this.values) {
            if (value instanceof JsonNull) {
                array.addNull();
                continue;
            }
            array.add(value);
        }
        return array;
    }

    public String encode() {
        return this.build().encode();
    }

    public static JsonArrayBuilder array() {
        return new JsonArrayBuilder();
    }
}

