/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.ext.jackson.datatype;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.vertx.core.json.JsonArray;
import java.io.IOException;
import org.jspare.vertx.ext.jackson.datatype.JsonArrayBuilder;
import org.jspare.vertx.ext.jackson.datatype.JsonObjectDeserializer;

class JsonArrayDeserializer
extends StdDeserializer<JsonArray> {
    private static final long serialVersionUID = 8754393549090720144L;
    public static final JsonArrayDeserializer INSTANCE = new JsonArrayDeserializer();

    JsonArrayDeserializer() {
        super(JsonArray.class);
    }

    public JsonArray deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        JsonToken t;
        JsonArrayBuilder builder = JsonArrayBuilder.array();
        block10: while ((t = jp.nextToken()) != JsonToken.END_ARRAY) {
            switch (t) {
                case START_ARRAY: {
                    builder.add(this.deserialize(jp, ctx));
                    continue block10;
                }
                case START_OBJECT: {
                    builder.add(JsonObjectDeserializer.INSTANCE.deserialize(jp, ctx));
                    continue block10;
                }
                case VALUE_STRING: {
                    builder.add(jp.getText());
                    continue block10;
                }
                case VALUE_NULL: {
                    builder.addNull();
                    continue block10;
                }
                case VALUE_TRUE: {
                    builder.add(Boolean.TRUE);
                    continue block10;
                }
                case VALUE_FALSE: {
                    builder.add(Boolean.FALSE);
                    continue block10;
                }
                case VALUE_NUMBER_INT: {
                    builder.add(jp.getNumberValue());
                    continue block10;
                }
                case VALUE_NUMBER_FLOAT: {
                    builder.add(jp.getNumberValue());
                    continue block10;
                }
            }
            throw ctx.mappingException("Unrecognized or unsupported JsonToken type: " + t);
        }
        return builder.build();
    }
}

