/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.ext.jackson.datatype;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import org.jspare.vertx.ext.jackson.datatype.JsonBaseSerializer;
import org.jspare.vertx.ext.jackson.datatype.JsonObjectSerializer;

class JsonArraySerializer
extends JsonBaseSerializer<JsonArray> {
    public static final JsonArraySerializer INSTANCE = new JsonArraySerializer();

    JsonArraySerializer() {
        super(JsonArray.class);
    }

    public void serialize(JsonArray value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartArray();
        this.serializeContents(value, jgen, provider);
        jgen.writeEndArray();
    }

    public void serializeWithType(JsonArray value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForArray((Object)value, jgen);
        this.serializeContents(value, jgen, provider);
        typeSer.writeTypeSuffixForArray((Object)value, jgen);
    }

    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("array", true);
    }

    protected void serializeContents(JsonArray array, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        List value = array.getList();
        int len = value.size();
        for (int i = 0; i < len; ++i) {
            Object ob = value.get(i);
            if (ob == null) {
                jgen.writeNull();
                continue;
            }
            Class<?> cls = ob.getClass();
            if (cls == JsonObject.class) {
                JsonObjectSerializer.INSTANCE.serialize((JsonObject)ob, jgen, provider);
                continue;
            }
            if (cls == JsonArray.class) {
                this.serialize((JsonArray)ob, jgen, provider);
                continue;
            }
            if (cls == String.class) {
                jgen.writeString((String)ob);
                continue;
            }
            if (cls == Integer.class) {
                jgen.writeNumber(((Integer)ob).intValue());
                continue;
            }
            if (cls == Long.class) {
                jgen.writeNumber(((Long)ob).longValue());
                continue;
            }
            if (cls == Boolean.class) {
                jgen.writeBoolean(((Boolean)ob).booleanValue());
                continue;
            }
            if (cls == Double.class) {
                jgen.writeNumber(((Double)ob).doubleValue());
                continue;
            }
            if (JsonObject.class.isAssignableFrom(cls)) {
                JsonObjectSerializer.INSTANCE.serialize((JsonObject)ob, jgen, provider);
                continue;
            }
            if (JsonArray.class.isAssignableFrom(cls)) {
                this.serialize((JsonArray)ob, jgen, provider);
                continue;
            }
            if (JsonArray.class.isAssignableFrom(cls)) {
                INSTANCE.serialize((JsonArray)ob, jgen, provider);
                continue;
            }
            provider.defaultSerializeValue(ob, jgen);
        }
    }
}

