/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.ext.jackson.datatype;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspare.vertx.ext.jackson.datatype.JsonArrayBuilder;

public class JsonObjectBuilder {
    private final Map<String, Object> values = new LinkedHashMap<String, Object>();

    private JsonObjectBuilder() {
    }

    public JsonObjectBuilder put(String name, JsonObject object) {
        this.values.put(name, object);
        return this;
    }

    public JsonObjectBuilder put(String name, JsonObjectBuilder builder) {
        if (builder != null) {
            return this.put(name, builder.build());
        }
        return this.put(name, (JsonObject)null);
    }

    public JsonObjectBuilder put(String name, JsonArray array) {
        this.values.put(name, array);
        return this;
    }

    public JsonObjectBuilder put(String name, JsonArrayBuilder builder) {
        if (builder != null) {
            return this.put(name, builder.build());
        }
        return this.put(name, (JsonArray)null);
    }

    public JsonObjectBuilder put(String name, String string) {
        this.values.put(name, string);
        return this;
    }

    public JsonObjectBuilder put(String name, Number number) {
        this.values.put(name, number);
        return this;
    }

    public JsonObjectBuilder put(String name, Boolean bool) {
        this.values.put(name, bool);
        return this;
    }

    public JsonObjectBuilder put(String name, byte[] bytes) {
        this.values.put(name, bytes);
        return this;
    }

    public JsonObjectBuilder putNull(String name) {
        this.values.put(name, null);
        return this;
    }

    public JsonObject build() {
        JsonObject object = new JsonObject();
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            object.put(entry.getKey(), entry.getValue());
        }
        return object;
    }

    public String encode() {
        return this.build().encode();
    }

    public static JsonObjectBuilder object() {
        return new JsonObjectBuilder();
    }
}

