/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.ext.jackson.datatype;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import org.jspare.vertx.ext.jackson.datatype.JsonArrayDeserializer;
import org.jspare.vertx.ext.jackson.datatype.JsonObjectBuilder;

class JsonObjectDeserializer
extends StdDeserializer<JsonObject> {
    private static final long serialVersionUID = 4883042507402315060L;
    public static final JsonObjectDeserializer INSTANCE = new JsonObjectDeserializer();

    JsonObjectDeserializer() {
        super(JsonObject.class);
    }

    public JsonObject deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonObjectBuilder builder = JsonObjectBuilder.object();
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = jp.nextToken();
        }
        while (t == JsonToken.FIELD_NAME) {
            String fieldName = jp.getCurrentName();
            t = jp.nextToken();
            switch (t) {
                case START_ARRAY: {
                    builder.put(fieldName, JsonArrayDeserializer.INSTANCE.deserialize(jp, ctxt));
                    break;
                }
                case START_OBJECT: {
                    builder.put(fieldName, this.deserialize(jp, ctxt));
                    break;
                }
                case VALUE_STRING: {
                    builder.put(fieldName, jp.getText());
                    break;
                }
                case VALUE_NULL: {
                    builder.putNull(fieldName);
                    break;
                }
                case VALUE_TRUE: {
                    builder.put(fieldName, Boolean.TRUE);
                    break;
                }
                case VALUE_FALSE: {
                    builder.put(fieldName, Boolean.FALSE);
                    break;
                }
                case VALUE_NUMBER_INT: {
                    builder.put(fieldName, jp.getNumberValue());
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    builder.put(fieldName, jp.getNumberValue());
                    break;
                }
                default: {
                    throw ctxt.mappingException("Unrecognized or unsupported JsonToken type: " + t);
                }
            }
            t = jp.nextToken();
        }
        return builder.build();
    }
}

