/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.ext.jackson.datatype;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.lang.reflect.Type;
import org.jspare.vertx.ext.jackson.datatype.JsonArraySerializer;
import org.jspare.vertx.ext.jackson.datatype.JsonBaseSerializer;

class JsonObjectSerializer
extends JsonBaseSerializer<JsonObject> {
    public static final JsonObjectSerializer INSTANCE = new JsonObjectSerializer();

    JsonObjectSerializer() {
        super(JsonObject.class);
    }

    public void serialize(JsonObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        this.serializeContents(value, jgen, provider);
        jgen.writeEndObject();
    }

    public void serializeWithType(JsonObject value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)value, jgen);
        this.serializeContents(value, jgen, provider);
        typeSer.writeTypeSuffixForObject((Object)value, jgen);
    }

    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("object", true);
    }

    protected void serializeContents(JsonObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        for (String key : value.fieldNames()) {
            Object ob = value.getValue(key);
            if (ob == null) {
                if (!provider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES)) continue;
                jgen.writeNullField(key);
                continue;
            }
            jgen.writeFieldName(key);
            Class<?> cls = ob.getClass();
            if (cls == JsonObject.class) {
                this.serialize((JsonObject)ob, jgen, provider);
                continue;
            }
            if (cls == JsonArray.class) {
                JsonArraySerializer.INSTANCE.serialize((JsonArray)ob, jgen, provider);
                continue;
            }
            if (cls == String.class) {
                jgen.writeString((String)ob);
                continue;
            }
            if (cls == Integer.class) {
                jgen.writeNumber(((Integer)ob).intValue());
                continue;
            }
            if (cls == Long.class) {
                jgen.writeNumber(((Long)ob).longValue());
                continue;
            }
            if (cls == Boolean.class) {
                jgen.writeBoolean(((Boolean)ob).booleanValue());
                continue;
            }
            if (cls == Double.class) {
                jgen.writeNumber(((Double)ob).doubleValue());
                continue;
            }
            if (cls == JsonArray.class) {
                JsonArraySerializer.INSTANCE.serialize((JsonArray)ob, jgen, provider);
                continue;
            }
            if (JsonObject.class.isAssignableFrom(cls)) {
                this.serialize((JsonObject)ob, jgen, provider);
                continue;
            }
            if (JsonArray.class.isAssignableFrom(cls)) {
                JsonArraySerializer.INSTANCE.serialize((JsonArray)ob, jgen, provider);
                continue;
            }
            provider.defaultSerializeValue(ob, jgen);
        }
    }
}

