/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.ext.jackson.datatype;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import org.jspare.vertx.ext.jackson.datatype.JsonArrayBuilder;
import org.jspare.vertx.ext.jackson.datatype.JsonObjectBuilder;
import org.jspare.vertx.ext.jackson.datatype.generator.JsonElementGenerator;
import org.jspare.vertx.ext.jackson.datatype.parser.JsonElementParser;

public class ObjectMarshaller {
    private final ObjectMapper om;

    public ObjectMapper objectMapper() {
        return this.om;
    }

    public ObjectMarshaller(ObjectMapper objectMapper) {
        if (objectMapper == null) {
            throw new IllegalArgumentException("objectMapper must not be null");
        }
        this.om = objectMapper;
    }

    public <T> T unmarshall(JsonObject jsonObject, Class<T> type) throws IOException {
        return (T)this.om.readValue((JsonParser)new JsonElementParser(jsonObject), type);
    }

    public <T> T unmarshall(JsonArray jsonArray, Class<T> type) throws IOException {
        return (T)this.om.readValue((JsonParser)new JsonElementParser(jsonArray), type);
    }

    public <T> T unmarshall(JsonObject jsonObject, TypeReference<T> type) throws IOException {
        return (T)this.om.readValue((JsonParser)new JsonElementParser(jsonObject), type);
    }

    public <T> T unmarshall(JsonArray jsonObject, TypeReference<T> type) throws IOException {
        return (T)this.om.readValue((JsonParser)new JsonElementParser(jsonObject), type);
    }

    public <T> T unmarshall(JsonObject jsonObject, JavaType type) throws IOException {
        return (T)this.om.readValue((JsonParser)new JsonElementParser(jsonObject), type);
    }

    public <T> T unmarshall(JsonArray jsonArray, JavaType type) throws IOException {
        return (T)this.om.readValue((JsonParser)new JsonElementParser(jsonArray), type);
    }

    public <T> T unmarshall(JsonObjectBuilder builder, Class<T> type) throws IOException {
        return this.unmarshall(builder.build(), type);
    }

    public <T> T unmarshall(JsonObjectBuilder builder, TypeReference<T> type) throws IOException {
        return this.unmarshall(builder.build(), type);
    }

    public <T> T unmarshall(JsonObjectBuilder builder, JavaType type) throws IOException {
        return this.unmarshall(builder.build(), type);
    }

    public <T> T unmarshall(JsonArrayBuilder builder, Class<T> type) throws IOException {
        return this.unmarshall(builder.build(), type);
    }

    public <T> T unmarshall(JsonArrayBuilder builder, TypeReference<T> type) throws IOException {
        return this.unmarshall(builder.build(), type);
    }

    public <T> T unmarshall(JsonArrayBuilder builder, JavaType type) throws IOException {
        return this.unmarshall(builder.build(), type);
    }

    public <T extends JsonObject> T marshall(Object instance) throws IOException {
        JsonElementGenerator jgen = new JsonElementGenerator(0, (ObjectCodec)this.om);
        this.om.writeValue((JsonGenerator)jgen, instance);
        return (T)((JsonObject)jgen.get());
    }
}

