/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.ext.jackson.datatype.generator;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.base.GeneratorBase;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;

public class JsonElementGenerator
extends GeneratorBase {
    private State state = State.Empty;
    private Object rootElement = null;
    private final Deque<Object> elementStack = new LinkedList<Object>();
    private final Deque<State> stateStack = new LinkedList<State>();
    private String fieldName = null;

    public JsonElementGenerator(int features, ObjectCodec codec) {
        super(features, codec);
        this.stateStack.push(State.Empty);
    }

    private JsonObject push(JsonObject object) {
        if (this.rootElement == null) {
            this.rootElement = object;
        }
        this.fieldName = null;
        this.state = State.Object;
        this.stateStack.push(State.Object);
        this.elementStack.push(object);
        return object;
    }

    private JsonArray push(JsonArray array) {
        if (this.rootElement == null) {
            this.rootElement = array;
        }
        this.fieldName = null;
        this.state = State.Array;
        this.stateStack.push(State.Array);
        this.elementStack.push(array);
        return array;
    }

    private Object pop() {
        this.fieldName = null;
        this.stateStack.pop();
        this.state = this.stateStack.peek();
        return this.elementStack.pop();
    }

    private <T> T peek() {
        return (T)this.elementStack.peek();
    }

    public <T> T get() {
        if (this.state != State.Empty) {
            throw new IllegalStateException("can not retrieve generated <JsonElement>, generation has not yet finished");
        }
        return (T)this.rootElement;
    }

    public void writeStartArray() throws IOException {
        switch (this.state) {
            case Empty: {
                this.push(new JsonArray());
                break;
            }
            case Object: {
                throw this.err("can not write start array as object property unless a field name has been set", new Object[0]);
            }
            case Array: {
                JsonArray array = (JsonArray)this.peek();
                array.add(this.push(new JsonArray()));
                break;
            }
            case Field: {
                JsonObject object = (JsonObject)this.peek();
                object.put(this.encodeIfNecessary(this.fieldName), this.push(new JsonArray()));
                this.fieldName = null;
                break;
            }
            default: {
                throw this.err("can not write start array, unknown state <{0}>", new Object[]{this.state});
            }
        }
    }

    public void writeEndArray() throws IOException {
        switch (this.state) {
            case Array: {
                this.pop();
                break;
            }
            default: {
                throw this.err("can not write end array in state <{0}>", new Object[]{this.state});
            }
        }
    }

    public void writeStartObject() throws IOException {
        switch (this.state) {
            case Empty: {
                this.push(new JsonObject());
                break;
            }
            case Object: {
                throw this.err("can not write start object as object property unless a field name has been set", new Object[0]);
            }
            case Array: {
                JsonArray array = (JsonArray)this.peek();
                array.add(this.push(new JsonObject()));
                break;
            }
            case Field: {
                JsonObject object = (JsonObject)this.peek();
                object.put(this.encodeIfNecessary(this.fieldName), this.push(new JsonObject()));
                this.fieldName = null;
                break;
            }
            default: {
                throw this.err("can not write start object, unknown state <{0}>", new Object[]{this.state});
            }
        }
    }

    public void writeEndObject() throws IOException {
        switch (this.state) {
            case Object: {
                this.pop();
                break;
            }
            default: {
                throw this.err("can not write end object in state <{0}>", new Object[]{this.state});
            }
        }
    }

    private String encodeIfNecessary(String value) {
        if (this.isEnabled(JsonGenerator.Feature.ESCAPE_NON_ASCII)) {
            CharsetEncoder encoder = Charset.forName("US-ASCII").newEncoder();
            StringBuilder encoded = new StringBuilder();
            for (char c : value.toCharArray()) {
                if (encoder.canEncode(c)) {
                    encoded.append(c);
                    continue;
                }
                encoded.append("\\u");
                encoded.append(Integer.toHexString(0x10000 | c).substring(1).toUpperCase());
            }
            return encoded.toString();
        }
        return value;
    }

    public void writeFieldName(String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        switch (this.state) {
            case Object: {
                this.fieldName = name;
                this.state = State.Field;
                break;
            }
            default: {
                throw this.err("can not write field name in state <{0}>", new Object[]{this.state});
            }
        }
    }

    public void writeString(String text) throws IOException {
        switch (this.state) {
            case Array: {
                JsonArray array = (JsonArray)this.peek();
                array.add(this.encodeIfNecessary(text));
                break;
            }
            case Field: {
                JsonObject object = (JsonObject)this.peek();
                object.put(this.encodeIfNecessary(this.fieldName), this.encodeIfNecessary(text));
                this.fieldName = null;
                this.state = State.Object;
                break;
            }
            default: {
                throw this.err("can not write <String> in state <{0}>", new Object[]{this.state});
            }
        }
    }

    public void writeString(char[] text, int offset, int len) throws IOException {
        this.writeString(new String(text, offset, len));
    }

    public void writeRawUTF8String(byte[] text, int offset, int length) throws IOException {
        throw new UnsupportedOperationException("writeRawUTF8String(byte[], int, int)");
    }

    public void writeUTF8String(byte[] text, int offset, int length) throws IOException {
        throw new UnsupportedOperationException("writeUTF8String(byte[], int, int)");
    }

    public void writeRaw(String text) throws IOException {
        throw new UnsupportedOperationException("writeRaw(String)");
    }

    public void writeRaw(String text, int offset, int len) throws IOException {
        throw new UnsupportedOperationException("writeRaw(String, int, int)");
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException {
        throw new UnsupportedOperationException("writeRaw(char[], int, int)");
    }

    public void writeRaw(char c) throws IOException {
        throw new UnsupportedOperationException("writeRaw(char)");
    }

    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException {
        if (offset == 0 && len == data.length) {
            this.writeString(b64variant.encode(data));
        } else {
            byte[] range = Arrays.copyOfRange(data, offset, offset + len);
            this.writeString(b64variant.encode(range));
        }
    }

    private void doWriteNumber(Number number) throws IOException {
        if (this._cfgNumbersAsStrings) {
            this.writeString(String.valueOf(number));
            return;
        }
        switch (this.state) {
            case Array: {
                JsonArray array = (JsonArray)this.peek();
                array.add((Object)number);
                break;
            }
            case Field: {
                JsonObject object = (JsonObject)this.peek();
                object.put(this.encodeIfNecessary(this.fieldName), (Object)number);
                this.fieldName = null;
                this.state = State.Object;
                break;
            }
            default: {
                throw this.err("can not write number in state <{0}>", new Object[]{this.state});
            }
        }
    }

    public void writeNumber(int number) throws IOException {
        this.doWriteNumber(number);
    }

    public void writeNumber(long number) throws IOException {
        this.doWriteNumber(number);
    }

    public void writeNumber(BigInteger number) throws IOException {
        this.doWriteNumber(number);
    }

    public void writeNumber(double number) throws IOException {
        if (this.isEnabled(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS) && this.mustQuote(number)) {
            this.writeString(Double.toString(number));
        } else {
            this.doWriteNumber(number);
        }
    }

    public void writeNumber(float number) throws IOException {
        if (this.isEnabled(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS) && this.mustQuote(number)) {
            this.writeString(Float.toString(number));
        } else {
            this.doWriteNumber(Float.valueOf(number));
        }
    }

    public void writeNumber(BigDecimal number) throws IOException {
        this.doWriteNumber(number);
    }

    public void writeNumber(String encodedValue) throws IOException {
        try {
            this.doWriteNumber(new BigDecimal(encodedValue));
        }
        catch (NumberFormatException e) {
            throw this.err(e, "can not write <{0}> as number", encodedValue);
        }
    }

    private boolean mustQuote(double number) {
        return Double.isNaN(number) || Double.isInfinite(number);
    }

    private boolean mustQuote(float number) {
        return Float.isNaN(number) || Float.isInfinite(number);
    }

    public void writeBoolean(boolean b) throws IOException {
        switch (this.state) {
            case Array: {
                JsonArray array = (JsonArray)this.peek();
                array.add(Boolean.valueOf(b));
                break;
            }
            case Field: {
                JsonObject object = (JsonObject)this.peek();
                object.put(this.encodeIfNecessary(this.fieldName), Boolean.valueOf(b));
                this.fieldName = null;
                this.state = State.Object;
                break;
            }
            default: {
                throw this.err("can not write boolean in state <{0}>", new Object[]{this.state});
            }
        }
    }

    public void writeNull() throws IOException {
        switch (this.state) {
            case Array: {
                JsonArray array = (JsonArray)this.peek();
                array.addNull();
                break;
            }
            case Field: {
                JsonObject object = (JsonObject)this.peek();
                object.put(this.encodeIfNecessary(this.fieldName), (String)null);
                this.fieldName = null;
                this.state = State.Object;
                break;
            }
            default: {
                throw this.err("can not write null in state <{0}>", new Object[]{this.state});
            }
        }
    }

    public void flush() throws IOException {
    }

    protected void _releaseBuffers() {
    }

    protected void _verifyValueWrite(String typeMsg) throws IOException {
        switch (this.state) {
            case Array: 
            case Field: {
                break;
            }
            default: {
                throw this.err(typeMsg, new Object[0]);
            }
        }
    }

    public void close() throws IOException {
        if (this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
            this.autoCloseJsonContent();
        }
        super.close();
    }

    private void autoCloseJsonContent() throws IOException {
        while (this.state != State.Empty) {
            switch (this.state) {
                case Object: {
                    this.writeEndObject();
                    break;
                }
                case Array: {
                    this.writeEndArray();
                    break;
                }
                case Field: {
                    this.fieldName = null;
                    this.state = State.Object;
                }
            }
        }
    }

    private JsonGenerationException err(String message, Object ... args) {
        String msg = message;
        if (args != null) {
            try {
                msg = MessageFormat.format(message, args);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return new JsonGenerationException(msg);
    }

    private JsonGenerationException err(Throwable cause, String message, Object ... args) {
        String msg = message;
        if (args != null) {
            try {
                msg = MessageFormat.format(message, args);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return new JsonGenerationException(msg, cause);
    }

    private static enum State {
        Empty,
        Object,
        Array,
        Field;

    }
}

