/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.ext.jackson.datatype.parser;

import com.fasterxml.jackson.core.JsonToken;
import java.util.Iterator;
import org.jspare.vertx.ext.jackson.datatype.parser.AbstractTreeCursor;
import org.jspare.vertx.ext.jackson.datatype.parser.SkippableIterator;

abstract class AbstractArrayCursor<A, E>
extends AbstractTreeCursor<E> {
    private final A array;
    private final SkippableIterator<E> elements;
    private JsonToken currentToken;
    private E currentElement;

    AbstractArrayCursor(A jsonArray, AbstractTreeCursor<E> parentCursor) {
        super(1, parentCursor);
        if (jsonArray == null) {
            throw new IllegalArgumentException("jsonArray must not be null");
        }
        this.array = jsonArray;
        this.elements = new SkippableIterator<E>(this.getElements(this.array));
        this._index = -1;
    }

    protected abstract Iterator<E> getElements(A var1);

    @Override
    public JsonToken nextToken() {
        if (this.elements.hasNext()) {
            this.currentElement = this.elements.next();
            this.currentToken = this.getToken(this.currentElement);
            ++this._index;
        } else {
            this.currentToken = null;
            this.currentElement = null;
        }
        this.currentName = String.valueOf(this._index);
        return this.currentToken;
    }

    @Override
    public JsonToken nextValue() {
        return this.nextToken();
    }

    @Override
    public void skipChildren() {
        this.elements.skip();
    }

    @Override
    public JsonToken endToken() {
        return JsonToken.END_ARRAY;
    }

    @Override
    public E currentElement() {
        return this.currentElement;
    }

    @Override
    public boolean currentHasChildren() {
        return this.getNumberOfChildren(this.currentElement) > 0;
    }

    @Override
    public AbstractTreeCursor<E> iterateChildren() {
        if (this.currentToken == JsonToken.START_OBJECT) {
            return this.newObjectCursor(this.currentElement);
        }
        if (this.currentToken == JsonToken.START_ARRAY) {
            return this.newArrayCursor(this.currentElement);
        }
        throw new IllegalStateException("can not iterate children at token <" + this.currentToken + ">");
    }

    public String toString() {
        return "array @ " + this.currentToken;
    }
}

