/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.ext.jackson.datatype.parser;

import com.fasterxml.jackson.core.JsonToken;
import java.util.Iterator;
import org.jspare.vertx.ext.jackson.datatype.parser.AbstractTreeCursor;
import org.jspare.vertx.ext.jackson.datatype.parser.SkippableIterator;

abstract class AbstractObjectCursor<T, E>
extends AbstractTreeCursor<E> {
    private final T object;
    private final SkippableIterator<String> fields;
    private JsonToken currentToken;
    private String currentFieldName;
    private E currentValue;

    AbstractObjectCursor(T jsonObject, AbstractTreeCursor<E> parentCursor) {
        super(2, parentCursor);
        if (jsonObject == null) {
            throw new IllegalArgumentException("jsonObject must not be null");
        }
        this.object = jsonObject;
        this.fields = new SkippableIterator<String>(this.getFields(this.object));
        this._index = -1;
    }

    protected abstract Iterator<String> getFields(T var1);

    protected abstract E getValue(String var1, T var2);

    @Override
    protected abstract int getNumberOfChildren(E var1);

    @Override
    public JsonToken nextToken() {
        if (this.currentToken == JsonToken.FIELD_NAME) {
            this.currentToken = this.getToken(this.currentValue);
        } else if (this.fields.hasNext()) {
            this.currentToken = JsonToken.FIELD_NAME;
            this.currentFieldName = this.fields.next();
            this.currentValue = this.getValue(this.currentFieldName, this.object);
            ++this._index;
        } else {
            this.currentToken = null;
            this.currentFieldName = null;
            this.currentValue = null;
        }
        this.currentName = this.currentFieldName;
        return this.currentToken;
    }

    @Override
    public JsonToken nextValue() {
        JsonToken t = this.nextToken();
        if (t == JsonToken.FIELD_NAME) {
            t = this.nextToken();
        }
        return t;
    }

    @Override
    public void skipChildren() {
        this.fields.skip();
    }

    @Override
    public JsonToken endToken() {
        return JsonToken.END_OBJECT;
    }

    @Override
    public E currentElement() {
        return this.currentValue;
    }

    @Override
    public boolean currentHasChildren() {
        return this.getNumberOfChildren(this.currentValue) > 0;
    }

    @Override
    public AbstractTreeCursor<E> iterateChildren() {
        if (this.currentToken == JsonToken.START_OBJECT) {
            return this.newObjectCursor(this.currentValue);
        }
        if (this.currentToken == JsonToken.START_ARRAY) {
            return this.newArrayCursor(this.currentValue);
        }
        throw new IllegalStateException("can not iterate children at token <" + this.currentToken + ">");
    }

    public String toString() {
        return "object @ " + this.currentToken;
    }
}

