/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.ext.jackson.datatype.parser;

import com.fasterxml.jackson.core.JsonToken;
import org.jspare.vertx.ext.jackson.datatype.parser.AbstractTreeCursor;

abstract class AbstractRootCursor<S, E>
extends AbstractTreeCursor<E> {
    private final S root;
    private JsonToken currentToken;
    private E currentElement;
    private boolean done = false;

    AbstractRootCursor(S rootElement) {
        super(0, null);
        if (rootElement == null) {
            throw new IllegalArgumentException("rootElement must not be null");
        }
        this.root = rootElement;
        this._index = -1;
    }

    protected abstract JsonToken getRootToken(S var1);

    protected abstract E getRootValue(S var1);

    @Override
    public JsonToken nextToken() {
        if (!this.done) {
            this.done = true;
            this.currentElement = this.getRootValue(this.root);
            this.currentToken = this.getRootToken(this.root);
            this._index = 0;
        } else {
            this.currentElement = null;
            this.currentToken = null;
        }
        return this.currentToken;
    }

    @Override
    public JsonToken nextValue() {
        return this.nextToken();
    }

    @Override
    public void skipChildren() {
        this.done = true;
    }

    @Override
    public JsonToken endToken() {
        return null;
    }

    @Override
    public E currentElement() {
        return this.currentElement;
    }

    @Override
    public boolean currentHasChildren() {
        return this.getNumberOfChildren(this.currentElement) > 0;
    }

    @Override
    public AbstractTreeCursor<E> iterateChildren() {
        if (this.currentToken == JsonToken.START_OBJECT) {
            return this.newObjectCursor(this.currentElement);
        }
        if (this.currentToken == JsonToken.START_ARRAY) {
            return this.newArrayCursor(this.currentElement);
        }
        throw new IllegalStateException("can not iterate children at token <" + this.currentToken + ">");
    }
}

