/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.ext.jackson.datatype.parser;

import com.fasterxml.jackson.core.JsonToken;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Iterator;
import org.jspare.vertx.ext.jackson.datatype.parser.AbstractArrayCursor;
import org.jspare.vertx.ext.jackson.datatype.parser.AbstractTreeCursor;
import org.jspare.vertx.ext.jackson.datatype.parser.JsonElementTokens;
import org.jspare.vertx.ext.jackson.datatype.parser.JsonObjectCursor;

class JsonArrayCursor
extends AbstractArrayCursor<JsonArray, Object> {
    JsonArrayCursor(JsonArray jsonArray, AbstractTreeCursor<Object> parentCursor) {
        super(jsonArray, parentCursor);
    }

    @Override
    protected Iterator<Object> getElements(JsonArray array) {
        return array.iterator();
    }

    @Override
    protected int getNumberOfChildren(Object element) {
        if (element instanceof JsonObject) {
            return ((JsonObject)element).size();
        }
        if (element instanceof JsonArray) {
            return ((JsonArray)element).size();
        }
        return -1;
    }

    @Override
    protected AbstractTreeCursor<Object> newObjectCursor(Object object) {
        return new JsonObjectCursor((JsonObject)object, this);
    }

    @Override
    protected AbstractTreeCursor<Object> newArrayCursor(Object array) {
        return new JsonArrayCursor((JsonArray)array, this);
    }

    @Override
    protected JsonToken getToken(Object element) {
        return JsonElementTokens.getToken(element);
    }
}

