/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.ext.jackson.datatype.parser;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jspare.vertx.ext.jackson.datatype.parser.AbstractTreeCursor;
import org.jspare.vertx.ext.jackson.datatype.parser.JsonObjectRootCursor;

public class JsonElementParser
extends ParserMinimalBase {
    protected ObjectCodec objectCodec;
    protected final AbstractTreeCursor<Object> rootCursor;
    protected AbstractTreeCursor<Object> cursor;
    protected String currentName;
    protected JsonToken nextToken;
    protected boolean closed;

    public JsonElementParser(Object element) {
        this(element, null);
    }

    public JsonElementParser(Object element, ObjectCodec codec) {
        super(0);
        if (element == null) {
            throw new IllegalArgumentException("element must not be null");
        }
        this.objectCodec = codec;
        this.rootCursor = new JsonObjectRootCursor(element);
        this.cursor = this.rootCursor;
    }

    public void setCodec(ObjectCodec c) {
        this.objectCodec = c;
    }

    public ObjectCodec getCodec() {
        return this.objectCodec;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.cursor = null;
            this._currToken = null;
        }
    }

    public JsonToken nextToken() throws IOException {
        return this.nextTokenInternal(false);
    }

    private JsonToken nextTokenInternal(boolean skipChildren) {
        if (this.closed) {
            this._currToken = null;
            return null;
        }
        if (skipChildren && (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY)) {
            this.cursor.skipChildren();
        }
        if (this._currToken == JsonToken.END_OBJECT || this._currToken == JsonToken.END_ARRAY) {
            if (this.cursor != this.rootCursor) {
                this.cursor = this.cursor.getParent();
            } else {
                this.closed = true;
            }
            this.updateInternalValues();
        }
        this._currToken = this.cursor.nextToken();
        if (this._currToken != null) {
            this.updateInternalValues();
            if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
                this.cursor = this.cursor.iterateChildren();
            }
        } else {
            this._currToken = this.cursor.endToken();
        }
        return this._currToken;
    }

    private void updateInternalValues() {
        if (this.cursor != null) {
            this.currentName = this.cursor.getCurrentName();
        }
    }

    public JsonParser skipChildren() throws IOException {
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            this.nextTokenInternal(true);
        }
        return this;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String getCurrentName() {
        return this.currentName;
    }

    public void overrideCurrentName(String name) {
        if (this.cursor != null) {
            this.cursor.overrideCurrentName(name);
        }
    }

    public JsonStreamContext getParsingContext() {
        if (this.cursor != null) {
            return this.cursor;
        }
        return this.rootCursor;
    }

    public JsonLocation getTokenLocation() {
        return JsonLocation.NA;
    }

    public JsonLocation getCurrentLocation() {
        return JsonLocation.NA;
    }

    public String getText() {
        if (this.closed) {
            return null;
        }
        if (this._currToken == null) {
            return null;
        }
        switch (this._currToken) {
            case FIELD_NAME: {
                return this.cursor.getCurrentName();
            }
            case VALUE_STRING: {
                return (String)this.currentNode();
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return String.valueOf(this.currentNode());
            }
            case VALUE_TRUE: {
                return "true";
            }
            case VALUE_FALSE: {
                return "false";
            }
            case VALUE_EMBEDDED_OBJECT: {
                return String.valueOf(this.currentNode());
            }
        }
        return this._currToken.asString();
    }

    public char[] getTextCharacters() throws IOException {
        return this.getText().toCharArray();
    }

    public int getTextLength() throws IOException {
        return this.getText().length();
    }

    public int getTextOffset() throws IOException {
        return 0;
    }

    public boolean hasTextCharacters() {
        return false;
    }

    public JsonParser.NumberType getNumberType() throws IOException {
        Number n = this.currentNumber();
        if (n instanceof Integer) {
            return JsonParser.NumberType.INT;
        }
        if (n instanceof Long) {
            return JsonParser.NumberType.LONG;
        }
        if (n instanceof Float) {
            return JsonParser.NumberType.FLOAT;
        }
        if (n instanceof Double) {
            return JsonParser.NumberType.DOUBLE;
        }
        if (n instanceof BigDecimal) {
            return JsonParser.NumberType.BIG_DECIMAL;
        }
        if (n instanceof BigInteger) {
            return JsonParser.NumberType.BIG_INTEGER;
        }
        return null;
    }

    public BigInteger getBigIntegerValue() throws IOException {
        Number n = this.currentNumber();
        if (n instanceof BigInteger) {
            return (BigInteger)n;
        }
        return BigInteger.valueOf(n.longValue());
    }

    public BigDecimal getDecimalValue() throws IOException {
        Number n = this.currentNumber();
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        return new BigDecimal(n.toString());
    }

    public double getDoubleValue() throws IOException {
        return this.currentNumber().doubleValue();
    }

    public float getFloatValue() throws IOException {
        return (float)this.currentNumber().doubleValue();
    }

    public long getLongValue() throws IOException {
        return this.currentNumber().longValue();
    }

    public int getIntValue() throws IOException {
        return this.currentNumber().intValue();
    }

    public Number getNumberValue() throws IOException {
        return this.currentNumber();
    }

    public Object getEmbeddedObject() {
        return this.currentNode();
    }

    public byte[] getBinaryValue(Base64Variant b64variant) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int readBinaryValue(Base64Variant b64variant, OutputStream out) throws IOException {
        byte[] data = this.getBinaryValue(b64variant);
        if (data != null) {
            out.write(data, 0, data.length);
            return data.length;
        }
        return 0;
    }

    protected Object currentNode() {
        if (this.closed || this.cursor == null) {
            return null;
        }
        return this.cursor.currentElement();
    }

    protected Number currentNumber() throws JsonParseException {
        Object n = this.currentNode();
        if (n instanceof Number) {
            return (Number)n;
        }
        if (n instanceof String) {
            try {
                return new BigDecimal((String)n);
            }
            catch (NumberFormatException e) {
                throw this._constructError("String value <" + n + "> is not numeric", e);
            }
        }
        throw this._constructError("Current token (" + this._currToken + ") not numeric, can not access numeric value");
    }

    protected void _handleEOF() throws JsonParseException {
        this._throwInternal();
    }
}

