/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.ext.jackson.datatype.parser;

import com.fasterxml.jackson.core.JsonToken;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.math.BigInteger;

class JsonElementTokens {
    JsonElementTokens() {
    }

    static JsonToken getToken(Object element) {
        if (element == null) {
            return JsonToken.VALUE_NULL;
        }
        if (element instanceof JsonObject) {
            return JsonToken.START_OBJECT;
        }
        if (element instanceof JsonArray) {
            return JsonToken.START_ARRAY;
        }
        if (element instanceof Boolean) {
            if (Boolean.TRUE.equals(element)) {
                return JsonToken.VALUE_TRUE;
            }
            return JsonToken.VALUE_FALSE;
        }
        if (element instanceof Number) {
            if (element instanceof Integer || element instanceof Long || element instanceof BigInteger || element instanceof Short) {
                return JsonToken.VALUE_NUMBER_INT;
            }
            return JsonToken.VALUE_NUMBER_FLOAT;
        }
        if (element instanceof String) {
            return JsonToken.VALUE_STRING;
        }
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }
}

