/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.ext.jackson.datatype.parser;

import com.fasterxml.jackson.core.JsonToken;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Iterator;
import org.jspare.vertx.ext.jackson.datatype.parser.AbstractObjectCursor;
import org.jspare.vertx.ext.jackson.datatype.parser.AbstractTreeCursor;
import org.jspare.vertx.ext.jackson.datatype.parser.JsonArrayCursor;
import org.jspare.vertx.ext.jackson.datatype.parser.JsonElementTokens;

public class JsonObjectCursor
extends AbstractObjectCursor<JsonObject, Object> {
    JsonObjectCursor(JsonObject jsonObject, AbstractTreeCursor<Object> parentCursor) {
        super(jsonObject, parentCursor);
    }

    @Override
    protected Iterator<String> getFields(JsonObject object) {
        return object.fieldNames().iterator();
    }

    @Override
    protected Object getValue(String fieldName, JsonObject object) {
        return object.getValue(fieldName);
    }

    @Override
    protected int getNumberOfChildren(Object element) {
        if (element instanceof JsonObject) {
            return ((JsonObject)element).size();
        }
        if (element instanceof JsonArray) {
            return ((JsonArray)element).size();
        }
        return -1;
    }

    @Override
    protected AbstractTreeCursor<Object> newObjectCursor(Object object) {
        return new JsonObjectCursor((JsonObject)object, this);
    }

    @Override
    protected AbstractTreeCursor<Object> newArrayCursor(Object array) {
        return new JsonArrayCursor((JsonArray)array, this);
    }

    @Override
    protected JsonToken getToken(Object element) {
        return JsonElementTokens.getToken(element);
    }
}

