/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.ext.jackson.datatype.parser;

import com.fasterxml.jackson.core.JsonToken;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import org.jspare.vertx.ext.jackson.datatype.parser.AbstractRootCursor;
import org.jspare.vertx.ext.jackson.datatype.parser.AbstractTreeCursor;
import org.jspare.vertx.ext.jackson.datatype.parser.JsonArrayCursor;
import org.jspare.vertx.ext.jackson.datatype.parser.JsonElementTokens;
import org.jspare.vertx.ext.jackson.datatype.parser.JsonObjectCursor;

public class JsonObjectRootCursor
extends AbstractRootCursor<Object, Object> {
    JsonObjectRootCursor(Object rootElement) {
        super(rootElement);
    }

    @Override
    protected JsonToken getRootToken(Object root) {
        if (root instanceof JsonObject) {
            return JsonToken.START_OBJECT;
        }
        if (root instanceof JsonArray) {
            return JsonToken.START_ARRAY;
        }
        throw new IllegalArgumentException("unknown JSON element type <" + root + ">");
    }

    @Override
    protected Object getRootValue(Object root) {
        return root;
    }

    @Override
    protected int getNumberOfChildren(Object element) {
        if (element instanceof JsonObject) {
            return ((JsonObject)element).size();
        }
        if (element instanceof JsonArray) {
            return ((JsonArray)element).size();
        }
        return -1;
    }

    @Override
    protected AbstractTreeCursor<Object> newObjectCursor(Object object) {
        return new JsonObjectCursor((JsonObject)object, this);
    }

    @Override
    protected AbstractTreeCursor<Object> newArrayCursor(Object array) {
        return new JsonArrayCursor((JsonArray)array, this);
    }

    @Override
    protected JsonToken getToken(Object element) {
        return JsonElementTokens.getToken(element);
    }
}

