/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.ext.jackson.datatype.parser;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

class SkippableIterator<E>
implements Iterator<E> {
    private final Iterator<E> it;
    private boolean started = false;
    private boolean skipped = false;

    SkippableIterator(Iterator<E> delegate) {
        this.it = delegate;
    }

    public void skip() {
        if (!this.started) {
            this.skipped = true;
        }
    }

    @Override
    public boolean hasNext() {
        return !this.skipped && this.it.hasNext();
    }

    @Override
    public E next() {
        if (this.skipped) {
            throw new NoSuchElementException("no more elements (remaining elements have been skipped)");
        }
        this.started = true;
        return this.it.next();
    }

    @Override
    public void remove() {
        if (this.skipped) {
            throw new IllegalStateException("can not remove item, end of iterator has been reached du to skipping");
        }
        this.it.remove();
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        if (!this.skipped) {
            this.started = true;
            this.it.forEachRemaining(action);
        }
    }
}

