/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.unit.ext.junit;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.impl.Helper;
import io.vertx.ext.unit.impl.TestContextImpl;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.jspare.core.Environment;
import org.jspare.unit.mock.MockerUtils;
import org.jspare.vertx.cdi.EnvironmentLoader;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.statements.Fail;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class VertxJspareUnitRunner
extends VertxUnitRunner {
    private static final ThreadLocal<VertxUnitRunner> currentRunner = new ThreadLocal();
    private static final LinkedList<Context> contextStack = new LinkedList();
    private static final LinkedList<Long> timeoutStack = new LinkedList();
    private final TestClass testClass;
    private Map<String, Object> classAttributes = new HashMap<String, Object>();
    private TestContextImpl testContext;

    public VertxJspareUnitRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.testClass = new TestClass(klass);
        this.setup();
    }

    static void pushContext(Context context) {
        contextStack.push(context);
    }

    static void popContext() {
        contextStack.pop();
    }

    static void pushTimeout(long timeout) {
        timeoutStack.push(timeout);
    }

    static void popTimeout() {
        timeoutStack.pop();
    }

    private void setup() {
        EnvironmentLoader.setup();
        EnvironmentLoader.bindInterfaces((Vertx)Vertx.vertx());
        MockerUtils.initialize((Class)this.testClass.getJavaClass());
    }

    protected void validatePublicVoidNoArgMethods(Class<? extends Annotation> annotation, boolean isStatic, List<Throwable> errors) {
        if (annotation == Test.class || annotation == Before.class || annotation == After.class || annotation == BeforeClass.class || annotation == AfterClass.class) {
            List fMethods = this.getTestClass().getAnnotatedMethods(annotation);
            for (FrameworkMethod fMethod : fMethods) {
                fMethod.validatePublicVoid(isStatic, errors);
                try {
                    this.validateTestMethod(fMethod);
                }
                catch (Exception e) {
                    errors.add(e);
                }
            }
        } else {
            super.validatePublicVoidNoArgMethods(annotation, isStatic, errors);
        }
    }

    protected void validateTestMethod(FrameworkMethod fMethod) throws Exception {
        Class<?>[] paramTypes = fMethod.getMethod().getParameterTypes();
        if (!(paramTypes.length == 0 || paramTypes.length == 1 && paramTypes[0].equals(TestContext.class))) {
            throw new Exception("Method " + fMethod.getName() + " should have no parameters or the " + TestContext.class.getName() + " parameter");
        }
    }

    protected Statement methodInvoker(final FrameworkMethod method, final Object test) {
        final TestContextImpl ctx = this.testContext;
        return new Statement(){

            public void evaluate() throws Throwable {
                VertxJspareUnitRunner.this.invokeExplosively(ctx, method, test);
            }
        };
    }

    protected void invokeTestMethod(FrameworkMethod fMethod, Object test, TestContext context) throws InvocationTargetException, IllegalAccessException {
        Method method = fMethod.getMethod();
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length == 0) {
            method.invoke(test, new Object[0]);
        } else {
            method.invoke(test, context);
        }
    }

    private long getTimeout(FrameworkMethod fMethod) {
        Test annotation;
        long timeout = 120000L;
        if (timeoutStack.size() > 0) {
            timeout = timeoutStack.peekLast();
        }
        if ((annotation = (Test)fMethod.getAnnotation(Test.class)) != null && annotation.timeout() > 0L) {
            timeout = annotation.timeout();
        }
        return timeout;
    }

    private void invokeExplosively(TestContextImpl testContext, FrameworkMethod fMethod, Object test) throws Throwable {
        Throwable failure;
        Handler callback = context -> {
            try {
                this.invokeTestMethod(fMethod, test, (TestContext)context);
            }
            catch (InvocationTargetException e) {
                Helper.uncheckedThrow((Throwable)e.getCause());
            }
            catch (IllegalAccessException e) {
                Helper.uncheckedThrow((Throwable)e);
            }
        };
        long timeout = this.getTimeout(fMethod);
        currentRunner.set(this);
        Context ctx = contextStack.peekLast();
        CompletableFuture future = new CompletableFuture();
        if (ctx != null) {
            ctx.runOnContext(v -> testContext.run(null, timeout, callback, future::complete));
        } else {
            testContext.run(null, timeout, callback, future::complete);
        }
        try {
            failure = (Throwable)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
        finally {
            currentRunner.set(null);
        }
        if (failure != null) {
            throw failure;
        }
    }

    protected Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
        return this.withBefores(this.testContext, this.getTestClass().getAnnotatedMethods(Before.class), target, statement);
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        List afters = this.getTestClass().getAnnotatedMethods(After.class);
        return this.withAfters(this.testContext, afters, target, statement);
    }

    protected Statement withBeforeClasses(Statement statement) {
        List befores = this.testClass.getAnnotatedMethods(BeforeClass.class);
        return this.withBefores(new TestContextImpl(this.classAttributes, null), befores, null, statement);
    }

    protected Statement withAfterClasses(Statement statement) {
        List afters = this.getTestClass().getAnnotatedMethods(AfterClass.class);
        return this.withAfters(new TestContextImpl(this.classAttributes, null), afters, null, statement);
    }

    protected Statement withPotentialTimeout(FrameworkMethod method, Object test, Statement next) {
        return next;
    }

    private Statement withBefores(final TestContextImpl testContext, final List<FrameworkMethod> befores, final Object target, final Statement statement) {
        if (befores.isEmpty()) {
            return statement;
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                for (FrameworkMethod before : befores) {
                    VertxJspareUnitRunner.this.invokeExplosively(testContext, before, target);
                }
                statement.evaluate();
            }
        };
    }

    private Statement withAfters(final TestContextImpl testContext, final List<FrameworkMethod> afters, final Object target, final Statement statement) {
        if (afters.isEmpty()) {
            return statement;
        }
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                try {
                    statement.evaluate();
                }
                catch (Throwable e) {
                    errors.add(e);
                }
                finally {
                    for (FrameworkMethod after : afters) {
                        try {
                            VertxJspareUnitRunner.this.invokeExplosively(testContext, after, target);
                        }
                        catch (Throwable e) {
                            errors.add(e);
                        }
                    }
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    protected Statement methodBlock(FrameworkMethod frameworkMethod) {
        Object testInstance;
        this.testContext = new TestContextImpl(new HashMap<String, Object>(this.classAttributes), null);
        try {
            testInstance = new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return VertxJspareUnitRunner.this.createTest();
                }
            }.run();
        }
        catch (Throwable ex) {
            return new Fail(ex);
        }
        Environment.inject((Object)testInstance);
        Statement statement = this.methodInvoker(frameworkMethod, testInstance);
        statement = this.possiblyExpectingExceptions(frameworkMethod, testInstance, statement);
        statement = this.withBefores(frameworkMethod, testInstance, statement);
        statement = this.withAfters(frameworkMethod, testInstance, statement);
        statement = this.withPotentialTimeout(frameworkMethod, testInstance, statement);
        this.testContext = null;
        return statement;
    }
}

