/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.unit.mock;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import java.util.function.Consumer;
import java.util.function.Function;

public class AsyncResultMocker {
    public static Function<Object[], Object> mock(Consumer<Future> supplier) {
        return args -> {
            if (((Object[])args).length < 1) {
                return null;
            }
            int lastArgument = ((Object[])args).length - 1;
            try {
                Future future = Future.future();
                Handler hAr = (Handler)args[lastArgument];
                supplier.accept(future);
                hAr.handle((Object)future);
            }
            catch (ClassCastException e) {
                throw new RuntimeException(e);
            }
            return null;
        };
    }

    public static Function<Object[], Object> mockSucceeded(Object[] args) {
        return AsyncResultMocker.mock(Future::succeededFuture);
    }

    public static Function<Object[], Object> mockSucceeded(Object result) {
        return AsyncResultMocker.mock(f -> f.complete(result));
    }

    public static Function<Object[], Object> mockFailed(Object[] args) {
        return AsyncResultMocker.mock(f -> f.fail((Throwable)new Exception()));
    }

    public static Function<Object[], Object> mockFailed(Exception e) {
        return AsyncResultMocker.mock(f -> f.fail((Throwable)e));
    }
}

