/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.web.builder;

import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jspare.core.annotation.Resource;
import org.jspare.vertx.builder.Collector;
import org.jspare.vertx.web.annotation.auth.Auth;
import org.jspare.vertx.web.annotation.auth.IgnoreAuth;
import org.jspare.vertx.web.annotation.content.Consumes;
import org.jspare.vertx.web.annotation.content.Produces;
import org.jspare.vertx.web.annotation.handler.BlockingHandler;
import org.jspare.vertx.web.annotation.handler.FailureHandler;
import org.jspare.vertx.web.annotation.handler.Handler;
import org.jspare.vertx.web.annotation.handler.SockJsHandler;
import org.jspare.vertx.web.annotation.method.All;
import org.jspare.vertx.web.annotation.subrouter.IgnoreSubRouter;
import org.jspare.vertx.web.annotation.subrouter.SubRouter;
import org.jspare.vertx.web.builder.HandlerData;
import org.jspare.vertx.web.builder.HandlerType;
import org.jspare.vertx.web.builder.HttpMethodType;
import org.jspare.vertx.web.builder.RouterBuilder;
import org.jspare.vertx.web.handler.BodyEndHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Resource
public class RouteCollector
implements Collector<Collection<HandlerData>> {
    private static final Logger log = LoggerFactory.getLogger(RouteCollector.class);

    public Collection<HandlerData> collect(Class<?> clazz, Object ... args) {
        if (args.length < 1) {
            throw new IllegalArgumentException(String.format("Cannot collect route class [%s] without routeHandlerClass or authHandler", clazz.getName()));
        }
        RouterBuilder builder = (RouterBuilder)((Object)args[0]);
        Class<? extends io.vertx.core.Handler<RoutingContext>> routeHandlerClass = builder.handlerClass();
        SockJSHandlerOptions sockJSHandlerOptions = builder.sockJSHandlerOptions();
        ArrayList<HandlerData> collectedHandlers = new ArrayList<HandlerData>();
        ArrayList<Annotation> httpMethodsAnnotations = new ArrayList<Annotation>(this.getHttpMethodsPresents(clazz));
        for (Method method : clazz.getDeclaredMethods()) {
            if (!this.isHandler(method)) continue;
            ArrayList<Annotation> handlerHttpMethodsAnnotations = new ArrayList<Annotation>();
            handlerHttpMethodsAnnotations.addAll(httpMethodsAnnotations);
            String consumes = method.isAnnotationPresent(Consumes.class) ? method.getAnnotation(Consumes.class).value() : "";
            String produces = method.isAnnotationPresent(Produces.class) ? method.getAnnotation(Produces.class).value() : "";
            List<BodyEndHandler> bodyEndHandler = this.collectBodyEndHandlers(method);
            AuthHandler authHandler = null;
            if (this.hasAuth(clazz, method) && !method.isAnnotationPresent(IgnoreAuth.class)) {
                Auth auth = method.isAnnotationPresent(Auth.class) ? this.getAuth(method) : this.getAuth(clazz);
                String identity = auth.authHandler();
                Optional<Supplier<AuthHandler>> oAuthHandler = Optional.ofNullable(builder.authHandlerMap().get(identity));
                if (oAuthHandler.isPresent()) {
                    Supplier<AuthHandler> authHandlerSupplier = oAuthHandler.get();
                    authHandler = authHandlerSupplier.get();
                    authHandler.addAuthorities(Arrays.asList(auth.value()).stream().filter(a -> StringUtils.isNotEmpty((String)a)).collect(Collectors.toSet()));
                }
            }
            HandlerData defaultHandlerData = new HandlerData().clazz(clazz).method(method).consumes(consumes).produces(produces).bodyEndHandler(bodyEndHandler).authHandler(authHandler).routeHandlerClass(routeHandlerClass);
            if (this.hasHttpMethodsPresents(method)) {
                handlerHttpMethodsAnnotations.clear();
                handlerHttpMethodsAnnotations.addAll(this.getHttpMethodsPresents(method));
            }
            this.getHandlersPresents(method).forEach(handlerType -> {
                try {
                    HandlerData handlerData = (HandlerData)defaultHandlerData.clone();
                    if (this.isHandlerAnnotation((Annotation)handlerType, SockJsHandler.class)) {
                        handlerData.handlerType(HandlerType.SOCKETJS_HANDLER);
                        handlerData.sockJSHandler(SockJSHandler.create((Vertx)builder.vertx(), (SockJSHandlerOptions)(sockJSHandlerOptions != null ? sockJSHandlerOptions : new SockJSHandlerOptions())));
                        handlerData.path(method.getAnnotation(SockJsHandler.class).value());
                        collectedHandlers.add(handlerData);
                        return;
                    }
                    if (this.isHandlerAnnotation((Annotation)handlerType, Handler.class)) {
                        handlerData.handlerType(HandlerType.HANDLER);
                    } else if (this.isHandlerAnnotation((Annotation)handlerType, FailureHandler.class)) {
                        handlerData.handlerType(HandlerType.HANDLER);
                    } else if (this.isHandlerAnnotation((Annotation)handlerType, BlockingHandler.class)) {
                        handlerData.handlerType(HandlerType.BLOCKING_HANDLER);
                    }
                    int order = (Integer)this.annotationMethod((Annotation)handlerType, "order");
                    handlerData.order(order);
                    if (handlerHttpMethodsAnnotations.isEmpty()) {
                        collectedHandlers.add(handlerData);
                    } else {
                        collectedHandlers.addAll(this.collectByMethods(handlerData, handlerHttpMethodsAnnotations));
                    }
                }
                catch (Exception e) {
                    log.warn("Ignoring handler class {} method {} - {}", new Object[]{clazz.getName(), method.getName(), e.getCause().toString()});
                }
            });
        }
        return collectedHandlers;
    }

    private <T> T annotationMethod(Annotation annotation, String methodRef) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method method = annotation.annotationType().getMethod(methodRef, new Class[0]);
        return (T)method.invoke((Object)annotation, new Object[0]);
    }

    private List<BodyEndHandler> collectBodyEndHandlers(Method method) {
        ArrayList<BodyEndHandler> handlers = new ArrayList<BodyEndHandler>();
        if (method.isAnnotationPresent(org.jspare.vertx.web.annotation.handler.BodyEndHandler.class)) {
            Arrays.asList(method.getAnnotation(org.jspare.vertx.web.annotation.handler.BodyEndHandler.class).value()).forEach(c -> {
                try {
                    handlers.add((BodyEndHandler)c.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    log.error("Cannot add bodyEndHandler [{}] to route instead of [{}]", (Object)c.getName(), (Object)method.getName());
                }
            });
        }
        return handlers;
    }

    private Collection<HandlerData> collectByMethods(HandlerData handlerSource, List<Annotation> httpMethodsAnnotations) {
        return httpMethodsAnnotations.stream().map(annotationHttpMethod -> {
            try {
                HandlerData handlerData = (HandlerData)handlerSource.clone();
                String prefix = "";
                String path = (String)this.annotationMethod((Annotation)annotationHttpMethod, "value");
                boolean isRegexPath = (Boolean)this.annotationMethod((Annotation)annotationHttpMethod, "regex");
                if (handlerData.clazz().isAnnotationPresent(SubRouter.class) && !handlerData.method().isAnnotationPresent(IgnoreSubRouter.class)) {
                    prefix = handlerData.clazz().getAnnotation(SubRouter.class).value();
                }
                handlerData.path(String.format("%s%s", prefix, path));
                handlerData.pathRegex(isRegexPath);
                if (All.class.equals(annotationHttpMethod.annotationType())) {
                    return handlerData;
                }
                handlerData.httpMethod(annotationHttpMethod.annotationType().getSimpleName().toUpperCase());
                return handlerData;
            }
            catch (Exception e) {
                log.warn("Ignoring handler class {} method {} - {}", new Object[]{handlerSource.clazz().getName(), handlerSource.method().getName(), e});
                return null;
            }
        }).collect(Collectors.toList());
    }

    private List<Annotation> getHandlersPresents(Method method) {
        List handlerClass = Arrays.asList(HandlerType.values()).stream().map(ht -> ht.getHandlerClass()).collect(Collectors.toList());
        return handlerClass.stream().filter(handlerType -> method.isAnnotationPresent((Class<? extends Annotation>)handlerType)).map(handlerType -> method.getAnnotation(handlerType)).collect(Collectors.toList());
    }

    private List<Annotation> getHttpMethodsPresents(AnnotatedElement element) {
        ArrayList<Class> filteredClazz = new ArrayList<Class>();
        filteredClazz.addAll(Arrays.asList(HttpMethodType.values()).stream().map(ht -> ht.getHttpMethodClass()).collect(Collectors.toList()));
        filteredClazz.removeIf(clazzHttpMethodType -> !element.isAnnotationPresent((Class<? extends Annotation>)clazzHttpMethodType));
        return filteredClazz.stream().map(httpMethodClazz -> element.getAnnotation(httpMethodClazz)).collect(Collectors.toList());
    }

    private boolean hasHttpMethodsPresents(Method method) {
        return this.getHttpMethodsPresents(method).stream().filter(annotation -> method.isAnnotationPresent(annotation.annotationType())).count() >= 1L;
    }

    private boolean isHandler(Method method) {
        return this.getHandlersPresents(method).stream().filter(handlerAnnotation -> method.isAnnotationPresent(handlerAnnotation.annotationType())).count() >= 1L;
    }

    protected Auth getAuth(AnnotatedElement annotatedElement) {
        return annotatedElement.getAnnotation(Auth.class);
    }

    protected boolean hasAuth(Class<?> clazz, Method method) {
        return (clazz.isAnnotationPresent(Auth.class) || method.isAnnotationPresent(Auth.class)) && !method.isAnnotationPresent(IgnoreAuth.class);
    }

    protected boolean isHandlerAnnotation(Annotation handlerType, Class<?> element) {
        return handlerType.annotationType().equals(element);
    }
}

