/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.web.builder;

import io.github.lukehutch.fastclasspathscanner.matchprocessor.MethodAnnotationMatchProcessor;
import io.vertx.core.Vertx;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jspare.core.container.Environment;
import org.jspare.vertx.builder.AbstractBuilder;
import org.jspare.vertx.builder.ClasspathScannerUtils;
import org.jspare.vertx.web.annotation.handler.BlockingHandler;
import org.jspare.vertx.web.annotation.handler.FailureHandler;
import org.jspare.vertx.web.annotation.handler.Handler;
import org.jspare.vertx.web.annotation.handler.SockJsHandler;
import org.jspare.vertx.web.builder.HandlerWrapper;
import org.jspare.vertx.web.builder.RouteCollector;
import org.jspare.vertx.web.handler.DefaultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterBuilder
extends AbstractBuilder<Router> {
    private static final Logger log = LoggerFactory.getLogger(RouterBuilder.class);
    private static final int NUMBER_CLASSPATH_SCANNER_THREADS = 3;
    public static final String DEFAULT_AUTH_HANDLER_KEY = "default-auth-handler";
    private final Vertx vertx;
    private Router router;
    private boolean scanClasspath;
    private List<io.vertx.core.Handler<RoutingContext>> handlers;
    private Class<? extends io.vertx.core.Handler<RoutingContext>> handlerClass;
    private SockJSHandlerOptions sockJSHandlerOptions;
    private Map<String, Supplier<AuthHandler>> authHandlerMap;
    private List<Class<?>> routes;
    private List<Class<?>> skipRoutes;
    private List<String> routePackages;

    public static RouterBuilder create(Vertx vertx) {
        return new RouterBuilder(vertx, Router.router((Vertx)vertx));
    }

    public static RouterBuilder create(Vertx vertx, Router router) {
        return new RouterBuilder(vertx, router);
    }

    private RouterBuilder(Vertx vertx, Router router) {
        this.vertx = vertx;
        this.router = router;
        this.handlers = new ArrayList<io.vertx.core.Handler<RoutingContext>>();
        this.scanClasspath = false;
        this.routePackages = new ArrayList<String>();
        this.routes = new ArrayList();
        this.skipRoutes = new ArrayList();
        this.handlerClass = DefaultHandler.class;
        this.sockJSHandlerOptions = new SockJSHandlerOptions();
        this.authHandlerMap = new HashMap<String, Supplier<AuthHandler>>();
    }

    public RouterBuilder addHandler(io.vertx.core.Handler<RoutingContext> handler) {
        this.handlers.add(handler);
        return this;
    }

    public RouterBuilder addRoute(Class<?> routeClass) {
        this.routes.add(routeClass);
        return this;
    }

    public RouterBuilder addRoutePackage(String routePackage) {
        this.routePackages.add(routePackage);
        return this;
    }

    public RouterBuilder authHandler(String identity, Supplier<AuthHandler> authHandler) {
        this.authHandlerMap.put(identity, authHandler);
        return this;
    }

    public RouterBuilder authHandler(Supplier<AuthHandler> authHandler) {
        this.authHandler(DEFAULT_AUTH_HANDLER_KEY, authHandler);
        return this;
    }

    public Router build() {
        log.debug("Building Router");
        this.handlers.forEach(h -> {
            log.debug("Routing handler [{}]", (Object)h.toString());
            this.router.route().handler(h);
        });
        this.collectRoutes();
        ArrayList handlerDataList = new ArrayList();
        this.routes.stream().filter(c -> !this.skipRoutes.contains(c)).collect(Collectors.toSet()).forEach(c -> handlerDataList.addAll(((RouteCollector)Environment.my(RouteCollector.class)).collect((Class)c, new Object[]{this})));
        handlerDataList.forEach(hd -> {
            log.debug("Routing handler {}", (Object)hd.toStringLine());
            HandlerWrapper.prepareHandler(this.router, hd);
        });
        return this.router;
    }

    public RouterBuilder removeAuthHandler(String identity) {
        this.authHandlerMap.remove(identity);
        return this;
    }

    public RouterBuilder route(Consumer<Route> builder) {
        log.debug("Routing custom route [{}]", builder.getClass());
        builder.accept(this.router.route());
        return this;
    }

    public RouterBuilder skipRoute(Class<?> routeClass) {
        this.skipRoutes.add(routeClass);
        return this;
    }

    private void collectRoutes() {
        if (this.scanClasspath) {
            this.routePackages.clear();
            this.routePackages.add(".*");
        }
        MethodAnnotationMatchProcessor processor = (c, m) -> this.routes.add(c);
        this.routePackages.forEach(scanSpec -> ClasspathScannerUtils.scanner((String)scanSpec).matchClassesWithMethodAnnotation(Handler.class, processor).matchClassesWithMethodAnnotation(FailureHandler.class, processor).matchClassesWithMethodAnnotation(BlockingHandler.class, processor).matchClassesWithMethodAnnotation(SockJsHandler.class, processor).scan(3));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RouterBuilder)) {
            return false;
        }
        RouterBuilder other = (RouterBuilder)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Vertx this$vertx = this.vertx();
        Vertx other$vertx = other.vertx();
        if (this$vertx == null ? other$vertx != null : !this$vertx.equals(other$vertx)) {
            return false;
        }
        Router this$router = this.router();
        Router other$router = other.router();
        if (this$router == null ? other$router != null : !this$router.equals(other$router)) {
            return false;
        }
        if (this.scanClasspath() != other.scanClasspath()) {
            return false;
        }
        List<io.vertx.core.Handler<RoutingContext>> this$handlers = this.handlers();
        List<io.vertx.core.Handler<RoutingContext>> other$handlers = other.handlers();
        if (this$handlers == null ? other$handlers != null : !((Object)this$handlers).equals(other$handlers)) {
            return false;
        }
        Class<? extends io.vertx.core.Handler<RoutingContext>> this$handlerClass = this.handlerClass();
        Class<? extends io.vertx.core.Handler<RoutingContext>> other$handlerClass = other.handlerClass();
        if (this$handlerClass == null ? other$handlerClass != null : !this$handlerClass.equals(other$handlerClass)) {
            return false;
        }
        SockJSHandlerOptions this$sockJSHandlerOptions = this.sockJSHandlerOptions();
        SockJSHandlerOptions other$sockJSHandlerOptions = other.sockJSHandlerOptions();
        if (this$sockJSHandlerOptions == null ? other$sockJSHandlerOptions != null : !this$sockJSHandlerOptions.equals(other$sockJSHandlerOptions)) {
            return false;
        }
        Map<String, Supplier<AuthHandler>> this$authHandlerMap = this.authHandlerMap();
        Map<String, Supplier<AuthHandler>> other$authHandlerMap = other.authHandlerMap();
        if (this$authHandlerMap == null ? other$authHandlerMap != null : !((Object)this$authHandlerMap).equals(other$authHandlerMap)) {
            return false;
        }
        List<Class<?>> this$routes = this.routes();
        List<Class<?>> other$routes = other.routes();
        if (this$routes == null ? other$routes != null : !((Object)this$routes).equals(other$routes)) {
            return false;
        }
        List<Class<?>> this$skipRoutes = this.skipRoutes();
        List<Class<?>> other$skipRoutes = other.skipRoutes();
        if (this$skipRoutes == null ? other$skipRoutes != null : !((Object)this$skipRoutes).equals(other$skipRoutes)) {
            return false;
        }
        List<String> this$routePackages = this.routePackages();
        List<String> other$routePackages = other.routePackages();
        return !(this$routePackages == null ? other$routePackages != null : !((Object)this$routePackages).equals(other$routePackages));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RouterBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vertx $vertx = this.vertx();
        result = result * 59 + ($vertx == null ? 43 : $vertx.hashCode());
        Router $router = this.router();
        result = result * 59 + ($router == null ? 43 : $router.hashCode());
        result = result * 59 + (this.scanClasspath() ? 79 : 97);
        List<io.vertx.core.Handler<RoutingContext>> $handlers = this.handlers();
        result = result * 59 + ($handlers == null ? 43 : ((Object)$handlers).hashCode());
        Class<? extends io.vertx.core.Handler<RoutingContext>> $handlerClass = this.handlerClass();
        result = result * 59 + ($handlerClass == null ? 43 : $handlerClass.hashCode());
        SockJSHandlerOptions $sockJSHandlerOptions = this.sockJSHandlerOptions();
        result = result * 59 + ($sockJSHandlerOptions == null ? 43 : $sockJSHandlerOptions.hashCode());
        Map<String, Supplier<AuthHandler>> $authHandlerMap = this.authHandlerMap();
        result = result * 59 + ($authHandlerMap == null ? 43 : ((Object)$authHandlerMap).hashCode());
        List<Class<?>> $routes = this.routes();
        result = result * 59 + ($routes == null ? 43 : ((Object)$routes).hashCode());
        List<Class<?>> $skipRoutes = this.skipRoutes();
        result = result * 59 + ($skipRoutes == null ? 43 : ((Object)$skipRoutes).hashCode());
        List<String> $routePackages = this.routePackages();
        result = result * 59 + ($routePackages == null ? 43 : ((Object)$routePackages).hashCode());
        return result;
    }

    public Vertx vertx() {
        return this.vertx;
    }

    public Router router() {
        return this.router;
    }

    public RouterBuilder router(Router router) {
        this.router = router;
        return this;
    }

    public boolean scanClasspath() {
        return this.scanClasspath;
    }

    public RouterBuilder scanClasspath(boolean scanClasspath) {
        this.scanClasspath = scanClasspath;
        return this;
    }

    public List<io.vertx.core.Handler<RoutingContext>> handlers() {
        return this.handlers;
    }

    public RouterBuilder handlers(List<io.vertx.core.Handler<RoutingContext>> handlers) {
        this.handlers = handlers;
        return this;
    }

    public Class<? extends io.vertx.core.Handler<RoutingContext>> handlerClass() {
        return this.handlerClass;
    }

    public RouterBuilder handlerClass(Class<? extends io.vertx.core.Handler<RoutingContext>> handlerClass) {
        this.handlerClass = handlerClass;
        return this;
    }

    public SockJSHandlerOptions sockJSHandlerOptions() {
        return this.sockJSHandlerOptions;
    }

    public RouterBuilder sockJSHandlerOptions(SockJSHandlerOptions sockJSHandlerOptions) {
        this.sockJSHandlerOptions = sockJSHandlerOptions;
        return this;
    }

    public Map<String, Supplier<AuthHandler>> authHandlerMap() {
        return this.authHandlerMap;
    }

    public List<Class<?>> routes() {
        return this.routes;
    }

    public RouterBuilder routes(List<Class<?>> routes) {
        this.routes = routes;
        return this;
    }

    public List<Class<?>> skipRoutes() {
        return this.skipRoutes;
    }

    public RouterBuilder skipRoutes(List<Class<?>> skipRoutes) {
        this.skipRoutes = skipRoutes;
        return this;
    }

    public List<String> routePackages() {
        return this.routePackages;
    }

    public RouterBuilder routePackages(List<String> routePackages) {
        this.routePackages = routePackages;
        return this;
    }
}

