/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.web.experimental;

import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.CookieHandler;
import io.vertx.ext.web.handler.ResponseTimeHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.jspare.vertx.experimental.Configurable;
import org.jspare.vertx.experimental.Module;
import org.jspare.vertx.web.builder.HttpServerBuilder;
import org.jspare.vertx.web.builder.RouterBuilder;

@Module(value="httpServer")
public class HttpServerModule
implements Configurable {
    public static final String NAME = "httpServer";

    public void execute(Verticle verticle, String[] args) {
        Vertx vertx = verticle.getVertx();
        HttpServerOptions options = this.getOptions(verticle);
        Router router = this.getRouter(verticle);
        HttpServer server = HttpServerBuilder.create(vertx).httpServerOptions(options).router(router).build();
        server.listen();
    }

    private HttpServerOptions getOptions(Verticle verticle) {
        Optional<Method> oMethod = Arrays.asList(verticle.getClass().getDeclaredMethods()).stream().filter(m -> HttpServerOptions.class.equals(m.getReturnType())).findFirst();
        if (oMethod.isPresent() && oMethod.get().getParameterCount() == 0) {
            Method method = oMethod.get();
            method.setAccessible(true);
            return (HttpServerOptions)method.invoke((Object)verticle, new Object[0]);
        }
        return new HttpServerOptions(verticle.getVertx().getOrCreateContext().config());
    }

    private Router getRouter(Verticle verticle) {
        Optional<Method> oMethod = Arrays.asList(verticle.getClass().getDeclaredMethods()).stream().filter(m -> Router.class.equals(m.getReturnType())).findFirst();
        if (oMethod.isPresent() && oMethod.get().getParameterCount() == 0) {
            Method method = oMethod.get();
            method.setAccessible(true);
            return (Router)method.invoke((Object)verticle, new Object[0]);
        }
        Router router = RouterBuilder.create(verticle.getVertx()).addHandler((Handler<RoutingContext>)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)verticle.getVertx()))).addHandler((Handler<RoutingContext>)CookieHandler.create()).addHandler((Handler<RoutingContext>)BodyHandler.create()).addHandler((Handler<RoutingContext>)ResponseTimeHandler.create()).scanClasspath(true).build();
        return router;
    }
}

