/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.web.handler;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspare.vertx.concurrent.FutureSupplier;

public abstract class APIHandler {
    protected Vertx vertx;
    protected HttpServerRequest req;
    protected HttpServerResponse res;
    protected RoutingContext context;
    protected SockJSSocket sockJSEvent;

    protected void accepted() {
        this.status(HttpResponseStatus.ACCEPTED).end();
    }

    protected void accepted(Buffer buffer) {
        this.status(HttpResponseStatus.ACCEPTED).end(buffer);
    }

    protected void accepted(Object object) {
        this.accepted(object, StandardCharsets.UTF_8);
    }

    protected void accepted(Object object, Charset charset) {
        this.status(HttpResponseStatus.ACCEPTED);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void accepted(String content) {
        this.accepted(content, StandardCharsets.UTF_8);
    }

    protected void accepted(String content, Charset charset) {
        this.status(HttpResponseStatus.ACCEPTED);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void badGateway() {
        this.status(HttpResponseStatus.BAD_GATEWAY).end();
    }

    protected void badGateway(Buffer buffer) {
        this.status(HttpResponseStatus.BAD_GATEWAY).end(buffer);
    }

    protected void badGateway(Object object) {
        this.badGateway(object, StandardCharsets.UTF_8);
    }

    protected void badGateway(Object object, Charset charset) {
        this.status(HttpResponseStatus.BAD_GATEWAY);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void badGateway(String content) {
        this.badGateway(content, StandardCharsets.UTF_8);
    }

    protected void badGateway(String content, Charset charset) {
        this.status(HttpResponseStatus.BAD_GATEWAY);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void badRequest() {
        this.status(HttpResponseStatus.BAD_REQUEST).end();
    }

    protected void badRequest(Buffer buffer) {
        this.status(HttpResponseStatus.BAD_REQUEST).end(buffer);
    }

    protected void badRequest(Object object) {
        this.badRequest(object, StandardCharsets.UTF_8);
    }

    protected void badRequest(Object object, Charset charset) {
        this.status(HttpResponseStatus.BAD_REQUEST);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void badRequest(String content) {
        this.badRequest(content, StandardCharsets.UTF_8);
    }

    protected void badRequest(String content, Charset charset) {
        this.status(HttpResponseStatus.BAD_REQUEST);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected String body() {
        return this.context.getBodyAsString();
    }

    protected void conflict() {
        this.status(HttpResponseStatus.CONFLICT).end();
    }

    protected void conflict(Buffer buffer) {
        this.status(HttpResponseStatus.CONFLICT).end(buffer);
    }

    protected void conflict(Object object) {
        this.conflict(object, StandardCharsets.UTF_8);
    }

    protected void conflict(Object object, Charset charset) {
        this.status(HttpResponseStatus.CONFLICT);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void conflict(String content) {
        this.conflict(content, StandardCharsets.UTF_8);
    }

    protected void conflict(String content, Charset charset) {
        this.conflict(HttpResponseStatus.CONFLICT);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected HttpServerResponse contentType(String contentType) {
        this.res.putHeader("content-type", contentType);
        return this.res;
    }

    protected void continueIt() {
        this.status(HttpResponseStatus.CONTINUE).end();
    }

    protected void continueIt(Buffer buffer) {
        this.status(HttpResponseStatus.CONTINUE).end(buffer);
    }

    protected void continueIt(Object object) {
        this.continueIt(object, StandardCharsets.UTF_8);
    }

    protected void continueIt(Object object, Charset charset) {
        this.status(HttpResponseStatus.CONTINUE);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void continueIt(String content) {
        this.continueIt(content, StandardCharsets.UTF_8);
    }

    protected void continueIt(String content, Charset charset) {
        this.status(HttpResponseStatus.CONTINUE);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected Set<Cookie> cookies() {
        return this.context.cookies();
    }

    protected void created() {
        this.status(HttpResponseStatus.CREATED).end();
    }

    protected void created(Buffer buffer) {
        this.status(HttpResponseStatus.CREATED).end(buffer);
    }

    protected void created(Object object) {
        this.created(object, StandardCharsets.UTF_8);
    }

    protected void created(Object object, Charset charset) {
        this.status(HttpResponseStatus.CREATED);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void created(String content) {
        this.created(content, StandardCharsets.UTF_8);
    }

    protected void created(String content, Charset charset) {
        this.created(HttpResponseStatus.CREATED);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void end() {
        if (!this.res.ended()) {
            this.res.end();
        }
    }

    protected void end(Buffer buffer) {
        if (!this.res.ended()) {
            this.res.end(buffer);
        }
    }

    protected void end(JsonObject jsonObject) {
        if (!this.res.ended()) {
            this.res.end(jsonObject.encode());
        }
    }

    protected void error() {
        this.internalServerError();
    }

    protected void error(Buffer buffer) {
        this.internalServerError(buffer);
    }

    protected void error(Object object) {
        this.internalServerError(object);
    }

    protected void error(Object object, Charset charset) {
        this.internalServerError(object, charset);
    }

    protected void error(String content) {
        this.internalServerError(content);
    }

    protected void error(String content, Charset charset) {
        this.internalServerError(content, charset);
    }

    protected void expectationFailed() {
        this.status(HttpResponseStatus.EXPECTATION_FAILED).end();
    }

    protected void expectationFailed(Buffer buffer) {
        this.status(HttpResponseStatus.EXPECTATION_FAILED).end(buffer);
    }

    protected void expectationFailed(Object object) {
        this.expectationFailed(object, StandardCharsets.UTF_8);
    }

    protected void expectationFailed(Object object, Charset charset) {
        this.status(HttpResponseStatus.EXPECTATION_FAILED);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void expectationFailed(String content) {
        this.expectationFailed(content, StandardCharsets.UTF_8);
    }

    protected void expectationFailed(String content, Charset charset) {
        this.status(HttpResponseStatus.EXPECTATION_FAILED);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void failedDependency() {
        this.status(HttpResponseStatus.FAILED_DEPENDENCY).end();
    }

    protected void failedDependency(Buffer buffer) {
        this.status(HttpResponseStatus.FAILED_DEPENDENCY).end(buffer);
    }

    protected void failedDependency(Object object) {
        this.failedDependency(object, StandardCharsets.UTF_8);
    }

    protected void failedDependency(Object object, Charset charset) {
        this.status(HttpResponseStatus.FAILED_DEPENDENCY);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void failedDependency(String content) {
        this.failedDependency(content, StandardCharsets.UTF_8);
    }

    protected void failedDependency(String content, Charset charset) {
        this.status(HttpResponseStatus.FAILED_DEPENDENCY);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected Set<FileUpload> fileUploads() {
        return this.context.fileUploads();
    }

    protected void forbidden() {
        this.status(HttpResponseStatus.FORBIDDEN).end();
    }

    protected void forbidden(Buffer buffer) {
        this.status(HttpResponseStatus.FORBIDDEN).end(buffer);
    }

    protected void forbidden(Object object) {
        this.forbidden(object, StandardCharsets.UTF_8);
    }

    protected void forbidden(Object object, Charset charset) {
        this.status(HttpResponseStatus.FORBIDDEN);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void forbidden(String content) {
        this.forbidden(content, StandardCharsets.UTF_8);
    }

    protected void forbidden(String content, Charset charset) {
        this.status(HttpResponseStatus.FORBIDDEN);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void found() {
        this.status(HttpResponseStatus.FOUND).end();
    }

    protected void found(Buffer buffer) {
        this.status(HttpResponseStatus.FOUND).end(buffer);
    }

    protected void found(Object object) {
        this.found(object, StandardCharsets.UTF_8);
    }

    protected void found(Object object, Charset charset) {
        this.status(HttpResponseStatus.FOUND);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void found(String content) {
        this.found(content, StandardCharsets.UTF_8);
    }

    protected void found(String content, Charset charset) {
        this.status(HttpResponseStatus.FOUND);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void gatewayTimeout() {
        this.status(HttpResponseStatus.GATEWAY_TIMEOUT).end();
    }

    protected void gatewayTimeout(Buffer buffer) {
        this.status(HttpResponseStatus.GATEWAY_TIMEOUT).end(buffer);
    }

    protected void gatewayTimeout(Object object) {
        this.gatewayTimeout(object, StandardCharsets.UTF_8);
    }

    protected void gatewayTimeout(Object object, Charset charset) {
        this.status(HttpResponseStatus.GATEWAY_TIMEOUT);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void gatewayTimeout(String content) {
        this.gatewayTimeout(content, StandardCharsets.UTF_8);
    }

    protected void gatewayTimeout(String content, Charset charset) {
        this.status(HttpResponseStatus.GATEWAY_TIMEOUT);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected Cookie getCookie(String name) {
        return this.context.getCookie(name);
    }

    protected Optional<String> getHeader(String name) {
        return Optional.ofNullable(this.req.getHeader(name));
    }

    protected String getParameter(String name) {
        return this.req.getParam(name);
    }

    protected JsonObject getPrincipal() {
        if (this.context.user() == null) {
            return null;
        }
        return this.context.user().principal();
    }

    protected User getUser() {
        return this.context.user();
    }

    protected void gone() {
        this.status(HttpResponseStatus.GONE).end();
    }

    protected void gone(Buffer buffer) {
        this.status(HttpResponseStatus.GONE).end(buffer);
    }

    protected void gone(Object object) {
        this.gone(object, StandardCharsets.UTF_8);
    }

    protected void gone(Object object, Charset charset) {
        this.status(HttpResponseStatus.GONE);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void gone(String content) {
        this.gone(content, StandardCharsets.UTF_8);
    }

    protected void gone(String content, Charset charset) {
        this.status(HttpResponseStatus.GONE);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void httpVersionNotSupported() {
        this.status(HttpResponseStatus.HTTP_VERSION_NOT_SUPPORTED).end();
    }

    protected void httpVersionNotSupported(Buffer buffer) {
        this.status(HttpResponseStatus.HTTP_VERSION_NOT_SUPPORTED).end(buffer);
    }

    protected void httpVersionNotSupported(Object object) {
        this.httpVersionNotSupported(object, StandardCharsets.UTF_8);
    }

    protected void httpVersionNotSupported(Object object, Charset charset) {
        this.status(HttpResponseStatus.HTTP_VERSION_NOT_SUPPORTED);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void httpVersionNotSupported(String content) {
        this.httpVersionNotSupported(content, StandardCharsets.UTF_8);
    }

    protected void httpVersionNotSupported(String content, Charset charset) {
        this.status(HttpResponseStatus.HTTP_VERSION_NOT_SUPPORTED);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void insufficientStorage() {
        this.status(HttpResponseStatus.INSUFFICIENT_STORAGE).end();
    }

    protected void insufficientStorage(Buffer buffer) {
        this.status(HttpResponseStatus.INSUFFICIENT_STORAGE).end(buffer);
    }

    protected void insufficientStorage(Object object) {
        this.insufficientStorage(object, StandardCharsets.UTF_8);
    }

    protected void insufficientStorage(Object object, Charset charset) {
        this.status(HttpResponseStatus.INSUFFICIENT_STORAGE);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void insufficientStorage(String content) {
        this.insufficientStorage(content, StandardCharsets.UTF_8);
    }

    protected void insufficientStorage(String content, Charset charset) {
        this.status(HttpResponseStatus.INSUFFICIENT_STORAGE);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void internalServerError() {
        this.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).end();
    }

    protected void internalServerError(Buffer buffer) {
        this.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).end(buffer);
    }

    protected void internalServerError(Object object) {
        this.internalServerError(object, StandardCharsets.UTF_8);
    }

    protected void internalServerError(Object object, Charset charset) {
        this.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void internalServerError(String content) {
        this.internalServerError(content, StandardCharsets.UTF_8);
    }

    protected void internalServerError(String content, Charset charset) {
        this.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void isAuthorised(List<String> permissions, Handler<Void> resultHandler) {
        List futures = permissions.stream().map(p -> {
            Future future = Future.future();
            this.context.user().isAuthorised(p, future.completer());
            return future;
        }).collect(Collectors.toList());
        FutureSupplier.sequenceFuture(futures).setHandler(resultList -> {
            if (resultList.succeeded()) {
                boolean isAuthorized = ((List)resultList.result()).stream().reduce(false, (a, b) -> {
                    if (a.booleanValue()) {
                        return a;
                    }
                    return b;
                });
                if (!isAuthorized) {
                    this.forbidden();
                    return;
                }
                resultHandler.handle(null);
            } else {
                this.error(resultList.cause());
            }
        });
    }

    protected void isAuthorised(String authority, Handler<AsyncResult<Boolean>> resultHandler) {
        this.context.user().isAuthorised(authority, resultHandler);
    }

    protected boolean isValidJson(String content) {
        try {
            Json.decodeValue((String)content, Object.class);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void lengthRequired() {
        this.status(HttpResponseStatus.LENGTH_REQUIRED).end();
    }

    protected void lengthRequired(Buffer buffer) {
        this.status(HttpResponseStatus.LENGTH_REQUIRED).end(buffer);
    }

    protected void lengthRequired(Object object) {
        this.lengthRequired(object, StandardCharsets.UTF_8);
    }

    protected void lengthRequired(Object object, Charset charset) {
        this.status(HttpResponseStatus.LENGTH_REQUIRED);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void lengthRequired(String content) {
        this.lengthRequired(content, StandardCharsets.UTF_8);
    }

    protected void lengthRequired(String content, Charset charset) {
        this.status(HttpResponseStatus.LENGTH_REQUIRED);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void locked() {
        this.status(HttpResponseStatus.LOCKED).end();
    }

    protected void locked(Buffer buffer) {
        this.status(HttpResponseStatus.LOCKED).end(buffer);
    }

    protected void locked(Object object) {
        this.locked(object, StandardCharsets.UTF_8);
    }

    protected void locked(Object object, Charset charset) {
        this.status(HttpResponseStatus.LOCKED);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void locked(String content) {
        this.locked(content, StandardCharsets.UTF_8);
    }

    protected void locked(String content, Charset charset) {
        this.status(HttpResponseStatus.LOCKED);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void methodNotAllowed() {
        this.status(HttpResponseStatus.METHOD_NOT_ALLOWED).end();
    }

    protected void methodNotAllowed(Buffer buffer) {
        this.status(HttpResponseStatus.METHOD_NOT_ALLOWED).end(buffer);
    }

    protected void methodNotAllowed(Object object) {
        this.methodNotAllowed(object, StandardCharsets.UTF_8);
    }

    protected void methodNotAllowed(Object object, Charset charset) {
        this.status(HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void methodNotAllowed(String content) {
        this.methodNotAllowed(content, StandardCharsets.UTF_8);
    }

    protected void methodNotAllowed(String content, Charset charset) {
        this.status(HttpResponseStatus.METHOD_NOT_ALLOWED);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void misdirectedRequest() {
        this.status(HttpResponseStatus.MISDIRECTED_REQUEST).end();
    }

    protected void misdirectedRequest(Buffer buffer) {
        this.status(HttpResponseStatus.MISDIRECTED_REQUEST).end(buffer);
    }

    protected void misdirectedRequest(Object object) {
        this.misdirectedRequest(object, StandardCharsets.UTF_8);
    }

    protected void misdirectedRequest(Object object, Charset charset) {
        this.status(HttpResponseStatus.MISDIRECTED_REQUEST);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void misdirectedRequest(String content) {
        this.misdirectedRequest(content, StandardCharsets.UTF_8);
    }

    protected void misdirectedRequest(String content, Charset charset) {
        this.status(HttpResponseStatus.MISDIRECTED_REQUEST);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void movedPermanently() {
        this.status(HttpResponseStatus.MOVED_PERMANENTLY).end();
    }

    protected void movedPermanently(Buffer buffer) {
        this.status(HttpResponseStatus.MOVED_PERMANENTLY).end(buffer);
    }

    protected void movedPermanently(Object object) {
        this.movedPermanently(object, StandardCharsets.UTF_8);
    }

    protected void movedPermanently(Object object, Charset charset) {
        this.status(HttpResponseStatus.MOVED_PERMANENTLY);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void movedPermanently(String content) {
        this.movedPermanently(content, StandardCharsets.UTF_8);
    }

    protected void movedPermanently(String content, Charset charset) {
        this.status(HttpResponseStatus.MOVED_PERMANENTLY);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void multipleChoices() {
        this.status(HttpResponseStatus.MULTIPLE_CHOICES).end();
    }

    protected void multipleChoices(Buffer buffer) {
        this.status(HttpResponseStatus.MULTIPLE_CHOICES).end(buffer);
    }

    protected void multipleChoices(Object object) {
        this.multipleChoices(object, StandardCharsets.UTF_8);
    }

    protected void multipleChoices(Object object, Charset charset) {
        this.status(HttpResponseStatus.MULTIPLE_CHOICES);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void multipleChoices(String content) {
        this.multipleChoices(content, StandardCharsets.UTF_8);
    }

    protected void multipleChoices(String content, Charset charset) {
        this.status(HttpResponseStatus.MULTIPLE_CHOICES);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void multiStatus() {
        this.status(HttpResponseStatus.MULTI_STATUS).end();
    }

    protected void multiStatus(Buffer buffer) {
        this.status(HttpResponseStatus.MULTI_STATUS).end(buffer);
    }

    protected void multiStatus(Object object) {
        this.multiStatus(object, StandardCharsets.UTF_8);
    }

    protected void multiStatus(Object object, Charset charset) {
        this.status(HttpResponseStatus.MULTI_STATUS);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void multiStatus(String content) {
        this.multiStatus(content, StandardCharsets.UTF_8);
    }

    protected void multiStatus(String content, Charset charset) {
        this.status(HttpResponseStatus.MULTI_STATUS);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void networkAuthenticationRequired() {
        this.status(HttpResponseStatus.NETWORK_AUTHENTICATION_REQUIRED).end();
    }

    protected void networkAuthenticationRequired(Buffer buffer) {
        this.status(HttpResponseStatus.NETWORK_AUTHENTICATION_REQUIRED).end(buffer);
    }

    protected void networkAuthenticationRequired(Object object) {
        this.networkAuthenticationRequired(object, StandardCharsets.UTF_8);
    }

    protected void networkAuthenticationRequired(Object object, Charset charset) {
        this.status(HttpResponseStatus.NETWORK_AUTHENTICATION_REQUIRED);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void networkAuthenticationRequired(String content) {
        this.networkAuthenticationRequired(content, StandardCharsets.UTF_8);
    }

    protected void networkAuthenticationRequired(String content, Charset charset) {
        this.status(HttpResponseStatus.NETWORK_AUTHENTICATION_REQUIRED);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void noContent() {
        this.status(HttpResponseStatus.NO_CONTENT).end();
    }

    protected void noContent(Buffer buffer) {
        this.status(HttpResponseStatus.NO_CONTENT).end(buffer);
    }

    protected void noContent(Object object) {
        this.noContent(object, StandardCharsets.UTF_8);
    }

    protected void noContent(Object object, Charset charset) {
        this.status(HttpResponseStatus.NO_CONTENT);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void noContent(String content) {
        this.noContent(content, StandardCharsets.UTF_8);
    }

    protected void noContent(String content, Charset charset) {
        this.status(HttpResponseStatus.NO_CONTENT);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void nonAuthoratitativeInformation() {
        this.status(HttpResponseStatus.NON_AUTHORITATIVE_INFORMATION).end();
    }

    protected void nonAuthoratitativeInformation(Buffer buffer) {
        this.status(HttpResponseStatus.NON_AUTHORITATIVE_INFORMATION).end(buffer);
    }

    protected void nonAuthoratitativeInformation(Object object) {
        this.nonAuthoratitativeInformation(object, StandardCharsets.UTF_8);
    }

    protected void nonAuthoratitativeInformation(Object object, Charset charset) {
        this.status(HttpResponseStatus.NON_AUTHORITATIVE_INFORMATION);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void nonAuthoratitativeInformation(String content) {
        this.nonAuthoratitativeInformation(content, StandardCharsets.UTF_8);
    }

    protected void nonAuthoratitativeInformation(String content, Charset charset) {
        this.status(HttpResponseStatus.NON_AUTHORITATIVE_INFORMATION);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void notAcceptable() {
        this.status(HttpResponseStatus.NOT_ACCEPTABLE).end();
    }

    protected void notAcceptable(Buffer buffer) {
        this.status(HttpResponseStatus.NOT_ACCEPTABLE).end(buffer);
    }

    protected void notAcceptable(Object object) {
        this.notAcceptable(object, StandardCharsets.UTF_8);
    }

    protected void notAcceptable(Object object, Charset charset) {
        this.status(HttpResponseStatus.NOT_ACCEPTABLE);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void notAcceptable(String content) {
        this.notAcceptable(content, StandardCharsets.UTF_8);
    }

    protected void notAcceptable(String content, Charset charset) {
        this.status(HttpResponseStatus.NOT_ACCEPTABLE);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void notExtended() {
        this.status(HttpResponseStatus.NOT_EXTENDED).end();
    }

    protected void notExtended(Buffer buffer) {
        this.status(HttpResponseStatus.NOT_EXTENDED).end(buffer);
    }

    protected void notExtended(Object object) {
        this.notExtended(object, StandardCharsets.UTF_8);
    }

    protected void notExtended(Object object, Charset charset) {
        this.status(HttpResponseStatus.NOT_EXTENDED);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void notExtended(String content) {
        this.notExtended(content, StandardCharsets.UTF_8);
    }

    protected void notExtended(String content, Charset charset) {
        this.status(HttpResponseStatus.NOT_EXTENDED);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void notFound() {
        this.status(HttpResponseStatus.NOT_FOUND).end();
    }

    protected void notFound(Buffer buffer) {
        this.status(HttpResponseStatus.NOT_FOUND).end(buffer);
    }

    protected void notFound(Object object) {
        this.notFound(object, StandardCharsets.UTF_8);
    }

    protected void notFound(Object object, Charset charset) {
        this.status(HttpResponseStatus.NOT_FOUND);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void notFound(String content) {
        this.notFound(content, StandardCharsets.UTF_8);
    }

    protected void notFound(String content, Charset charset) {
        this.status(HttpResponseStatus.NOT_FOUND);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void notImplemented() {
        this.status(HttpResponseStatus.NOT_IMPLEMENTED).end();
    }

    protected void notImplemented(Buffer buffer) {
        this.status(HttpResponseStatus.NOT_IMPLEMENTED).end(buffer);
    }

    protected void notImplemented(Object object) {
        this.notImplemented(object, StandardCharsets.UTF_8);
    }

    protected void notImplemented(Object object, Charset charset) {
        this.status(HttpResponseStatus.NOT_IMPLEMENTED);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void notImplemented(String content) {
        this.notImplemented(content, StandardCharsets.UTF_8);
    }

    protected void notImplemented(String content, Charset charset) {
        this.status(HttpResponseStatus.NOT_IMPLEMENTED);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void notModified() {
        this.status(HttpResponseStatus.NOT_MODIFIED).end();
    }

    protected void notModified(Buffer buffer) {
        this.status(HttpResponseStatus.NOT_MODIFIED).end(buffer);
    }

    protected void notModified(Object object) {
        this.notModified(object, StandardCharsets.UTF_8);
    }

    protected void notModified(Object object, Charset charset) {
        this.status(HttpResponseStatus.NOT_MODIFIED);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void notModified(String content) {
        this.notModified(content, StandardCharsets.UTF_8);
    }

    protected void notModified(String content, Charset charset) {
        this.status(HttpResponseStatus.NOT_MODIFIED);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void ok() {
        this.success();
    }

    protected void ok(Buffer buffer) {
        this.success(buffer);
    }

    protected void ok(Object object) {
        this.success(object);
    }

    protected void ok(Object object, Charset charset) {
        this.success(object, charset);
    }

    protected void ok(String content) {
        this.success(content, StandardCharsets.UTF_8);
    }

    protected void ok(String content, Charset charset) {
        this.success(content, charset);
    }

    protected void partialContent() {
        this.status(HttpResponseStatus.PARTIAL_CONTENT).end();
    }

    protected void partialContent(Buffer buffer) {
        this.status(HttpResponseStatus.PARTIAL_CONTENT).end(buffer);
    }

    protected void partialContent(Object object) {
        this.partialContent(object, StandardCharsets.UTF_8);
    }

    protected void partialContent(Object object, Charset charset) {
        this.status(HttpResponseStatus.PARTIAL_CONTENT);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void partialContent(String content) {
        this.partialContent(content, StandardCharsets.UTF_8);
    }

    protected void partialContent(String content, Charset charset) {
        this.status(HttpResponseStatus.PARTIAL_CONTENT);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void paymentRequired() {
        this.status(HttpResponseStatus.PAYMENT_REQUIRED).end();
    }

    protected void paymentRequired(Buffer buffer) {
        this.status(HttpResponseStatus.PAYMENT_REQUIRED).end(buffer);
    }

    protected void paymentRequired(Object object) {
        this.paymentRequired(object, StandardCharsets.UTF_8);
    }

    protected void paymentRequired(Object object, Charset charset) {
        this.status(HttpResponseStatus.PAYMENT_REQUIRED);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void paymentRequired(String content) {
        this.paymentRequired(content, StandardCharsets.UTF_8);
    }

    protected void paymentRequired(String content, Charset charset) {
        this.status(HttpResponseStatus.PAYMENT_REQUIRED);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void preConditionFailed() {
        this.status(HttpResponseStatus.PRECONDITION_FAILED).end();
    }

    protected void preConditionFailed(Buffer buffer) {
        this.status(HttpResponseStatus.PRECONDITION_FAILED).end(buffer);
    }

    protected void preConditionFailed(Object object) {
        this.preConditionFailed(object, StandardCharsets.UTF_8);
    }

    protected void preConditionFailed(Object object, Charset charset) {
        this.status(HttpResponseStatus.PRECONDITION_FAILED);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void preConditionFailed(String content) {
        this.preConditionFailed(content, StandardCharsets.UTF_8);
    }

    protected void preConditionFailed(String content, Charset charset) {
        this.status(HttpResponseStatus.PRECONDITION_FAILED);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void preconditionRequired() {
        this.status(HttpResponseStatus.PRECONDITION_REQUIRED).end();
    }

    protected void preconditionRequired(Buffer buffer) {
        this.status(HttpResponseStatus.PRECONDITION_REQUIRED).end(buffer);
    }

    protected void preconditionRequired(Object object) {
        this.preconditionRequired(object, StandardCharsets.UTF_8);
    }

    protected void preconditionRequired(Object object, Charset charset) {
        this.status(HttpResponseStatus.PRECONDITION_REQUIRED);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void preconditionRequired(String content) {
        this.preconditionRequired(content, StandardCharsets.UTF_8);
    }

    protected void preconditionRequired(String content, Charset charset) {
        this.status(HttpResponseStatus.PRECONDITION_REQUIRED);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void processing() {
        this.status(HttpResponseStatus.PROCESSING).end();
    }

    protected void processing(Buffer buffer) {
        this.status(HttpResponseStatus.PROCESSING).end(buffer);
    }

    protected void processing(Object object) {
        this.processing(object, StandardCharsets.UTF_8);
    }

    protected void processing(Object object, Charset charset) {
        this.status(HttpResponseStatus.PROCESSING);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void processing(String content) {
        this.processing(content, StandardCharsets.UTF_8);
    }

    protected void processing(String content, Charset charset) {
        this.status(HttpResponseStatus.PROCESSING);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void proxyAuthenticationRequired() {
        this.status(HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED).end();
    }

    protected void proxyAuthenticationRequired(Buffer buffer) {
        this.status(HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED).end(buffer);
    }

    protected void proxyAuthenticationRequired(Object object) {
        this.proxyAuthenticationRequired(object, StandardCharsets.UTF_8);
    }

    protected void proxyAuthenticationRequired(Object object, Charset charset) {
        this.status(HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void proxyAuthenticationRequired(String content) {
        this.proxyAuthenticationRequired(content, StandardCharsets.UTF_8);
    }

    protected void proxyAuthenticationRequired(String content, Charset charset) {
        this.status(HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void requestEntityTooLarge() {
        this.status(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE).end();
    }

    protected void requestEntityTooLarge(Buffer buffer) {
        this.status(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE).end(buffer);
    }

    protected void requestEntityTooLarge(Object object) {
        this.requestEntityTooLarge(object, StandardCharsets.UTF_8);
    }

    protected void requestEntityTooLarge(Object object, Charset charset) {
        this.status(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void requestEntityTooLarge(String content) {
        this.requestEntityTooLarge(content, StandardCharsets.UTF_8);
    }

    protected void requestEntityTooLarge(String content, Charset charset) {
        this.status(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void requestHeaderFieldsTooLarge() {
        this.status(HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE).end();
    }

    protected void requestHeaderFieldsTooLarge(Buffer buffer) {
        this.status(HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE).end(buffer);
    }

    protected void requestHeaderFieldsTooLarge(Object object) {
        this.requestEntityTooLarge(object, StandardCharsets.UTF_8);
    }

    protected void requestHeaderFieldsTooLarge(Object object, Charset charset) {
        this.status(HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void requestHeaderFieldsTooLarge(String content) {
        this.requestEntityTooLarge(content, StandardCharsets.UTF_8);
    }

    protected void requestHeaderFieldsTooLarge(String content, Charset charset) {
        this.status(HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void requestRangeNotSatisfiable() {
        this.status(HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE).end();
    }

    protected void requestRangeNotSatisfiable(Buffer buffer) {
        this.status(HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE).end(buffer);
    }

    protected void requestRangeNotSatisfiable(Object object) {
        this.requestRangeNotSatisfiable(object, StandardCharsets.UTF_8);
    }

    protected void requestRangeNotSatisfiable(Object object, Charset charset) {
        this.status(HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void requestRangeNotSatisfiable(String content) {
        this.requestRangeNotSatisfiable(content, StandardCharsets.UTF_8);
    }

    protected void requestRangeNotSatisfiable(String content, Charset charset) {
        this.status(HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void requestTimeout() {
        this.status(HttpResponseStatus.REQUEST_TIMEOUT).end();
    }

    protected void requestTimeout(Buffer buffer) {
        this.status(HttpResponseStatus.REQUEST_TIMEOUT).end(buffer);
    }

    protected void requestTimeout(Object object) {
        this.requestTimeout(object, StandardCharsets.UTF_8);
    }

    protected void requestTimeout(Object object, Charset charset) {
        this.status(HttpResponseStatus.REQUEST_TIMEOUT);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void requestTimeout(String content) {
        this.requestTimeout(content, StandardCharsets.UTF_8);
    }

    protected void requestTimeout(String content, Charset charset) {
        this.status(HttpResponseStatus.REQUEST_TIMEOUT);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void requestUtiTooLong() {
        this.status(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE).end();
    }

    protected void requestUtiTooLong(Buffer buffer) {
        this.status(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE).end(buffer);
    }

    protected void requestUtiTooLong(Object object) {
        this.requestUtiTooLong(object, StandardCharsets.UTF_8);
    }

    protected void requestUtiTooLong(Object object, Charset charset) {
        this.status(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void requestUtiTooLong(String content) {
        this.requestUtiTooLong(content, StandardCharsets.UTF_8);
    }

    protected void requestUtiTooLong(String content, Charset charset) {
        this.status(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void resetContent() {
        this.status(HttpResponseStatus.RESET_CONTENT).end();
    }

    protected void resetContent(Buffer buffer) {
        this.status(HttpResponseStatus.RESET_CONTENT).end(buffer);
    }

    protected void resetContent(Object object) {
        this.resetContent(object, StandardCharsets.UTF_8);
    }

    protected void resetContent(Object object, Charset charset) {
        this.status(HttpResponseStatus.RESET_CONTENT);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void resetContent(String content) {
        this.resetContent(content, StandardCharsets.UTF_8);
    }

    protected void resetContent(String content, Charset charset) {
        this.status(HttpResponseStatus.RESET_CONTENT);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void seeOther() {
        this.status(HttpResponseStatus.SEE_OTHER).end();
    }

    protected void seeOther(Buffer buffer) {
        this.status(HttpResponseStatus.SEE_OTHER).end(buffer);
    }

    protected void seeOther(Object object) {
        this.seeOther(object, StandardCharsets.UTF_8);
    }

    protected void seeOther(Object object, Charset charset) {
        this.status(HttpResponseStatus.SEE_OTHER);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void seeOther(String content) {
        this.seeOther(content, StandardCharsets.UTF_8);
    }

    protected void seeOther(String content, Charset charset) {
        this.status(HttpResponseStatus.SEE_OTHER);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void serviceUnavailable() {
        this.status(HttpResponseStatus.SERVICE_UNAVAILABLE).end();
    }

    protected void serviceUnavailable(Buffer buffer) {
        this.status(HttpResponseStatus.SERVICE_UNAVAILABLE).end(buffer);
    }

    protected void serviceUnavailable(Object object) {
        this.serviceUnavailable(object, StandardCharsets.UTF_8);
    }

    protected void serviceUnavailable(Object object, Charset charset) {
        this.status(HttpResponseStatus.SERVICE_UNAVAILABLE);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void serviceUnavailable(String content) {
        this.serviceUnavailable(content, StandardCharsets.UTF_8);
    }

    protected void serviceUnavailable(String content, Charset charset) {
        this.status(HttpResponseStatus.SERVICE_UNAVAILABLE);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected HttpServerResponse status(HttpResponseStatus status) {
        this.res.setStatusCode(status.code());
        this.res.setStatusMessage(status.reasonPhrase());
        return this.res;
    }

    protected void success() {
        this.status(HttpResponseStatus.OK).end();
    }

    protected void success(Buffer buffer) {
        this.status(HttpResponseStatus.OK).end(buffer);
    }

    protected void success(Object object) {
        this.success(object, StandardCharsets.UTF_8);
    }

    protected void success(Object object, Charset charset) {
        this.status(HttpResponseStatus.OK);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void success(String content) {
        this.success(content, StandardCharsets.UTF_8);
    }

    protected void success(String content, Charset charset) {
        this.status(HttpResponseStatus.OK);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void switchingProtocols() {
        this.status(HttpResponseStatus.SWITCHING_PROTOCOLS).end();
    }

    protected void switchingProtocols(Buffer buffer) {
        this.status(HttpResponseStatus.SWITCHING_PROTOCOLS).end(buffer);
    }

    protected void switchingProtocols(Object object) {
        this.switchingProtocols(object, StandardCharsets.UTF_8);
    }

    protected void switchingProtocols(Object object, Charset charset) {
        this.status(HttpResponseStatus.SWITCHING_PROTOCOLS);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void switchingProtocols(String content) {
        this.switchingProtocols(content, StandardCharsets.UTF_8);
    }

    protected void switchingProtocols(String content, Charset charset) {
        this.status(HttpResponseStatus.SWITCHING_PROTOCOLS);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void temporaryRedirect() {
        this.status(HttpResponseStatus.TEMPORARY_REDIRECT).end();
    }

    protected void temporaryRedirect(Buffer buffer) {
        this.status(HttpResponseStatus.TEMPORARY_REDIRECT).end(buffer);
    }

    protected void temporaryRedirect(Object object) {
        this.temporaryRedirect(object, StandardCharsets.UTF_8);
    }

    protected void temporaryRedirect(Object object, Charset charset) {
        this.status(HttpResponseStatus.TEMPORARY_REDIRECT);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void temporaryRedirect(String content) {
        this.temporaryRedirect(content, StandardCharsets.UTF_8);
    }

    protected void temporaryRedirect(String content, Charset charset) {
        this.status(HttpResponseStatus.TEMPORARY_REDIRECT);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void tooManyRequest() {
        this.status(HttpResponseStatus.TOO_MANY_REQUESTS).end();
    }

    protected void tooManyRequest(Buffer buffer) {
        this.status(HttpResponseStatus.TOO_MANY_REQUESTS).end(buffer);
    }

    protected void tooManyRequest(Object object) {
        this.tooManyRequest(object, StandardCharsets.UTF_8);
    }

    protected void tooManyRequest(Object object, Charset charset) {
        this.status(HttpResponseStatus.TOO_MANY_REQUESTS);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void tooManyRequest(String content) {
        this.tooManyRequest(content, StandardCharsets.UTF_8);
    }

    protected void tooManyRequest(String content, Charset charset) {
        this.status(HttpResponseStatus.TOO_MANY_REQUESTS);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected String transform(Object object) {
        return Json.encode((Object)object);
    }

    protected void unauthorized() {
        this.status(HttpResponseStatus.UNAUTHORIZED).end();
    }

    protected void unauthorized(Buffer buffer) {
        this.status(HttpResponseStatus.UNAUTHORIZED).end(buffer);
    }

    protected void unauthorized(Object object) {
        this.unauthorized(object, StandardCharsets.UTF_8);
    }

    protected void unauthorized(Object object, Charset charset) {
        this.status(HttpResponseStatus.UNAUTHORIZED);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void unauthorized(String content) {
        this.unauthorized(content, StandardCharsets.UTF_8);
    }

    protected void unauthorized(String content, Charset charset) {
        this.status(HttpResponseStatus.UNAUTHORIZED);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void unorderedCollection() {
        this.status(HttpResponseStatus.UNORDERED_COLLECTION).end();
    }

    protected void unorderedCollection(Buffer buffer) {
        this.status(HttpResponseStatus.UNORDERED_COLLECTION).end(buffer);
    }

    protected void unorderedCollection(Object object) {
        this.unorderedCollection(object, StandardCharsets.UTF_8);
    }

    protected void unorderedCollection(Object object, Charset charset) {
        this.status(HttpResponseStatus.UNORDERED_COLLECTION);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void unorderedCollection(String content) {
        this.unorderedCollection(content, StandardCharsets.UTF_8);
    }

    protected void unorderedCollection(String content, Charset charset) {
        this.status(HttpResponseStatus.UNORDERED_COLLECTION);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void unprocessableEntity() {
        this.status(HttpResponseStatus.UNPROCESSABLE_ENTITY).end();
    }

    protected void unprocessableEntity(Buffer buffer) {
        this.status(HttpResponseStatus.UNPROCESSABLE_ENTITY).end(buffer);
    }

    protected void unprocessableEntity(Object object) {
        this.unprocessableEntity(object, StandardCharsets.UTF_8);
    }

    protected void unprocessableEntity(Object object, Charset charset) {
        this.status(HttpResponseStatus.UNPROCESSABLE_ENTITY);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void unprocessableEntity(String content) {
        this.unprocessableEntity(content, StandardCharsets.UTF_8);
    }

    protected void unprocessableEntity(String content, Charset charset) {
        this.status(HttpResponseStatus.UNPROCESSABLE_ENTITY);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void unsupportedMediaType() {
        this.status(HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE).end();
    }

    protected void unsupportedMediaType(Buffer buffer) {
        this.status(HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE).end(buffer);
    }

    protected void unsupportedMediaType(Object object) {
        this.unsupportedMediaType(object, StandardCharsets.UTF_8);
    }

    protected void unsupportedMediaType(Object object, Charset charset) {
        this.status(HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void unsupportedMediaType(String content) {
        this.unsupportedMediaType(content, StandardCharsets.UTF_8);
    }

    protected void unsupportedMediaType(String content, Charset charset) {
        this.status(HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void upgradeRequired() {
        this.status(HttpResponseStatus.UPGRADE_REQUIRED).end();
    }

    protected void upgradeRequired(Buffer buffer) {
        this.status(HttpResponseStatus.UPGRADE_REQUIRED).end(buffer);
    }

    protected void upgradeRequired(Object object) {
        this.upgradeRequired(object, StandardCharsets.UTF_8);
    }

    protected void upgradeRequired(Object object, Charset charset) {
        this.status(HttpResponseStatus.UPGRADE_REQUIRED);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void upgradeRequired(String content) {
        this.upgradeRequired(content, StandardCharsets.UTF_8);
    }

    protected void upgradeRequired(String content, Charset charset) {
        this.status(HttpResponseStatus.UPGRADE_REQUIRED);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void useProxy() {
        this.status(HttpResponseStatus.USE_PROXY).end();
    }

    protected void useProxy(Buffer buffer) {
        this.status(HttpResponseStatus.USE_PROXY).end(buffer);
    }

    protected void useProxy(Object object) {
        this.useProxy(object, StandardCharsets.UTF_8);
    }

    protected void useProxy(Object object, Charset charset) {
        this.status(HttpResponseStatus.USE_PROXY);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void useProxy(String content) {
        this.useProxy(content, StandardCharsets.UTF_8);
    }

    protected void useProxy(String content, Charset charset) {
        this.status(HttpResponseStatus.USE_PROXY);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    protected void variantAlsoNegotiates() {
        this.status(HttpResponseStatus.VARIANT_ALSO_NEGOTIATES).end();
    }

    protected void variantAlsoNegotiates(Buffer buffer) {
        this.status(HttpResponseStatus.VARIANT_ALSO_NEGOTIATES).end(buffer);
    }

    protected void variantAlsoNegotiates(Object object) {
        this.variantAlsoNegotiates(object, StandardCharsets.UTF_8);
    }

    protected void variantAlsoNegotiates(Object object, Charset charset) {
        this.status(HttpResponseStatus.VARIANT_ALSO_NEGOTIATES);
        this.contentType("application/json");
        this.res.setChunked(true).write(this.transform(object), StandardCharsets.UTF_8.name());
        this.end();
    }

    protected void variantAlsoNegotiates(String content) {
        this.variantAlsoNegotiates(content, StandardCharsets.UTF_8);
    }

    protected void variantAlsoNegotiates(String content, Charset charset) {
        this.status(HttpResponseStatus.VARIANT_ALSO_NEGOTIATES);
        if (this.isValidJson(content)) {
            this.contentType("application/json");
        }
        this.res.setChunked(true);
        this.res.write(content, charset.name());
        this.end();
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public void setReq(HttpServerRequest req) {
        this.req = req;
    }

    public void setRes(HttpServerResponse res) {
        this.res = res;
    }

    public void setContext(RoutingContext context) {
        this.context = context;
    }

    public void setSockJSEvent(SockJSSocket sockJSEvent) {
        this.sockJSEvent = sockJSEvent;
    }
}

